/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.adversaries.fs.AdversarialOutputStream;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class RotatingFileOutputStreamSupplierTest {
    private static final long TEST_TIMEOUT_MILLIS = 10000L;
    private static final Executor DIRECT_EXECUTOR = Runnable::run;
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fileSystem);
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private File logFile;
    private File archiveLogFile1;
    private File archiveLogFile2;
    private File archiveLogFile3;
    private File archiveLogFile4;
    private File archiveLogFile5;
    private File archiveLogFile6;
    private File archiveLogFile7;
    private File archiveLogFile8;
    private File archiveLogFile9;

    @Before
    public void setup() {
        File logDir = this.testDirectory.directory();
        this.logFile = new File(logDir, "logfile.log");
        this.archiveLogFile1 = new File(logDir, "logfile.log.1");
        this.archiveLogFile2 = new File(logDir, "logfile.log.2");
        this.archiveLogFile3 = new File(logDir, "logfile.log.3");
        this.archiveLogFile4 = new File(logDir, "logfile.log.4");
        this.archiveLogFile5 = new File(logDir, "logfile.log.5");
        this.archiveLogFile6 = new File(logDir, "logfile.log.6");
        this.archiveLogFile7 = new File(logDir, "logfile.log.7");
        this.archiveLogFile8 = new File(logDir, "logfile.log.8");
        this.archiveLogFile9 = new File(logDir, "logfile.log.9");
    }

    @Test
    public void createsLogOnConstruction() throws Exception {
        new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 250000L, 0L, 10, DIRECT_EXECUTOR);
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
    }

    @Test
    public void rotatesLogWhenSizeExceeded() throws Exception {
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(supplier, "Short");
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void limitsNumberOfArchivedLogs() throws Exception {
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 2, DIRECT_EXECUTOR);
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
    }

    @Test(timeout=10000L)
    public void rotationShouldNotDeadlockOnListener() throws Exception {
        final String logContent = "Output file created";
        final AtomicReference<Object> listenerException = new AtomicReference<Object>(null);
        final CountDownLatch latch = new CountDownLatch(1);
        RotatingFileOutputStreamSupplier.RotationListener listener = new RotatingFileOutputStreamSupplier.RotationListener(){

            public void outputFileCreated(OutputStream out) {
                try {
                    Thread thread = new Thread(() -> {
                        try {
                            out.write(logContent.getBytes());
                            out.flush();
                        }
                        catch (IOException e) {
                            listenerException.set(e);
                        }
                    });
                    thread.start();
                    thread.join();
                }
                catch (Exception e) {
                    listenerException.set(e);
                }
                super.outputFileCreated(out);
            }

            public void rotationCompleted(OutputStream out) {
                latch.countDown();
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        DefaultFileSystemAbstraction defaultFileSystemAbstraction = new DefaultFileSystemAbstraction();
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)defaultFileSystemAbstraction, this.logFile, 0L, 0L, 10, (Executor)executor, listener);
        OutputStream outputStream = supplier.get();
        LockingPrintWriter lockingPrintWriter = new LockingPrintWriter(outputStream);
        lockingPrintWriter.withLock(() -> {
            supplier.rotate();
            latch.await();
            return Void.TYPE;
        });
        this.shutDownExecutor(executor);
        List<String> strings = Files.readAllLines(this.logFile.toPath());
        String actual = String.join((CharSequence)"", strings);
        Assert.assertEquals((Object)logContent, (Object)actual);
        Assert.assertNull(listenerException.get());
    }

    private void shutDownExecutor(ExecutorService executor) throws InterruptedException {
        executor.shutdown();
        boolean terminated = executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        if (!terminated) {
            throw new IllegalStateException("Rotation execution failed to complete within reasonable time.");
        }
    }

    @Test
    public void shouldNotRotateLogWhenSizeExceededButNotDelay() throws Exception {
        UpdatableLongSupplier clock = new UpdatableLongSupplier(System.currentTimeMillis());
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((LongSupplier)clock, this.fileSystem, this.logFile, 10L, TimeUnit.SECONDS.toMillis(60L), 10, DIRECT_EXECUTOR, new RotatingFileOutputStreamSupplier.RotationListener());
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(supplier, "A string longer than 10 bytes");
        clock.setValue(clock.getAsLong() + TimeUnit.SECONDS.toMillis(59L));
        this.write(supplier, "A string longer than 10 bytes");
        clock.setValue(clock.getAsLong() + TimeUnit.SECONDS.toMillis(1L));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotifyListenerWhenNewLogIsCreated() throws Exception {
        final CountDownLatch allowRotationComplete = new CountDownLatch(1);
        final CountDownLatch rotationComplete = new CountDownLatch(1);
        final String outputFileCreatedMessage = "Output file created";
        final String rotationCompleteMessage = "Rotation complete";
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.spy((Object)new RotatingFileOutputStreamSupplier.RotationListener(){

            public void outputFileCreated(OutputStream out) {
                try {
                    allowRotationComplete.await(1L, TimeUnit.SECONDS);
                    out.write(outputFileCreatedMessage.getBytes());
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            public void rotationCompleted(OutputStream out) {
                rotationComplete.countDown();
                try {
                    out.write(rotationCompleteMessage.getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ExecutorService rotationExecutor = Executors.newSingleThreadExecutor();
        try {
            RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, (Executor)rotationExecutor, rotationListener);
            this.write(supplier, "A string longer than 10 bytes");
            this.write(supplier, "A string longer than 10 bytes");
            allowRotationComplete.countDown();
            rotationComplete.await(1L, TimeUnit.SECONDS);
            ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).outputFileCreated((OutputStream)Matchers.any(OutputStream.class));
            ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationCompleted((OutputStream)Matchers.any(OutputStream.class));
        }
        finally {
            this.shutDownExecutor(rotationExecutor);
        }
    }

    @Test
    public void shouldNotifyListenerOnRotationErrorDuringJobExecution() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, executor, rotationListener);
        OutputStream outputStream = supplier.get();
        RejectedExecutionException exception = new RejectedExecutionException("text exception");
        ((Executor)Mockito.doThrow((Throwable)exception).when((Object)executor)).execute((Runnable)Matchers.any(Runnable.class));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationError((Exception)exception, outputStream);
    }

    @Test
    public void shouldReattemptRotationAfterExceptionDuringJobExecution() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, executor, rotationListener);
        OutputStream outputStream = supplier.get();
        RejectedExecutionException exception = new RejectedExecutionException("text exception");
        ((Executor)Mockito.doThrow((Throwable)exception).when((Object)executor)).execute((Runnable)Matchers.any(Runnable.class));
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener, (VerificationMode)Mockito.times((int)2))).rotationError((Exception)exception, outputStream);
    }

    @Test
    public void shouldNotifyListenerOnRotationErrorDuringRotationIO() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.spy((Object)this.fileSystem);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(fs, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR, rotationListener);
        OutputStream outputStream = supplier.get();
        IOException exception = new IOException("text exception");
        ((FileSystemAbstraction)Mockito.doThrow((Throwable)exception).when((Object)fs)).renameFile((File)Matchers.any(File.class), (File)Matchers.any(File.class), new CopyOption[0]);
        this.write(supplier, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationError((Exception)Matchers.eq((Object)exception), (OutputStream)Matchers.any(OutputStream.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotUpdateOutputStreamWhenClosedDuringRotation() throws Exception {
        final CountDownLatch allowRotationComplete = new CountDownLatch(1);
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.spy((Object)new RotatingFileOutputStreamSupplier.RotationListener(){

            public void outputFileCreated(OutputStream out) {
                try {
                    allowRotationComplete.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        final ArrayList mockStreams = new ArrayList();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fileSystem){

            public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
                OutputStream stream = (OutputStream)Mockito.spy((Object)super.openAsOutputStream(fileName, append));
                mockStreams.add(stream);
                return stream;
            }
        };
        ExecutorService rotationExecutor = Executors.newSingleThreadExecutor();
        try {
            RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)fs, this.logFile, 10L, 0L, 10, (Executor)rotationExecutor, rotationListener);
            OutputStream outputStream = supplier.get();
            this.write(supplier, "A string longer than 10 bytes");
            Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
            allowRotationComplete.countDown();
            supplier.close();
        }
        finally {
            this.shutDownExecutor(rotationExecutor);
        }
        this.assertStreamClosed((OutputStream)mockStreams.get(0));
    }

    @Test
    public void shouldCloseAllOutputStreams() throws Exception {
        final ArrayList mockStreams = new ArrayList();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fileSystem){

            public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
                OutputStream stream = (OutputStream)Mockito.spy((Object)super.openAsOutputStream(fileName, append));
                mockStreams.add(stream);
                return stream;
            }
        };
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)fs, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        this.write(supplier, "A string longer than 10 bytes");
        supplier.close();
        this.assertStreamClosed((OutputStream)mockStreams.get(0));
    }

    @Test
    public void shouldCloseAllStreamsDespiteError() throws Exception {
        final ArrayList mockStreams = new ArrayList();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fileSystem){

            public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
                OutputStream stream = (OutputStream)Mockito.spy((Object)super.openAsOutputStream(fileName, append));
                mockStreams.add(stream);
                return stream;
            }
        };
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)fs, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        this.write(supplier, "A string longer than 10 bytes");
        this.write(supplier, "A string longer than 10 bytes");
        IOException exception = new IOException("test exception");
        OutputStream mockStream = (OutputStream)mockStreams.get(1);
        ((OutputStream)Mockito.doThrow((Throwable)exception).when((Object)mockStream)).close();
        try {
            supplier.close();
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.sameInstance((Object)exception));
        }
        ((OutputStream)Mockito.verify((Object)mockStream)).close();
    }

    @Test
    public void shouldSurviveFilesystemErrors() throws Exception {
        RandomAdversary adversary = new RandomAdversary(0.1, 0.1, 0.0);
        adversary.setProbabilityFactor(0.0);
        SensibleAdversarialFileSystemAbstraction adversarialFileSystem = new SensibleAdversarialFileSystemAbstraction((Adversary)adversary, this.fileSystem);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)adversarialFileSystem, this.logFile, 1000L, 0L, 9, DIRECT_EXECUTOR);
        adversary.setProbabilityFactor(1.0);
        this.writeLines((Supplier<OutputStream>)supplier, 10000);
        adversary.setProbabilityFactor(0.0);
        this.writeLines((Supplier<OutputStream>)supplier, 10000);
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile4), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile5), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile6), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile7), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile8), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile9), (Matcher)Is.is((Object)true));
    }

    private void write(RotatingFileOutputStreamSupplier supplier, String line) {
        PrintWriter writer = new PrintWriter(supplier.get());
        writer.println(line);
        writer.flush();
    }

    private void writeLines(Supplier<OutputStream> outputStreamSupplier, int count) throws InterruptedException {
        Supplier printWriterSupplier = Suppliers.adapted(outputStreamSupplier, (Function)FormattedLog.OUTPUT_STREAM_CONVERTER);
        while (count >= 0) {
            ((PrintWriter)printWriterSupplier.get()).println("We are what we repeatedly do. Excellence, then, is not an act, but a habit.");
            Thread.yield();
            --count;
        }
    }

    private void assertStreamClosed(OutputStream stream) throws IOException {
        try {
            stream.write(0);
            Assert.fail((String)"Expected ClosedChannelException");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static class SensibleAdversarialFileSystemAbstraction
    extends AdversarialFileSystemAbstraction {
        private final Adversary adversary;
        private final FileSystemAbstraction delegate;

        SensibleAdversarialFileSystemAbstraction(Adversary adversary, FileSystemAbstraction delegate) {
            super(adversary, delegate);
            this.adversary = adversary;
            this.delegate = delegate;
        }

        public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
            this.adversary.injectFailure(new Class[]{FileNotFoundException.class});
            final OutputStream outputStream = this.delegate.openAsOutputStream(fileName, append);
            return new AdversarialOutputStream(outputStream, this.adversary){

                public void write(byte[] b) throws IOException {
                    adversary.injectFailure(new Class[]{IOException.class});
                    outputStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    adversary.injectFailure(new Class[]{IOException.class});
                    outputStream.write(b, off, len);
                }
            };
        }

        public boolean fileExists(File fileName) {
            return this.delegate.fileExists(fileName);
        }

        public long getFileSize(File fileName) {
            return this.delegate.getFileSize(fileName);
        }
    }

    private static class UpdatableLongSupplier
    implements LongSupplier {
        private final AtomicLong longValue;

        UpdatableLongSupplier(long value) {
            this.longValue = new AtomicLong(value);
        }

        long setValue(long value) {
            return this.longValue.getAndSet(value);
        }

        @Override
        public long getAsLong() {
            return this.longValue.get();
        }
    }

    private class LockingPrintWriter
    extends PrintWriter {
        LockingPrintWriter(OutputStream out) {
            super(out);
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void withLock(Callable callable) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                callable.call();
            }
        }
    }
}

