/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.mem.NativeMemoryAllocationRefusedError;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.FeatureToggles;

public final class GrabAllocator
implements MemoryAllocator {
    private static final Object globalCleanerInstance = GrabAllocator.globalCleaner();
    private final Grabs grabs;
    private final Object cleaner;
    private final MethodHandle cleanHandle;

    GrabAllocator(long expectedMaxMemory, MemoryAllocationTracker memoryTracker) {
        this.grabs = new Grabs(expectedMaxMemory, memoryTracker);
        try {
            CleanerHandles handles = GrabAllocator.findCleanerHandles();
            this.cleaner = handles.creator.invoke(this, new GrabsDeallocator(this.grabs));
            this.cleanHandle = handles.cleaner;
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unable to instantiate cleaner", throwable);
        }
    }

    @Override
    public synchronized long usedMemory() {
        return this.grabs.usedMemory();
    }

    @Override
    public synchronized long availableMemory() {
        return this.grabs.availableMemory();
    }

    @Override
    public synchronized long allocateAligned(long bytes, long alignment) {
        return this.grabs.allocateAligned(bytes, alignment);
    }

    @Override
    public void close() {
        try {
            this.cleanHandle.invoke(this.cleaner);
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unable to clean cleaner.", throwable);
        }
    }

    private static Object globalCleaner() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> newCleaner = Class.forName("java.lang.ref.Cleaner");
            MethodHandle createInstance = lookup.findStatic(newCleaner, "create", MethodType.methodType(newCleaner));
            return createInstance.invoke();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static CleanerHandles findCleanerHandles() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        return globalCleanerInstance == null ? GrabAllocator.findHandlesForOldCleaner(lookup) : GrabAllocator.findHandlesForNewCleaner(lookup);
    }

    private static CleanerHandles findHandlesForNewCleaner(MethodHandles.Lookup lookup) {
        try {
            Objects.requireNonNull(globalCleanerInstance);
            Class<?> newCleaner = globalCleanerInstance.getClass();
            Class<?> newCleanable = Class.forName("java.lang.ref.Cleaner$Cleanable");
            MethodHandle registerHandle = GrabAllocator.findCreationMethod("register", lookup, newCleaner);
            registerHandle = registerHandle.bindTo(globalCleanerInstance);
            return CleanerHandles.of(registerHandle, GrabAllocator.findCleanMethod(lookup, newCleanable));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException newCleanerException) {
            throw new LinkageError("Unable to find cleaner methods.", newCleanerException);
        }
    }

    private static CleanerHandles findHandlesForOldCleaner(MethodHandles.Lookup lookup) {
        try {
            Class<?> oldCleaner = Class.forName("sun.misc.Cleaner");
            return CleanerHandles.of(GrabAllocator.findCreationMethod("create", lookup, oldCleaner), GrabAllocator.findCleanMethod(lookup, oldCleaner));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException oldCleanerException) {
            throw new LinkageError("Unable to find cleaner methods.", oldCleanerException);
        }
    }

    private static MethodHandle findCleanMethod(MethodHandles.Lookup lookup, Class<?> cleaner) throws IllegalAccessException, NoSuchMethodException {
        return lookup.unreflect(cleaner.getDeclaredMethod("clean", new Class[0]));
    }

    private static MethodHandle findCreationMethod(String methodName, MethodHandles.Lookup lookup, Class<?> cleaner) throws IllegalAccessException, NoSuchMethodException {
        return lookup.unreflect(cleaner.getDeclaredMethod(methodName, Object.class, Runnable.class));
    }

    private static final class GrabsDeallocator
    implements Runnable {
        private final Grabs grabs;

        GrabsDeallocator(Grabs grabs) {
            this.grabs = grabs;
        }

        @Override
        public void run() {
            this.grabs.close();
        }
    }

    private static final class CleanerHandles {
        private final MethodHandle creator;
        private final MethodHandle cleaner;

        static CleanerHandles of(MethodHandle creator, MethodHandle cleaner) {
            return new CleanerHandles(creator, cleaner);
        }

        private CleanerHandles(MethodHandle creator, MethodHandle cleaner) {
            this.creator = creator;
            this.cleaner = cleaner;
        }
    }

    private static final class Grabs {
        private static final long GRAB_SIZE = FeatureToggles.getInteger(GrabAllocator.class, (String)"GRAB_SIZE", (int)((int)ByteUnit.kibiBytes(512L)));
        private final MemoryAllocationTracker memoryTracker;
        private long expectedMaxMemory;
        private Grab head;

        Grabs(long expectedMaxMemory, MemoryAllocationTracker memoryTracker) {
            this.expectedMaxMemory = expectedMaxMemory;
            this.memoryTracker = memoryTracker;
        }

        long usedMemory() {
            long sum = 0L;
            Grab grab = this.head;
            while (grab != null) {
                sum += grab.nextPointer - grab.address;
                grab = grab.next;
            }
            return sum;
        }

        long availableMemory() {
            Grab grab = this.head;
            long availableInCurrentGrab = 0L;
            if (grab != null) {
                availableInCurrentGrab = grab.limit - grab.nextPointer;
            }
            return Math.max(this.expectedMaxMemory, 0L) + availableInCurrentGrab;
        }

        public void close() {
            Grab current = this.head;
            while (current != null) {
                current.free();
                current = current.next;
            }
            this.head = null;
        }

        long allocateAligned(long bytes, long alignment) {
            if (alignment <= 0L) {
                throw new IllegalArgumentException("Invalid alignment: " + alignment + ". Alignment must be positive.");
            }
            long grabSize = Math.min(GRAB_SIZE, this.expectedMaxMemory);
            try {
                if (bytes > GRAB_SIZE) {
                    Grab nextGrab = this.head == null ? null : this.head.next;
                    Grab allocationGrab = new Grab(nextGrab, grabSize = bytes, this.memoryTracker);
                    if (!allocationGrab.canAllocate(bytes, alignment)) {
                        allocationGrab.free();
                        grabSize = bytes + alignment;
                        allocationGrab = new Grab(nextGrab, grabSize, this.memoryTracker);
                    }
                    long allocation = allocationGrab.allocate(bytes, alignment);
                    this.head = this.head == null ? allocationGrab : this.head.setNext(allocationGrab);
                    this.expectedMaxMemory -= bytes;
                    return allocation;
                }
                if (this.head == null || !this.head.canAllocate(bytes, alignment)) {
                    if (grabSize < bytes) {
                        grabSize = bytes;
                        Grab grab = new Grab(this.head, grabSize, this.memoryTracker);
                        if (grab.canAllocate(bytes, alignment)) {
                            this.expectedMaxMemory -= grabSize;
                            this.head = grab;
                            return this.head.allocate(bytes, alignment);
                        }
                        grab.free();
                        grabSize = bytes + alignment;
                    }
                    this.head = new Grab(this.head, grabSize, this.memoryTracker);
                    this.expectedMaxMemory -= grabSize;
                }
                return this.head.allocate(bytes, alignment);
            }
            catch (OutOfMemoryError oome) {
                NativeMemoryAllocationRefusedError error = new NativeMemoryAllocationRefusedError(grabSize, this.usedMemory());
                Grabs.initCause(error, oome);
                throw error;
            }
        }

        private static void initCause(NativeMemoryAllocationRefusedError error, OutOfMemoryError cause) {
            try {
                error.initCause(cause);
            }
            catch (Throwable ignore) {
                try {
                    error.addSuppressed(cause);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class Grab {
        public final Grab next;
        private final long address;
        private final long limit;
        private final MemoryAllocationTracker memoryTracker;
        private long nextPointer;

        Grab(Grab next, long size, MemoryAllocationTracker memoryTracker) {
            this.next = next;
            this.address = UnsafeUtil.allocateMemory((long)size, (MemoryAllocationTracker)memoryTracker);
            this.limit = this.address + size;
            this.memoryTracker = memoryTracker;
            this.nextPointer = this.address;
        }

        Grab(Grab next, long address, long limit, long nextPointer, MemoryAllocationTracker memoryTracker) {
            this.next = next;
            this.address = address;
            this.limit = limit;
            this.nextPointer = nextPointer;
            this.memoryTracker = memoryTracker;
        }

        private long nextAligned(long pointer, long alignment) {
            if (alignment == 1L) {
                return pointer;
            }
            long off = pointer % alignment;
            if (off == 0L) {
                return pointer;
            }
            return pointer + (alignment - off);
        }

        long allocate(long bytes, long alignment) {
            long allocation = this.nextAligned(this.nextPointer, alignment);
            this.nextPointer = allocation + bytes;
            return allocation;
        }

        void free() {
            UnsafeUtil.free((long)this.address, (long)(this.limit - this.address), (MemoryAllocationTracker)this.memoryTracker);
        }

        boolean canAllocate(long bytes, long alignment) {
            return this.nextAligned(this.nextPointer, alignment) + bytes <= this.limit;
        }

        Grab setNext(Grab grab) {
            return new Grab(grab, this.address, this.limit, this.nextPointer, this.memoryTracker);
        }

        public String toString() {
            long size = this.limit - this.address;
            long reserve = this.nextPointer > this.limit ? 0L : this.limit - this.nextPointer;
            double use = (1.0 - (double)reserve / (double)size) * 100.0;
            return String.format("Grab[size = %d bytes, reserve = %d bytes, use = %5.2f %%]", size, reserve, use);
        }
    }
}

