/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.StubPageCursor;
import org.neo4j.io.pagecache.impl.CompositePageCursor;
import org.neo4j.test.matchers.ByteArrayMatcher;

class CompositePageCursorTest {
    private static final int PAGE_SIZE = 16;
    private StubPageCursor first;
    private StubPageCursor second;
    private byte[] bytes = new byte[4];

    CompositePageCursorTest() {
    }

    private StubPageCursor generatePage(int initialPageId, int pageSize, int initialValue) {
        StubPageCursor cursor = new StubPageCursor((long)initialPageId, pageSize);
        for (int i = 0; i < pageSize; ++i) {
            cursor.putByte(i, (byte)(initialValue + i));
        }
        return cursor;
    }

    @BeforeEach
    void setUp() {
        this.first = this.generatePage(0, 16, 160);
        this.second = this.generatePage(2, 24, 176);
    }

    @Test
    void getByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-95));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-96));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-79));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.setOffset(0);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)1));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        c.putByte((byte)2);
        c.setOffset(1);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)2));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)1);
        c.putByte((byte)1);
        MatcherAssert.assertThat((Object)this.first.getByte(1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-80));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)2);
        c.putByte((byte)1);
        c.putByte((byte)2);
        MatcherAssert.assertThat((Object)this.second.getByte(1), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-78));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)1);
        MatcherAssert.assertThat((Object)c.getByte(1), (Matcher)Matchers.is((Object)-94));
        MatcherAssert.assertThat((Object)c.getByte(2), (Matcher)Matchers.is((Object)-78));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putByteWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putByte(1, (byte)1);
        c.putByte(2, (byte)2);
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-95));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getByte(), (Matcher)Matchers.is((Object)-77));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24158));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24415));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20046));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.setOffset(0);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)1));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        c.putShort((short)2);
        c.setOffset(2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)2));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)2);
        c.putShort((short)1);
        MatcherAssert.assertThat((Object)this.first.getShort(1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20303));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)2, (PageCursor)this.second, (int)4);
        c.putShort((short)1);
        c.putShort((short)2);
        MatcherAssert.assertThat((Object)this.second.getShort(1), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-19532));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)3, (PageCursor)this.second, (int)2);
        MatcherAssert.assertThat((Object)c.getShort(1), (Matcher)Matchers.is((Object)-23901));
        MatcherAssert.assertThat((Object)c.getShort(3), (Matcher)Matchers.is((Object)-19789));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putShortWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putShort(2, (short)1);
        c.putShort(4, (short)2);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-24158));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-19275));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1583176796));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1600019805));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1313688652));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.setOffset(0);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)1));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        c.putInt(2);
        c.setOffset(4);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)2));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putInt(1);
        MatcherAssert.assertThat((Object)this.first.getInt(1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1330531661));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)8);
        c.putInt(1);
        c.putInt(2);
        MatcherAssert.assertThat((Object)this.second.getInt(1), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1246316616));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)5, (PageCursor)this.second, (int)4);
        MatcherAssert.assertThat((Object)c.getInt(1), (Matcher)Matchers.is((Object)-1566333787));
        MatcherAssert.assertThat((Object)c.getInt(5), (Matcher)Matchers.is((Object)-1296845643));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putIntWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putInt(4, 1);
        c.putInt(8, 2);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1583176796));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1229473607));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6799692559826901080L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6872032732664977753L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5642249794417674312L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.setOffset(0);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)1L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        c.putLong(2L);
        c.setOffset(8);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)2L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        c.putLong(1L);
        MatcherAssert.assertThat((Object)this.first.getLong(1), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5714589967255750985L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)16);
        c.putLong(1L);
        c.putLong(2L);
        MatcherAssert.assertThat((Object)this.second.getLong(1), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-5063528411713060928L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getLongWithOffsetMustHitCorrectCursors() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)9, (PageCursor)this.second, (int)8);
        MatcherAssert.assertThat((Object)c.getLong(1), (Matcher)Matchers.is((Object)-6727352386988824407L));
        MatcherAssert.assertThat((Object)c.getLong(9), (Matcher)Matchers.is((Object)-5569909621579597639L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putLongWithOffsetMustHitCorrectCursors() {
        this.first = this.generatePage(0, 24, 160);
        this.second = this.generatePage(0, 24, 192);
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putLong(8, 1L);
        c.putLong(16, 2L);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6799692559826901080L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-3833745473465757487L));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{161, 162, 163, 164}));
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void getBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{160, 161, 162, 163}));
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{177, 178, 179, 180}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustHitFirstCursorBeforeFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)4, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1, 2, 3, 4});
        c.setOffset(0);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1, 2, 3, 4}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustHitSecondCursorAfterFlip() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        c.setOffset(1);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{2}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustRespectOffsetIntoFirstCursor() {
        this.first.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)4);
        c.putBytes(new byte[]{1});
        this.first.setOffset(1);
        this.first.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1}));
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{176, 177, 178, 179}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void putBytesMustRespectOffsetIntoSecondCursor() {
        this.second.setOffset(1);
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)1, (PageCursor)this.second, (int)8);
        c.putBytes(new byte[]{1});
        c.putBytes(new byte[]{2});
        this.second.setOffset(1);
        this.second.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)Arrays.copyOfRange(this.bytes, 0, 1), (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{2}));
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{181, 182, 183, 184}));
        Assertions.assertFalse((boolean)c.checkAndClearBoundsFlag());
    }

    @Test
    void overlappingGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)-1364217679));
        c.setOffset(15);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)-20560));
        c.setOffset(12);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)-6003950658608057677L));
        c.setOffset(14);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{174, 175, 176, 177}));
    }

    @Test
    void overlappingOffsetGetAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        MatcherAssert.assertThat((Object)c.getInt(14), (Matcher)Matchers.is((Object)-1364217679));
        MatcherAssert.assertThat((Object)c.getShort(15), (Matcher)Matchers.is((Object)-20560));
        MatcherAssert.assertThat((Object)c.getLong(12), (Matcher)Matchers.is((Object)-6003950658608057677L));
    }

    @Test
    void overlappingPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.setOffset(14);
        c.putInt(16909060);
        c.setOffset(14);
        MatcherAssert.assertThat((Object)c.getInt(), (Matcher)Matchers.is((Object)16909060));
        c.setOffset(15);
        c.putShort((short)258);
        c.setOffset(15);
        MatcherAssert.assertThat((Object)c.getShort(), (Matcher)Matchers.is((Object)258));
        c.setOffset(12);
        c.putLong(72623859790382856L);
        c.setOffset(12);
        MatcherAssert.assertThat((Object)c.getLong(), (Matcher)Matchers.is((Object)72623859790382856L));
        c.setOffset(14);
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = (byte)(i + 1);
        }
        c.putBytes(this.bytes);
        c.setOffset(14);
        c.getBytes(this.bytes);
        MatcherAssert.assertThat((Object)this.bytes, (Matcher)ByteArrayMatcher.byteArray((int[])new int[]{1, 2, 3, 4}));
    }

    @Test
    void overlappingOffsetPutAccess() {
        PageCursor c = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        c.putInt(14, 16909060);
        MatcherAssert.assertThat((Object)c.getInt(14), (Matcher)Matchers.is((Object)16909060));
        c.putShort(15, (short)258);
        MatcherAssert.assertThat((Object)c.getShort(15), (Matcher)Matchers.is((Object)258));
        c.putLong(12, 72623859790382856L);
        MatcherAssert.assertThat((Object)c.getLong(12), (Matcher)Matchers.is((Object)72623859790382856L));
    }

    @Test
    void closeBothCursorsOnClose() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.close();
        Assertions.assertTrue((boolean)this.first.isClosed());
        Assertions.assertTrue((boolean)this.second.isClosed());
    }

    @Test
    void nextIsNotSupportedOperation() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.next();
        });
    }

    @Test
    void nextWithPageIdIsNotSupportedOperation() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.next(12L);
        });
    }

    @Test
    void rewindCompositeCursor() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong();
        pageCursor.getLong();
        pageCursor.getLong();
        pageCursor.rewind();
        Assertions.assertEquals((int)0, (int)pageCursor.getOffset());
        Assertions.assertEquals((int)1, (int)this.first.getOffset());
        Assertions.assertEquals((int)2, (int)this.second.getOffset());
    }

    @Test
    public void markCompositeCursor() {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.getByte();
        this.second.getLong();
        int firstMark = this.first.getOffset();
        int secondMark = this.second.getOffset();
        pageCursor.mark();
        this.first.getByte();
        this.second.getLong();
        Assertions.assertNotEquals((Object)firstMark, (Object)this.first.getOffset());
        Assertions.assertNotEquals((Object)secondMark, (Object)this.second.getOffset());
        pageCursor.setOffsetToMark();
        Assertions.assertEquals((int)firstMark, (int)this.first.getOffset());
        Assertions.assertEquals((int)secondMark, (int)this.second.getOffset());
    }

    @Test
    void getOffsetMustReturnOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong();
        MatcherAssert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)8));
        pageCursor.getLong();
        pageCursor.getLong();
        MatcherAssert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)24));
    }

    @Test
    void setOffsetMustSetOffsetIntoView() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.setOffset(13);
        MatcherAssert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)13));
        MatcherAssert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)0));
        pageCursor.setOffset(18);
        MatcherAssert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)16));
        MatcherAssert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    void raisingOutOfBoundsFlagMustRaiseOutOfBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.raiseOutOfBounds();
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void currentPageSizeIsUnsupported() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.getCurrentPageSize();
        });
    }

    @Test
    void pageIdEqualFirstCursorPageIdBeforeFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assertions.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assertions.assertEquals((long)this.first.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assertions.assertNotEquals((Object)this.first.getCurrentPageId(), (Object)pageCursor.getCurrentPageId());
    }

    @Test
    void pageIdEqualSecondCursorPageIdAfterFlip() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assertions.assertNotEquals((Object)this.second.getCurrentPageId(), (Object)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assertions.assertNotEquals((Object)this.second.getCurrentPageId(), (Object)pageCursor.getCurrentPageId());
        pageCursor.getLong();
        Assertions.assertEquals((long)this.second.getCurrentPageId(), (long)pageCursor.getCurrentPageId());
    }

    @Test
    void retryShouldCheckAndResetBothCursors() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        Assertions.assertFalse((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(true);
        Assertions.assertTrue((boolean)pageCursor.shouldRetry());
        this.first.setNeedsRetry(false);
        Assertions.assertFalse((boolean)pageCursor.shouldRetry());
        this.second.setNeedsRetry(true);
        Assertions.assertTrue((boolean)pageCursor.shouldRetry());
    }

    @Test
    void retryMustResetOffsetsInBothCursors() throws Exception {
        this.first.setOffset(1);
        this.second.setOffset(2);
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)8, (PageCursor)this.second, (int)8);
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        MatcherAssert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)0));
        pageCursor.setOffset(5);
        this.first.setOffset(3);
        this.second.setOffset(4);
        this.first.setNeedsRetry(false);
        this.second.setNeedsRetry(true);
        pageCursor.shouldRetry();
        MatcherAssert.assertThat((Object)this.first.getOffset(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.second.getOffset(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)pageCursor.getOffset(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    void retryMustClearTheOutOfBoundsFlags() throws Exception {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.raiseOutOfBounds();
        this.second.raiseOutOfBounds();
        pageCursor.raiseOutOfBounds();
        this.first.setNeedsRetry(true);
        pageCursor.shouldRetry();
        Assertions.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void checkAndClearCompositeBoundsFlagMustClearFirstBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.raiseOutOfBounds();
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)this.first.checkAndClearBoundsFlag());
    }

    @Test
    void checkAndClearCompositeBoundsFlagMustClearSecondBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.raiseOutOfBounds();
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)this.second.checkAndClearBoundsFlag());
    }

    @Test
    void composeMustNotThrowIfFirstLengthExpandsBeyondFirstPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)Integer.MAX_VALUE, (PageCursor)this.second, (int)16);
    }

    @Test
    void composeMustNotThrowIfSecondLengthExpandsBeyondSecondPage() {
        CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)Integer.MAX_VALUE);
    }

    @Test
    void compositeCursorDoesNotSupportCopyTo() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> {
            PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
            pageCursor.copyTo(0, (PageCursor)new StubPageCursor(0L, 7), 89, 6);
        });
    }

    @Test
    void getByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getByte();
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getByte(i);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte((byte)1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putByte(i, (byte)1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getByte(-1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putByte(-1, (byte)1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort();
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getShort(i);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort((short)1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putShort(i, (short)1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getShortOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getShort(-1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putShortOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putShort(-1, (short)1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt();
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getInt(i);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putInt(i, 1);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getIntOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getInt(-1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putIntOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putInt(-1, 1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong();
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getLong(i);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(1L);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongOffsetBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putLong(i, 1L);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getLongOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.getLong(-1);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putLongOffsetBeforeFirstPageMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        pageCursor.putLong(-1, 1L);
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void getByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.getBytes(this.bytes);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void putByteArrayBeyondEndOfViewMustRaiseBoundsFlag() {
        PageCursor pageCursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        for (int i = 0; i < 48; ++i) {
            pageCursor.putBytes(this.bytes);
        }
        Assertions.assertTrue((boolean)pageCursor.checkAndClearBoundsFlag());
        Assertions.assertFalse((boolean)pageCursor.checkAndClearBoundsFlag());
    }

    @Test
    void setCursorErrorMustApplyToCursorAtCurrentOffset() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        String firstMsg = "first boo";
        String secondMsg = "second boo";
        cursor.setCursorException(firstMsg);
        Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.first.checkAndClearCursorException();
            Assertions.fail((String)"first checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)firstMsg));
        }
        cursor.setOffset(16);
        cursor.setCursorException(secondMsg);
        Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        try {
            this.second.checkAndClearCursorException();
            Assertions.fail((String)"second checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)secondMsg));
        }
    }

    @Test
    void checkAndClearCursorErrorMustNotThrowIfNoErrorsAreSet() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        cursor.checkAndClearCursorException();
    }

    @Test
    void checkAndClearCursorErrorMustThrowIfFirstCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
    }

    @Test
    void checkAndClearCursorErrorMustThrowIfSecondCursorHasError() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.second.setCursorException("boo");
        try {
            cursor.checkAndClearCursorException();
            Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
    }

    @Test
    void checkAndClearCursorErrorWillOnlyCheckFirstCursorIfBothHaveErrorsSet() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        try {
            cursor.checkAndClearCursorException();
            Assertions.fail((String)"composite cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"first boo"));
        }
        try {
            this.second.checkAndClearCursorException();
            Assertions.fail((String)"second cursor checkAndClearCursorError should have thrown");
        }
        catch (CursorException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"second boo"));
        }
    }

    @Test
    void clearCursorErrorMustClearBothCursors() throws Exception {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setCursorException("first boo");
        this.second.setCursorException("second boo");
        cursor.clearCursorException();
        this.first.checkAndClearCursorException();
        this.second.checkAndClearCursorException();
        cursor.checkAndClearCursorException();
    }

    @Test
    void isWriteLockedMustBeTrueIfBothCursorsAreWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(true);
        Assertions.assertTrue((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfBothCursorsAreNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(false);
        Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfFirstCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(false);
        this.second.setWriteLocked(true);
        Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }

    @Test
    void isWriteLockedMustBeFalseIfSecondCursorIsNotWriteLocked() {
        PageCursor cursor = CompositePageCursor.compose((PageCursor)this.first, (int)16, (PageCursor)this.second, (int)16);
        this.first.setWriteLocked(true);
        this.second.setWriteLocked(false);
        Assertions.assertFalse((boolean)cursor.isWriteLocked());
    }
}

