/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.harness;

import java.io.File;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.PageCountRecordFormat;
import org.neo4j.io.pagecache.randomharness.Phase;
import org.neo4j.io.pagecache.randomharness.RandomPageCacheTestHarness;
import org.neo4j.io.pagecache.randomharness.RecordFormat;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;

abstract class PageCacheHarnessTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    PageCacheHarnessTest() {
    }

    @RepeatedTest(value=10)
    void readsAndWritesMustBeMutuallyConsistent() {
        Assertions.assertTimeout((Duration)Duration.ofMillis(120000L), () -> {
            int filePageCount = 100;
            try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
                harness.disableCommands(Command.FlushCache, Command.FlushFile, Command.MapFile, Command.UnmapFile);
                harness.setCommandProbabilityFactor(Command.ReadRecord, 0.5);
                harness.setCommandProbabilityFactor(Command.WriteRecord, 0.5);
                harness.setConcurrencyLevel(8);
                harness.setFilePageCount(filePageCount);
                harness.setInitialMappedFiles(1);
                harness.setVerification(this.filesAreCorrectlyWrittenVerification(new StandardRecordFormat(), filePageCount));
                harness.run(120000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Test
    void concurrentPageFaultingMustNotPutInterleavedDataIntoPages() {
        Assertions.assertTimeout((Duration)Duration.ofMillis(360000L), () -> {
            int filePageCount = 11;
            PageCountRecordFormat recordFormat = new PageCountRecordFormat();
            try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
                harness.setConcurrencyLevel(11);
                harness.setUseAdversarialIO(false);
                harness.setCachePageCount(3);
                harness.setFilePageCount(11);
                harness.setInitialMappedFiles(1);
                harness.setCommandCount(10000);
                harness.setRecordFormat(recordFormat);
                harness.setFileSystem(this.fs);
                harness.disableCommands(Command.FlushCache, Command.FlushFile, Command.MapFile, Command.UnmapFile, Command.WriteRecord, Command.WriteMulti);
                harness.setPreparation((cache, fs, filesTouched) -> {
                    File file = (File)filesTouched.iterator().next();
                    try (PagedFile pf = cache.map(file, cache.pageSize(), new OpenOption[0]);
                         PageCursor cursor = pf.io(0L, 2);){
                        for (int pageId = 0; pageId < 11; ++pageId) {
                            cursor.next();
                            recordFormat.fillWithRecords(cursor);
                        }
                    }
                });
                harness.run(360000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Test
    void concurrentFlushingMustNotPutInterleavedDataIntoFile() {
        Assertions.assertTimeout((Duration)Duration.ofMillis(360000L), () -> {
            StandardRecordFormat recordFormat = new StandardRecordFormat();
            int filePageCount = 2000;
            try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
                harness.setConcurrencyLevel(16);
                harness.setUseAdversarialIO(false);
                harness.setCachePageCount(1000);
                harness.setFilePageCount(2000);
                harness.setInitialMappedFiles(3);
                harness.setCommandCount(15000);
                harness.setFileSystem(this.fs);
                harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
                harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 2000));
                harness.run(360000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Test
    void concurrentFlushingWithMischiefMustNotPutInterleavedDataIntoFile() {
        Assertions.assertTimeout((Duration)Duration.ofMillis(360000L), () -> {
            StandardRecordFormat recordFormat = new StandardRecordFormat();
            int filePageCount = 2000;
            try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
                harness.setConcurrencyLevel(16);
                harness.setUseAdversarialIO(true);
                harness.setMischiefRate(0.5);
                harness.setFailureRate(0.0);
                harness.setErrorRate(0.0);
                harness.setCachePageCount(1000);
                harness.setFilePageCount(2000);
                harness.setInitialMappedFiles(3);
                harness.setCommandCount(15000);
                harness.setFileSystem(this.fs);
                harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
                harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 2000));
                harness.run(360000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Test
    void concurrentFlushingWithFailuresMustNotPutInterleavedDataIntoFile() {
        Assertions.assertTimeout((Duration)Duration.ofMillis(360000L), () -> {
            StandardRecordFormat recordFormat = new StandardRecordFormat();
            int filePageCount = 2000;
            try (RandomPageCacheTestHarness harness = new RandomPageCacheTestHarness();){
                harness.setConcurrencyLevel(16);
                harness.setUseAdversarialIO(true);
                harness.setMischiefRate(0.0);
                harness.setFailureRate(0.5);
                harness.setErrorRate(0.0);
                harness.setCachePageCount(1000);
                harness.setFilePageCount(2000);
                harness.setInitialMappedFiles(3);
                harness.setCommandCount(15000);
                harness.setFileSystem(this.fs);
                harness.disableCommands(Command.MapFile, Command.UnmapFile, Command.ReadRecord, Command.ReadMulti);
                harness.setVerification(this.filesAreCorrectlyWrittenVerification(recordFormat, 2000));
                harness.run(360000L, TimeUnit.MILLISECONDS);
            }
        });
    }

    private Phase filesAreCorrectlyWrittenVerification(RecordFormat recordFormat, int filePageCount) {
        return (cache, fs1, filesTouched) -> {
            for (File file : filesTouched) {
                try (PagedFile pf = cache.map(file, cache.pageSize(), new OpenOption[0]);
                     PageCursor cursor = pf.io(0L, 1);){
                    for (int pageId = 0; pageId < filePageCount && cursor.next(); ++pageId) {
                        try {
                            recordFormat.assertRecordsWrittenCorrectly(cursor);
                            continue;
                        }
                        catch (Throwable th) {
                            th.addSuppressed(new Exception("pageId = " + pageId));
                            throw th;
                        }
                    }
                }
                StoreChannel channel = fs1.open(file, OpenMode.READ);
                var8_8 = null;
                try {
                    recordFormat.assertRecordsWrittenCorrectly(file, channel);
                }
                catch (Throwable throwable) {
                    var8_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (channel == null) continue;
                    if (var8_8 != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                        continue;
                    }
                    channel.close();
                }
            }
        };
    }
}

