/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.impl.DelegatingPageCursor;

public class CompositePageCursor
extends PageCursor {
    private final PageCursor first;
    private final int firstBaseOffset;
    private final int firstLength;
    private final PageCursor second;
    private final int secondBaseOffset;
    private final int secondLength;
    private int offset;
    private PageCursor byteAccessCursor;
    private boolean outOfBounds;

    private CompositePageCursor(PageCursor first, int firstBaseOffset, int firstLength, PageCursor second, int secondBaseOffset, int secondLength) {
        this.first = first;
        this.firstBaseOffset = firstBaseOffset;
        this.firstLength = firstLength;
        this.second = second;
        this.secondBaseOffset = secondBaseOffset;
        this.secondLength = secondLength;
        this.byteAccessCursor = new DelegatingPageCursor(this){
            private int offset;

            @Override
            public int getInt() {
                int a = this.getByte(this.offset) & 0xFF;
                int b = this.getByte(this.offset + 1) & 0xFF;
                int c = this.getByte(this.offset + 2) & 0xFF;
                int d = this.getByte(this.offset + 3) & 0xFF;
                int v = a << 24 | b << 16 | c << 8 | d;
                return v;
            }

            @Override
            public int getInt(int offset) {
                this.offset = offset;
                return this.getInt();
            }

            @Override
            public short getShort() {
                int a = this.getByte(this.offset) & 0xFF;
                int b = this.getByte(this.offset + 1) & 0xFF;
                int v = a << 8 | b;
                return (short)v;
            }

            @Override
            public short getShort(int offset) {
                this.offset = offset;
                return this.getShort();
            }

            @Override
            public long getLong() {
                long a = this.getByte(this.offset) & 0xFF;
                long b = this.getByte(this.offset + 1) & 0xFF;
                long c = this.getByte(this.offset + 2) & 0xFF;
                long d = this.getByte(this.offset + 3) & 0xFF;
                long e = this.getByte(this.offset + 4) & 0xFF;
                long f = this.getByte(this.offset + 5) & 0xFF;
                long g = this.getByte(this.offset + 6) & 0xFF;
                long h = this.getByte(this.offset + 7) & 0xFF;
                long v = a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
                return v;
            }

            @Override
            public long getLong(int offset) {
                this.offset = offset;
                return this.getLong();
            }

            @Override
            public void getBytes(byte[] data) {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = this.getByte(this.offset + i);
                }
            }

            @Override
            public void putInt(int value) {
                this.putByte(this.offset, (byte)(value >> 24));
                this.putByte(this.offset + 1, (byte)(value >> 16 & 0xFF));
                this.putByte(this.offset + 2, (byte)(value >> 8 & 0xFF));
                this.putByte(this.offset + 3, (byte)(value & 0xFF));
            }

            @Override
            public void putInt(int offset, int value) {
                this.offset = offset;
                this.putInt(value);
            }

            @Override
            public void putShort(short value) {
                this.putByte(this.offset, (byte)(value >> 8));
                this.putByte(this.offset + 1, (byte)(value & 0xFF));
            }

            @Override
            public void putShort(int offset, short value) {
                this.offset = offset;
                this.putShort(value);
            }

            @Override
            public void putLong(long value) {
                this.putByte(this.offset, (byte)(value >> 56));
                this.putByte(this.offset + 1, (byte)(value >> 48 & 0xFFL));
                this.putByte(this.offset + 2, (byte)(value >> 40 & 0xFFL));
                this.putByte(this.offset + 3, (byte)(value >> 32 & 0xFFL));
                this.putByte(this.offset + 4, (byte)(value >> 24 & 0xFFL));
                this.putByte(this.offset + 5, (byte)(value >> 16 & 0xFFL));
                this.putByte(this.offset + 6, (byte)(value >> 8 & 0xFFL));
                this.putByte(this.offset + 7, (byte)(value & 0xFFL));
            }

            @Override
            public void putLong(int offset, long value) {
                this.offset = offset;
                this.putLong(value);
            }

            @Override
            public void putBytes(byte[] data) {
                for (int i = 0; i < data.length; ++i) {
                    this.putByte(this.offset + i, data[i]);
                }
            }

            @Override
            public void setOffset(int offset) {
                this.offset = offset;
            }
        };
    }

    private PageCursor cursor(int width) {
        return this.cursor(this.offset, width);
    }

    private PageCursor cursor(int offset, int width) {
        this.outOfBounds |= offset + width > this.firstLength + this.secondLength;
        if (offset < this.firstLength) {
            return offset + width <= this.firstLength ? this.first : this.byteCursor(offset);
        }
        return this.second;
    }

    private PageCursor byteCursor(int offset) {
        this.byteAccessCursor.setOffset(offset);
        return this.byteAccessCursor;
    }

    private int relative(int offset) {
        return offset < this.firstLength ? this.firstBaseOffset + offset : this.secondBaseOffset + (offset - this.firstLength);
    }

    @Override
    public byte getByte() {
        PageCursor cursor = this.cursor(1);
        byte b = cursor.getByte();
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        return this.cursor(offset, 1).getByte(this.relative(offset));
    }

    @Override
    public void putByte(byte value) {
        PageCursor cursor = this.cursor(1);
        cursor.putByte(value);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        this.cursor(offset, 1).putByte(this.relative(offset), value);
    }

    @Override
    public long getLong() {
        long l = this.cursor(8).getLong();
        this.offset += 8;
        return l;
    }

    @Override
    public long getLong(int offset) {
        return this.cursor(offset, 8).getLong(this.relative(offset));
    }

    @Override
    public void putLong(long value) {
        this.cursor(8).putLong(value);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        this.cursor(offset, 8).putLong(this.relative(offset), value);
    }

    @Override
    public int getInt() {
        int i = this.cursor(4).getInt();
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        return this.cursor(offset, 4).getInt(this.relative(offset));
    }

    @Override
    public void putInt(int value) {
        PageCursor cursor = this.cursor(4);
        cursor.putInt(value);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        this.cursor(offset, 4).putInt(this.relative(offset), value);
    }

    @Override
    public void getBytes(byte[] data) {
        this.cursor(data.length).getBytes(data);
        this.offset += data.length;
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        throw new UnsupportedOperationException("Composite page cursor does not yet support this operation");
    }

    @Override
    public void putBytes(byte[] data) {
        this.cursor(data.length).putBytes(data);
        this.offset += data.length;
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new UnsupportedOperationException("Composite page cursor does not yet support this operation");
    }

    @Override
    public void putBytes(int bytes, byte value) {
        throw new UnsupportedOperationException("Composite page cursor does not yet support this operation");
    }

    @Override
    public short getShort() {
        short s = this.cursor(2).getShort();
        this.offset += 2;
        return s;
    }

    @Override
    public short getShort(int offset) {
        return this.cursor(offset, 2).getShort(this.relative(offset));
    }

    @Override
    public void putShort(short value) {
        this.cursor(2).putShort(value);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        this.cursor(offset, 2).putShort(this.relative(offset), value);
    }

    @Override
    public void setOffset(int offset) {
        if (offset < this.firstLength) {
            this.first.setOffset(this.firstBaseOffset + offset);
            this.second.setOffset(this.secondBaseOffset);
        } else {
            this.first.setOffset(this.firstBaseOffset + this.firstLength);
            this.second.setOffset(this.secondBaseOffset + (offset - this.firstLength));
        }
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void mark() {
        this.first.mark();
        this.second.mark();
    }

    @Override
    public void setOffsetToMark() {
        this.first.setOffsetToMark();
        this.second.setOffsetToMark();
    }

    @Override
    public long getCurrentPageId() {
        return this.cursor(0).getCurrentPageId();
    }

    @Override
    public int getCurrentPageSize() {
        throw new UnsupportedOperationException("Getting current page size is not supported on compose PageCursor");
    }

    @Override
    public File getCurrentFile() {
        return null;
    }

    @Override
    public void rewind() {
        this.first.setOffset(this.firstBaseOffset);
        this.second.setOffset(this.secondBaseOffset);
        this.offset = 0;
    }

    @Override
    public boolean next() {
        throw this.unsupportedNext();
    }

    private UnsupportedOperationException unsupportedNext() {
        return new UnsupportedOperationException("Composite cursor does not support next operation. Please operate directly on underlying cursors.");
    }

    @Override
    public boolean next(long pageId) {
        throw this.unsupportedNext();
    }

    @Override
    public void close() {
        this.first.close();
        this.second.close();
    }

    @Override
    public boolean shouldRetry() throws IOException {
        boolean needsRetry = this.first.shouldRetry() | this.second.shouldRetry();
        if (needsRetry) {
            this.rewind();
            this.checkAndClearBoundsFlag();
        }
        return needsRetry;
    }

    @Override
    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        throw new UnsupportedOperationException("Composite cursor does not support copyTo functionality.");
    }

    @Override
    public int copyTo(int sourceOffset, ByteBuffer targetBuffer) {
        throw new UnsupportedOperationException("Composite cursor does not support copyTo functionality.");
    }

    @Override
    public void shiftBytes(int sourceOffset, int length, int shift) {
        throw new UnsupportedOperationException("Composite cursor does not support shiftBytes functionality... yet.");
    }

    @Override
    public boolean checkAndClearBoundsFlag() {
        boolean bounds = this.outOfBounds | this.first.checkAndClearBoundsFlag() | this.second.checkAndClearBoundsFlag();
        this.outOfBounds = false;
        return bounds;
    }

    @Override
    public void checkAndClearCursorException() throws CursorException {
        this.first.checkAndClearCursorException();
        this.second.checkAndClearCursorException();
    }

    @Override
    public void raiseOutOfBounds() {
        this.outOfBounds = true;
    }

    @Override
    public void setCursorException(String message) {
        this.cursor(0).setCursorException(message);
    }

    @Override
    public void clearCursorException() {
        this.first.clearCursorException();
        this.second.clearCursorException();
    }

    @Override
    public PageCursor openLinkedCursor(long pageId) {
        throw new UnsupportedOperationException("Linked cursors are not supported for composite cursors");
    }

    @Override
    public void zapPage() {
        this.first.zapPage();
        this.second.zapPage();
    }

    @Override
    public boolean isWriteLocked() {
        return this.first.isWriteLocked() && this.second.isWriteLocked();
    }

    public static PageCursor compose(PageCursor first, int firstLength, PageCursor second, int secondLength) {
        return new CompositePageCursor(first, first.getOffset(), firstLength, second, second.getOffset(), secondLength);
    }
}

