/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class EphemeralFileSystemExtensionTest {
    @Inject
    EphemeralFileSystemAbstraction rootFileSystem;

    EphemeralFileSystemExtensionTest() {
    }

    @Test
    void fileSystemInjectionCreateFileSystem() {
        Assertions.assertNotNull((Object)this.rootFileSystem);
    }

    @Nested
    class NestedFileSystemTest {
        @Inject
        EphemeralFileSystemAbstraction nestedFileSystem;

        NestedFileSystemTest() {
        }

        @Test
        void nestedFileSystemInjection() {
            Assertions.assertNotNull((Object)this.nestedFileSystem);
        }

        @Test
        void rootFileSystemAvailable() {
            Assertions.assertNotNull((Object)EphemeralFileSystemExtensionTest.this.rootFileSystem);
        }

        @Test
        void nestedAndRootFileSystemsAreTheSame() {
            Assertions.assertSame((Object)this.nestedFileSystem, (Object)EphemeralFileSystemExtensionTest.this.rootFileSystem);
        }
    }
}

