/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.proc;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.io.proc.ProcessUtil;

class ProcessUtilTest {
    private static final String HELLO_WORLD = "Hello World";

    ProcessUtilTest() {
    }

    public static void main(String[] args) {
        System.out.println(HELLO_WORLD);
    }

    @Test
    void mustFindWorkingJavaExecutableAndClassPath() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ProcessUtil.getJavaExecutable().toString());
        command.add("-cp");
        command.add(ProcessUtil.getClassPath());
        command.add(this.getClass().getName());
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = builder.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = in.readLine();
        MatcherAssert.assertThat((Object)process.waitFor(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)line, (Matcher)Matchers.equalTo((Object)HELLO_WORLD));
    }
}

