/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.GrabAllocator;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

class MemoryAllocatorTest {
    private static final String ONE_PAGE = "8192";
    private static final String EIGHT_PAGES = "65536";

    MemoryAllocatorTest() {
    }

    private MemoryAllocator createAllocator(String expectedMaxMemory) {
        return MemoryAllocator.createAllocator((String)expectedMaxMemory, (MemoryAllocationTracker)new LocalMemoryTracker());
    }

    @Test
    void allocatedPointerMustNotBeNull() {
        MemoryAllocator mman = this.createAllocator(EIGHT_PAGES);
        long address = mman.allocateAligned(8192L, 8L);
        MatcherAssert.assertThat((Object)address, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    void allocatedPointerMustBePageAligned() {
        MemoryAllocator mman = this.createAllocator(EIGHT_PAGES);
        long address = mman.allocateAligned(8192L, (long)UnsafeUtil.pageSize());
        MatcherAssert.assertThat((Object)(address % (long)UnsafeUtil.pageSize()), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    void allocatedPointerMustBeAlignedToArbitraryByte() {
        int pageSize = UnsafeUtil.pageSize();
        for (int initialOffset = 0; initialOffset < 8; ++initialOffset) {
            for (int i = 0; i < pageSize - 1; ++i) {
                MemoryAllocator mman = this.createAllocator(ONE_PAGE);
                mman.allocateAligned((long)initialOffset, 1L);
                long alignment = 1 + i;
                long address = mman.allocateAligned(8192L, alignment);
                MatcherAssert.assertThat((String)("With initial offset " + initialOffset + ", iteration " + i + ", aligning to " + alignment + " and got address " + address), (Object)(address % alignment), (Matcher)Matchers.is((Object)0L));
            }
        }
    }

    @Test
    void mustBeAbleToAllocatePastMemoryLimit() {
        MemoryAllocator mman = this.createAllocator(ONE_PAGE);
        for (int i = 0; i < 4100; ++i) {
            MatcherAssert.assertThat((Object)(mman.allocateAligned(1L, 2L) % 2L), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void allocatedPointersMustBeAlignedPastMemoryLimit() {
        MemoryAllocator mman = this.createAllocator(ONE_PAGE);
        for (int i = 0; i < 4100; ++i) {
            MatcherAssert.assertThat((Object)(mman.allocateAligned(1L, 2L) % 2L), (Matcher)Matchers.is((Object)0L));
        }
        int pageSize = UnsafeUtil.pageSize();
        for (int i = 0; i < pageSize - 1; ++i) {
            int alignment = pageSize - i;
            long address = mman.allocateAligned(8192L, (long)alignment);
            MatcherAssert.assertThat((String)("iteration " + i + ", aligning to " + alignment), (Object)(address % (long)alignment), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void alignmentCannotBeZero() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createAllocator(ONE_PAGE).allocateAligned(8L, 0L));
    }

    @Test
    void mustBeAbleToAllocateSlabsLargerThanGrabSize() {
        MemoryAllocator mman = this.createAllocator("2 MiB");
        long page1 = mman.allocateAligned((long)UnsafeUtil.pageSize(), 1L);
        long largeBlock = mman.allocateAligned(0x100000L, 1L);
        long page2 = mman.allocateAligned((long)UnsafeUtil.pageSize(), 1L);
        MatcherAssert.assertThat((Object)page1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        MatcherAssert.assertThat((Object)largeBlock, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        MatcherAssert.assertThat((Object)page2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    void allocatingMustIncreaseMemoryUsedAndDecreaseAvailableMemory() {
        MemoryAllocator mman = this.createAllocator(ONE_PAGE);
        MatcherAssert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Object)8192L));
        mman.allocateAligned(32L, 1L);
        MatcherAssert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(32L))));
        MatcherAssert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8160L))));
        mman.allocateAligned(32L, 1L);
        MatcherAssert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(64L))));
        MatcherAssert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8128L))));
        mman.allocateAligned(1L, 1L);
        mman.allocateAligned(32L, 16L);
        MatcherAssert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(97L))));
        MatcherAssert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8095L))));
    }

    @Test
    void trackMemoryAllocations() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        GrabAllocator allocator = (GrabAllocator)MemoryAllocator.createAllocator((String)"2m", (MemoryAllocationTracker)memoryTracker);
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
        long pointer = allocator.allocateAligned(ByteUnit.mebiBytes((long)1L), 1L);
        Assertions.assertEquals((long)ByteUnit.mebiBytes((long)1L), (long)memoryTracker.usedDirectMemory());
        allocator.close();
        Assertions.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
    }
}

