/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.util.VisibleForTesting;

public class TestDirectory
extends ExternalResource {
    private static final String DEFAULT_DATABASE_DIRECTORY = "graph.db";
    private final FileSystemAbstraction fileSystem;
    private File testClassBaseFolder;
    private Class<?> owningTest;
    private boolean keepDirectoryAfterSuccessfulTest;
    private File testDirectory;

    private TestDirectory(FileSystemAbstraction fileSystem) {
        this.fileSystem = fileSystem;
    }

    private TestDirectory(FileSystemAbstraction fileSystem, Class<?> owningTest) {
        this.fileSystem = fileSystem;
        this.owningTest = owningTest;
    }

    public static TestDirectory testDirectory() {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction());
    }

    public static TestDirectory testDirectory(FileSystemAbstraction fs) {
        return new TestDirectory(fs);
    }

    public static TestDirectory testDirectory(Class<?> owningTest) {
        return new TestDirectory((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest);
    }

    public static TestDirectory testDirectory(Class<?> owningTest, FileSystemAbstraction fs) {
        return new TestDirectory(fs, owningTest);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestDirectory.this.directoryForDescription(description);
                boolean success = false;
                try {
                    base.evaluate();
                    success = true;
                }
                finally {
                    TestDirectory.this.complete(success);
                }
            }
        };
    }

    public TestDirectory keepDirectoryAfterSuccessfulTest() {
        this.keepDirectoryAfterSuccessfulTest = true;
        return this;
    }

    public File absolutePath() {
        return this.directory().getAbsoluteFile();
    }

    public File directory() {
        if (this.testDirectory == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.testDirectory;
    }

    public File directory(String name) {
        File dir = new File(this.directory(), name);
        if (!this.fileSystem.fileExists(dir)) {
            this.fileSystem.mkdir(dir);
        }
        return dir;
    }

    public File file(String name) {
        return new File(this.directory(), name);
    }

    public File databaseDir() {
        return this.directory(DEFAULT_DATABASE_DIRECTORY);
    }

    public File storeDir() {
        return this.directory();
    }

    public File storeDir(String storeDirName) {
        return this.directory(storeDirName);
    }

    public File databaseDir(File storeDirectory) {
        File directory = new File(storeDirectory, DEFAULT_DATABASE_DIRECTORY);
        try {
            this.fileSystem.mkdirs(directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create directory: " + directory, e);
        }
        return directory;
    }

    public File databaseDir(String customStoreDirectoryName) {
        return this.databaseDir(this.storeDir(customStoreDirectoryName));
    }

    public void cleanup() throws IOException {
        TestDirectory.clean(this.fileSystem, this.testClassBaseFolder);
    }

    public String toString() {
        String testDirectoryName = this.testDirectory == null ? "<uninitialized>" : this.testDirectory.toString();
        return String.format("%s[\"%s\"]", ((Object)((Object)this)).getClass().getSimpleName(), testDirectoryName);
    }

    public File cleanDirectory(String name) throws IOException {
        return TestDirectory.clean(this.fileSystem, new File(this.ensureBase(), name));
    }

    public void complete(boolean success) throws IOException {
        try {
            if (success && this.testDirectory != null && !this.keepDirectoryAfterSuccessfulTest) {
                this.fileSystem.deleteRecursively(this.testDirectory);
            }
            this.testDirectory = null;
        }
        finally {
            this.fileSystem.close();
        }
    }

    public void prepareDirectory(Class<?> testClass, String test) throws IOException {
        if (this.owningTest == null) {
            this.owningTest = testClass;
        }
        if (test == null) {
            test = "static";
        }
        this.testDirectory = this.prepareDirectoryForTest(test);
    }

    public File prepareDirectoryForTest(String test) throws IOException {
        String dir = DigestUtils.md5Hex((String)test);
        this.evaluateClassBaseTestFolder();
        this.register(test, dir);
        return this.cleanDirectory(dir);
    }

    @VisibleForTesting
    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    private void directoryForDescription(Description description) throws IOException {
        this.prepareDirectory(description.getTestClass(), description.getMethodName());
    }

    private static File clean(FileSystemAbstraction fs, File dir) throws IOException {
        if (fs.fileExists(dir)) {
            fs.deleteRecursively(dir);
        }
        fs.mkdirs(dir);
        return dir;
    }

    private void evaluateClassBaseTestFolder() {
        if (this.owningTest == null) {
            throw new IllegalStateException(" Test owning class is not defined");
        }
        this.testClassBaseFolder = TestDirectory.testDataDirectoryOf(this.owningTest);
    }

    private static File testDataDirectoryOf(Class<?> owningTest) {
        File testData = new File(TestDirectory.locateTarget(owningTest), "test data");
        return new File(testData, TestDirectory.shorten(owningTest.getName())).getAbsoluteFile();
    }

    private static String shorten(String owningTestName) {
        int targetPartLength = 5;
        CharSequence[] parts = owningTestName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.length() <= targetPartLength) continue;
            parts[i] = part.substring(0, targetPartLength - 1) + "~";
        }
        return String.join((CharSequence)".", parts);
    }

    private void register(String test, String dir) {
        try (PrintStream printStream = new PrintStream(this.fileSystem.openAsOutputStream(new File(this.ensureBase(), ".register"), true));){
            printStream.println(String.format("%s=%s\n", dir, test));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File ensureBase() {
        if (this.testClassBaseFolder == null) {
            this.evaluateClassBaseTestFolder();
        }
        if (this.fileSystem.fileExists(this.testClassBaseFolder) && !this.fileSystem.isDirectory(this.testClassBaseFolder)) {
            throw new IllegalStateException(this.testClassBaseFolder + " exists and is not a directory!");
        }
        try {
            this.fileSystem.mkdirs(this.testClassBaseFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.testClassBaseFolder;
    }

    private static File locateTarget(Class<?> owningTest) {
        try {
            File codeSource = new File(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (codeSource.isDirectory()) {
                return codeSource.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new File("target");
    }
}

