/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.StoreChannel;

public class ChannelOutputStream
extends OutputStream {
    private final StoreChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocate(8096);

    public ChannelOutputStream(StoreChannel channel, boolean append) throws IOException {
        this.channel = channel;
        if (append) {
            this.channel.position(this.channel.size());
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.clear();
        this.buffer.put((byte)b);
        this.buffer.flip();
        this.channel.write(this.buffer);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int index = off;
        for (int written = 0; written < len; written += this.channel.write(this.buffer)) {
            this.buffer.clear();
            this.buffer.put(b, index + written, Math.min(len - written, this.buffer.capacity()));
            this.buffer.flip();
        }
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

