/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={DefaultFileSystemExtension.class, TestDirectoryExtension.class})
class TestDirectoryExtensionTest {
    @Inject
    TestDirectory testDirectory;
    @Inject
    DefaultFileSystemAbstraction fileSystem;

    TestDirectoryExtensionTest() {
    }

    @Test
    void testDirectoryInjectionWorks() {
        Assertions.assertNotNull((Object)((Object)this.testDirectory));
    }

    @Test
    void testDirectoryInitialisedForUsage() {
        File directory = this.testDirectory.directory();
        Assertions.assertNotNull((Object)directory);
        Assertions.assertTrue((boolean)directory.exists());
        Path targetTestData = Paths.get("target", "test-data");
        Assertions.assertTrue((boolean)directory.getAbsolutePath().contains(targetTestData.toString()));
    }

    @Test
    void testDirectoryUsesFileSystemFromExtension() {
        Assertions.assertSame((Object)this.fileSystem, (Object)this.testDirectory.getFileSystem());
    }
}

