/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.StatefullFieldExtension;
import org.neo4j.test.rule.TestDirectory;

public class TestDirectoryExtension
extends StatefullFieldExtension<TestDirectory>
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String TEST_DIRECTORY = "testDirectory";
    private static final ExtensionContext.Namespace TEST_DIRECTORY_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"testDirectory"});

    public void beforeEach(ExtensionContext context) throws Exception {
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        testDirectory.prepareDirectory(context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        TestDirectory testDirectory = (TestDirectory)((Object)this.getStoredValue(context));
        testDirectory.complete(context.getExecutionException().isPresent());
    }

    protected String getFieldKey() {
        return TEST_DIRECTORY;
    }

    protected Class<TestDirectory> getFieldType() {
        return TestDirectory.class;
    }

    protected TestDirectory createField(ExtensionContext extensionContext) {
        ExtensionContext.Store fileSystemStore = this.getStore(extensionContext, DefaultFileSystemExtension.FILE_SYSTEM_NAMESPACE);
        FileSystemAbstraction fileSystemAbstraction = (FileSystemAbstraction)fileSystemStore.get((Object)"fileSystem", FileSystemAbstraction.class);
        return fileSystemAbstraction != null ? TestDirectory.testDirectory(fileSystemAbstraction) : TestDirectory.testDirectory();
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return TEST_DIRECTORY_NAMESPACE;
    }
}

