/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.test.extension.DefaultFileSystemExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={DefaultFileSystemExtension.class})
class DefaultFileSystemExtensionTest {
    @Inject
    DefaultFileSystemAbstraction rootFileSystem;

    DefaultFileSystemExtensionTest() {
    }

    @Test
    void fileSystemInjectionCreateFileSystem() {
        Assertions.assertNotNull((Object)this.rootFileSystem);
    }

    @Nested
    class NestedFileSystemTest {
        @Inject
        DefaultFileSystemAbstraction nestedFileSystem;

        NestedFileSystemTest() {
        }

        @Test
        void nestedFileSystemInjection() {
            Assertions.assertNotNull((Object)this.nestedFileSystem);
        }

        @Test
        void rootFileSystemAvailable() {
            Assertions.assertNotNull((Object)DefaultFileSystemExtensionTest.this.rootFileSystem);
        }

        @Test
        void nestedAndRootFileSystemsAreTheSame() {
            Assertions.assertSame((Object)this.nestedFileSystem, (Object)DefaultFileSystemExtensionTest.this.rootFileSystem);
        }
    }
}

