/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardCopyOption;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;

public class EphemeralFileSystemAbstraction
implements FileSystemAbstraction {
    private final Clock clock;
    private volatile boolean closed;
    private final Set<File> directories = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<File, EphemeralFileData> files;
    private final Map<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem> thirdPartyFileSystems = new HashMap<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem>();

    public EphemeralFileSystemAbstraction() {
        this(Clock.systemUTC());
    }

    public EphemeralFileSystemAbstraction(Clock clock) {
        this.clock = clock;
        this.files = new ConcurrentHashMap<File, EphemeralFileData>();
        this.initCurrentWorkingDirectory();
    }

    private void initCurrentWorkingDirectory() {
        try {
            this.mkdirs(new File(".").getCanonicalFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException("EphemeralFileSystemAbstraction could not initialise current working directory", e);
        }
    }

    private EphemeralFileSystemAbstraction(Set<File> directories, Map<File, EphemeralFileData> files, Clock clock) {
        this.clock = clock;
        this.files = new ConcurrentHashMap<File, EphemeralFileData>(files);
        this.directories.addAll(directories);
        this.initCurrentWorkingDirectory();
    }

    public void crash() {
        this.files.values().forEach(EphemeralFileData::crash);
    }

    public synchronized void close() throws IOException {
        this.closeFiles();
        this.closeFileSystems();
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void closeFileSystems() throws IOException {
        IOUtils.closeAll(this.thirdPartyFileSystems.values());
        this.thirdPartyFileSystems.clear();
    }

    private void closeFiles() {
        for (EphemeralFileData file : this.files.values()) {
            file.free();
        }
        this.files.clear();
    }

    public void assertNoOpenFiles() throws Exception {
        FileStillOpenException exception = null;
        for (EphemeralFileData file : this.files.values()) {
            Iterator<EphemeralFileChannel> channels = file.getOpenChannels();
            while (channels.hasNext()) {
                EphemeralFileChannel channel = channels.next();
                if (exception == null) {
                    exception = channel.openedAt;
                    continue;
                }
                exception.addSuppressed(channel.openedAt);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void dumpZip(OutputStream output) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(output);){
            File directory;
            String prefix = null;
            for (Map.Entry<File, EphemeralFileData> entry : this.files.entrySet()) {
                File file = entry.getKey();
                String parent = file.getParentFile().getAbsolutePath();
                if (prefix == null || prefix.startsWith(parent)) {
                    prefix = parent;
                }
                zip.putNextEntry(new ZipEntry(file.getAbsolutePath()));
                entry.getValue().dumpTo(zip);
                zip.closeEntry();
            }
            for (FileSystemAbstraction.ThirdPartyFileSystem fs : this.thirdPartyFileSystems.values()) {
                fs.dumpToZip(zip, (byte[])EphemeralFileData.SCRATCH_PAD.get());
            }
            if (prefix != null && (directory = new File(prefix)).exists()) {
                this.addRecursively(zip, directory);
            }
        }
    }

    private void addRecursively(ZipOutputStream output, File input) throws IOException {
        if (input.isFile()) {
            output.putNextEntry(new ZipEntry(input.getAbsolutePath()));
            byte[] scratchPad = (byte[])EphemeralFileData.SCRATCH_PAD.get();
            try (FileInputStream source = new FileInputStream(input);){
                int read;
                while (0 <= (read = source.read(scratchPad))) {
                    output.write(scratchPad, 0, read);
                }
            }
            output.closeEntry();
        } else {
            File[] children = input.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.addRecursively(output, child);
                }
            }
        }
    }

    public FileWatcher fileWatcher() {
        return FileWatcher.SILENT_WATCHER;
    }

    public synchronized StoreChannel open(File fileName, OpenMode openMode) throws IOException {
        EphemeralFileData data = this.files.get(this.canonicalFile(fileName));
        if (data != null) {
            return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new FileStillOpenException(fileName.getPath())));
        }
        return this.create(fileName);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, OpenMode.READ_WRITE), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, OpenMode.READ));
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), charset);
    }

    public synchronized StoreChannel create(File fileName) throws IOException {
        File parentFile = fileName.getParentFile();
        if (parentFile != null && !this.fileExists(parentFile)) {
            throw new FileNotFoundException("'" + fileName + "' (The system cannot find the path specified)");
        }
        EphemeralFileData data = this.files.computeIfAbsent(this.canonicalFile(fileName), key -> new EphemeralFileData(this.clock));
        return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new FileStillOpenException(fileName.getPath())));
    }

    public long getFileSize(File fileName) {
        EphemeralFileData file = this.files.get(this.canonicalFile(fileName));
        return file == null ? 0L : file.size();
    }

    public boolean fileExists(File file) {
        return this.directories.contains(file = this.canonicalFile(file)) || this.files.containsKey(file);
    }

    private File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("EphemeralFileSystemAbstraction could not canonicalise file: " + file, e);
        }
    }

    public boolean isDirectory(File file) {
        return this.directories.contains(this.canonicalFile(file));
    }

    public boolean mkdir(File directory) {
        if (this.fileExists(directory)) {
            return false;
        }
        this.directories.add(this.canonicalFile(directory));
        return true;
    }

    public void mkdirs(File directory) {
        for (File currentDirectory = this.canonicalFile(directory); currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            this.mkdir(currentDirectory);
        }
    }

    public boolean deleteFile(File fileName) {
        EphemeralFileData removed = this.files.remove(fileName = this.canonicalFile(fileName));
        if (removed != null) {
            removed.free();
            return true;
        }
        File[] files = this.listFiles(fileName);
        return files != null && files.length == 0 && this.directories.remove(fileName);
    }

    public void deleteRecursively(File path) {
        if (this.isDirectory(path)) {
            List<String> directoryPathItems = this.splitPath(this.canonicalFile(path));
            for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
                File fileName = file.getKey();
                List<String> fileNamePathItems = this.splitPath(fileName);
                if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
                this.deleteFile(fileName);
            }
        }
        this.deleteFile(path);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        from = this.canonicalFile(from);
        to = this.canonicalFile(to);
        if (!this.files.containsKey(from)) {
            throw new NoSuchFileException("'" + from + "' doesn't exist");
        }
        boolean replaceExisting = false;
        for (CopyOption copyOption : copyOptions) {
            replaceExisting |= copyOption == StandardCopyOption.REPLACE_EXISTING;
        }
        if (this.files.containsKey(to) && !replaceExisting) {
            throw new FileAlreadyExistsException("'" + to + "' already exists");
        }
        if (!this.isDirectory(to.getParentFile())) {
            throw new NoSuchFileException("Target directory[" + to.getParent() + "] does not exists");
        }
        this.files.put(to, this.files.remove(from));
    }

    public File[] listFiles(File directory) {
        if (this.files.containsKey(directory = this.canonicalFile(directory)) || !this.directories.contains(directory)) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        HashSet<File> found = new HashSet<File>();
        CombiningIterator files = new CombiningIterator(Arrays.asList(this.files.keySet().iterator(), this.directories.iterator()));
        while (files.hasNext()) {
            File file = (File)files.next();
            List<String> fileNamePathItems = this.splitPath(file);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
            found.add(this.constructPath(fileNamePathItems, directoryPathItems));
        }
        return found.toArray(new File[found.size()]);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        if (this.files.containsKey(directory = this.canonicalFile(directory))) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        HashSet<File> found = new HashSet<File>();
        CombiningIterator files = new CombiningIterator(Arrays.asList(this.files.keySet().iterator(), this.directories.iterator()));
        while (files.hasNext()) {
            File path;
            File file = (File)files.next();
            List<String> fileNamePathItems = this.splitPath(file);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems) || !filter.accept((path = this.constructPath(fileNamePathItems, directoryPathItems)).getParentFile(), path.getName())) continue;
            found.add(path);
        }
        return found.toArray(new File[found.size()]);
    }

    private File constructPath(List<String> pathItems, List<String> base) {
        File file = null;
        if (base.size() > 0) {
            pathItems = pathItems.subList(0, base.size() + 1);
        }
        for (String pathItem : pathItems) {
            String pathItemName = pathItem + File.separator;
            file = file == null ? new File(pathItemName) : new File(file, pathItemName);
        }
        return file;
    }

    private boolean directoryMatches(List<String> directoryPathItems, List<String> fileNamePathItems) {
        return fileNamePathItems.size() > directoryPathItems.size() && fileNamePathItems.subList(0, directoryPathItems.size()).equals(directoryPathItems);
    }

    private List<String> splitPath(File path) {
        return Arrays.asList(path.getPath().replaceAll("\\\\", "/").split("/"));
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        if (this.isDirectory(file)) {
            File inner = new File(toDirectory, file.getName());
            this.mkdir(inner);
            for (File f : this.listFiles(file)) {
                this.moveToDirectory(f, inner);
            }
            this.deleteFile(file);
        } else {
            EphemeralFileData fileToMove = this.files.remove(this.canonicalFile(file));
            if (fileToMove == null) {
                throw new FileNotFoundException(file.getPath());
            }
            this.files.put(this.canonicalFile(new File(toDirectory, file.getName())), fileToMove);
        }
    }

    public void copyToDirectory(File file, File toDirectory) throws IOException {
        File targetFile = new File(toDirectory, file.getName());
        this.copyFile(file, targetFile);
    }

    public void copyFile(File from, File to) throws IOException {
        EphemeralFileData data = this.files.get(this.canonicalFile(from));
        if (data == null) {
            throw new FileNotFoundException("File " + from + " not found");
        }
        this.copyFile(from, this, to, this.newCopyBuffer());
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.copyRecursivelyFromOtherFs(fromDirectory, this, toDirectory, this.newCopyBuffer());
    }

    public EphemeralFileSystemAbstraction snapshot() {
        HashMap<File, EphemeralFileData> copiedFiles = new HashMap<File, EphemeralFileData>();
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            copiedFiles.put(file.getKey(), file.getValue().copy());
        }
        return new EphemeralFileSystemAbstraction(this.directories, copiedFiles, this.clock);
    }

    public void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to) throws IOException {
        this.copyRecursivelyFromOtherFs(from, fromFs, to, this.newCopyBuffer());
    }

    public long checksum() {
        CRC32 checksum = new CRC32();
        byte[] data = new byte[(int)ByteUnit.kibiBytes((long)1L)];
        ArrayList<File> names = new ArrayList<File>(this.files.size());
        names.addAll(this.files.keySet());
        names.sort(Comparator.comparing(File::getAbsolutePath));
        for (File name : names) {
            EphemeralFileData file = this.files.get(name);
            ByteBuffer buf = file.fileAsBuffer.buf();
            buf.position(0);
            while (buf.position() < buf.limit()) {
                int len = Math.min(data.length, buf.limit() - buf.position());
                buf.get(data);
                checksum.update(data, 0, len);
            }
        }
        return checksum.getValue();
    }

    private ByteBuffer newCopyBuffer() {
        return ByteBuffer.allocate((int)ByteUnit.mebiBytes((long)1L));
    }

    private void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        this.mkdirs(to);
        for (File fromFile : fromFs.listFiles(from)) {
            File toFile = new File(to, fromFile.getName());
            if (fromFs.isDirectory(fromFile)) {
                this.copyRecursivelyFromOtherFs(fromFile, fromFs, toFile);
                continue;
            }
            this.copyFile(fromFile, fromFs, toFile, buffer);
        }
    }

    private void copyFile(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        try (StoreChannel source = fromFs.open(from, OpenMode.READ);
             StoreChannel sink = this.open(to, OpenMode.READ_WRITE);){
            int available;
            sink.truncate(0L);
            while ((available = (int)(source.size() - source.position())) > 0) {
                buffer.clear();
                buffer.limit(Math.min(available, buffer.capacity()));
                source.read(buffer);
                buffer.flip();
                sink.write(buffer);
            }
        }
    }

    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem fileSystem = this.thirdPartyFileSystems.computeIfAbsent(clazz, k -> (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz));
        return (K)((FileSystemAbstraction.ThirdPartyFileSystem)clazz.cast(fileSystem));
    }

    public void truncate(File file, long size) throws IOException {
        EphemeralFileData data = this.files.get(this.canonicalFile(file));
        if (data == null) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        data.truncate(size);
    }

    public long lastModifiedTime(File file) {
        EphemeralFileData data = this.files.get(this.canonicalFile(file));
        if (data == null) {
            return 0L;
        }
        return data.lastModified;
    }

    public void deleteFileOrThrow(File file) throws IOException {
        if (!this.fileExists(file = this.canonicalFile(file))) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        if (!this.deleteFile(file)) {
            throw new IOException("Could not delete file: " + file);
        }
    }

    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive((File)directory, (FileSystemAbstraction)this);
    }

    private static class CombiningIterator<T>
    extends PrefetchingIterator<T> {
        private Iterator<? extends Iterator<T>> iterators;
        private Iterator<T> currentIterator;

        CombiningIterator(Iterable<? extends Iterator<T>> iterators) {
            this(iterators.iterator());
        }

        CombiningIterator(Iterator<? extends Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        protected T fetchNextOrNull() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                while ((this.currentIterator = this.nextIteratorOrNull()) != null && !this.currentIterator.hasNext()) {
                }
            }
            return this.currentIterator != null && this.currentIterator.hasNext() ? (T)this.currentIterator.next() : null;
        }

        protected Iterator<T> nextIteratorOrNull() {
            if (this.iterators.hasNext()) {
                return this.iterators.next();
            }
            return null;
        }
    }

    private static abstract class PrefetchingIterator<T>
    implements Iterator<T> {
        boolean hasFetchedNext;
        T nextObject;

        private PrefetchingIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.peek() != null;
        }

        public T peek() {
            if (this.hasFetchedNext) {
                return this.nextObject;
            }
            this.nextObject = this.fetchNextOrNull();
            this.hasFetchedNext = true;
            return this.nextObject;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.nextObject;
            this.nextObject = null;
            this.hasFetchedNext = false;
            return result;
        }

        protected abstract T fetchNextOrNull();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class DynamicByteBuffer {
        private static final byte[] zeroBuffer = new byte[(int)ByteUnit.kibiBytes((long)1L)];
        private ByteBuffer buf;
        private Exception freeCall;

        DynamicByteBuffer() {
            this.buf = this.allocate(ByteUnit.kibiBytes((long)1L));
        }

        public ByteBuffer buf() {
            this.assertNotFreed();
            return this.buf;
        }

        private DynamicByteBuffer(ByteBuffer toClone) {
            this.buf = this.allocate(toClone.capacity());
            this.copyByteBufferContents(toClone, this.buf);
        }

        synchronized DynamicByteBuffer copy() {
            return new DynamicByteBuffer(this.buf());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyByteBufferContents(ByteBuffer from, ByteBuffer to) {
            int positionBefore = from.position();
            try {
                from.position(0);
                to.put(from);
            }
            finally {
                from.position(positionBefore);
                to.position(0);
            }
        }

        private ByteBuffer allocate(long capacity) {
            return ByteBuffer.allocate(Math.toIntExact(capacity));
        }

        void free() {
            this.assertNotFreed();
            try {
                this.clear();
            }
            finally {
                this.buf = null;
                this.freeCall = new Exception("You're most likely seeing this exception because there was an attempt to use this buffer after it was freed. This stack trace may help you figure out where and why it was freed");
            }
        }

        synchronized void put(int pos, byte[] bytes, int offset, int length) {
            this.verifySize(pos + length);
            ByteBuffer buf = this.buf();
            try {
                buf.position(pos);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(buf + ", " + pos, e);
            }
            buf.put(bytes, offset, length);
        }

        synchronized void get(int pos, byte[] scratchPad, int i, int howMuchToReadThisTime) {
            ByteBuffer buf = this.buf();
            buf.position(pos);
            buf.get(scratchPad, i, howMuchToReadThisTime);
        }

        synchronized void fillWithZeros(int pos, int bytes) {
            ByteBuffer buf = this.buf();
            buf.position(pos);
            while (bytes > 0) {
                int howMuchToReadThisTime = Math.min(bytes, zeroBuffer.length);
                buf.put(zeroBuffer, 0, howMuchToReadThisTime);
                bytes -= howMuchToReadThisTime;
            }
            buf.position(pos);
        }

        private void verifySize(int totalAmount) {
            ByteBuffer buf = this.buf();
            if (buf.capacity() >= totalAmount) {
                return;
            }
            int newSize = buf.capacity();
            long maxSize = ByteUnit.gibiBytes((long)1L);
            this.checkAllowedSize(totalAmount, maxSize);
            while (newSize < totalAmount) {
                this.checkAllowedSize(newSize <<= 1, maxSize);
            }
            int oldPosition = buf.position();
            ByteBuffer newBuf = this.allocate(newSize);
            buf.position(0);
            newBuf.put(buf);
            newBuf.position(oldPosition);
            this.buf = newBuf;
        }

        private void checkAllowedSize(long size, long maxSize) {
            if (size > maxSize) {
                throw new RuntimeException("Requested file size is too big for ephemeral file system.");
            }
        }

        public void clear() {
            this.buf().clear();
        }

        private void assertNotFreed() {
            if (this.buf == null) {
                throw new IllegalStateException("This buffer have been freed", this.freeCall);
            }
        }

        void dump(OutputStream target, byte[] scratchPad, int size) throws IOException {
            ByteBuffer buf = this.buf();
            buf.position(0);
            while (size > 0) {
                int read = Math.min(size, scratchPad.length);
                buf.get(scratchPad, 0, read);
                size -= read;
                target.write(scratchPad, 0, read);
            }
        }
    }

    private static class EphemeralFileLock
    extends FileLock {
        private EphemeralFileData file;

        EphemeralFileLock(EphemeralFileChannel channel, EphemeralFileData file) {
            super(channel, 0L, Long.MAX_VALUE, false);
            this.file = file;
            file.locked++;
        }

        @Override
        public boolean isValid() {
            return this.file != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Collection collection = this.file.channels;
            synchronized (collection) {
                if (this.file == null || this.file.locked == 0) {
                    return;
                }
                this.file.locked--;
                this.file = null;
            }
        }
    }

    private static class EphemeralFileData {
        private static final ThreadLocal<byte[]> SCRATCH_PAD = ThreadLocal.withInitial(() -> new byte[(int)ByteUnit.kibiBytes((long)1L)]);
        private DynamicByteBuffer fileAsBuffer;
        private DynamicByteBuffer forcedBuffer;
        private final Collection<WeakReference<EphemeralFileChannel>> channels = new LinkedList<WeakReference<EphemeralFileChannel>>();
        private int size;
        private int forcedSize;
        private int locked;
        private final Clock clock;
        private long lastModified;

        EphemeralFileData(Clock clock) {
            this(new DynamicByteBuffer(), clock);
        }

        private EphemeralFileData(DynamicByteBuffer data, Clock clock) {
            this.fileAsBuffer = data;
            this.forcedBuffer = data.copy();
            this.clock = clock;
            this.lastModified = clock.millis();
        }

        int read(Positionable fc, ByteBuffer dst) {
            int howMuchToReadThisTime;
            long size;
            int wanted = dst.limit() - dst.position();
            int available = Math.min(wanted, (int)((size = this.size()) - fc.pos()));
            if (available <= 0) {
                return -1;
            }
            byte[] scratchPad = SCRATCH_PAD.get();
            for (int pending = available; pending > 0; pending -= howMuchToReadThisTime) {
                howMuchToReadThisTime = Math.min(pending, scratchPad.length);
                long pos = fc.pos();
                this.fileAsBuffer.get((int)pos, scratchPad, 0, howMuchToReadThisTime);
                fc.pos(pos + (long)howMuchToReadThisTime);
                dst.put(scratchPad, 0, howMuchToReadThisTime);
            }
            return available;
        }

        synchronized int write(Positionable fc, ByteBuffer src) {
            int wanted;
            int howMuchToWriteThisTime;
            byte[] scratchPad = SCRATCH_PAD.get();
            for (int pending = wanted = src.limit() - src.position(); pending > 0; pending -= howMuchToWriteThisTime) {
                howMuchToWriteThisTime = Math.min(pending, scratchPad.length);
                src.get(scratchPad, 0, howMuchToWriteThisTime);
                long pos = fc.pos();
                this.fileAsBuffer.put((int)pos, scratchPad, 0, howMuchToWriteThisTime);
                fc.pos(pos + (long)howMuchToWriteThisTime);
            }
            int newSize = Math.max(this.size, (int)fc.pos());
            int intermediaryBytes = newSize - wanted - this.size;
            if (intermediaryBytes > 0) {
                this.fileAsBuffer.fillWithZeros(this.size, intermediaryBytes);
            }
            this.size = newSize;
            this.lastModified = this.clock.millis();
            return wanted;
        }

        synchronized EphemeralFileData copy() {
            EphemeralFileData copy = new EphemeralFileData(this.fileAsBuffer.copy(), this.clock);
            copy.size = this.size;
            return copy;
        }

        void free() {
            this.fileAsBuffer.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(EphemeralFileChannel channel) {
            Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
            synchronized (collection) {
                this.channels.add(new WeakReference<EphemeralFileChannel>(channel));
            }
        }

        synchronized void force() {
            this.forcedBuffer = this.fileAsBuffer.copy();
            this.forcedSize = this.size;
        }

        synchronized void crash() {
            this.fileAsBuffer = this.forcedBuffer.copy();
            this.size = this.forcedSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(EphemeralFileChannel channel) {
            Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
            synchronized (collection) {
                this.locked = 0;
                Iterator<EphemeralFileChannel> iter = this.getOpenChannels();
                while (iter.hasNext()) {
                    if (iter.next() != channel) continue;
                    iter.remove();
                }
            }
        }

        Iterator<EphemeralFileChannel> getOpenChannels() {
            final Iterator<WeakReference<EphemeralFileChannel>> refs = this.channels.iterator();
            return new PrefetchingIterator<EphemeralFileChannel>(){

                @Override
                protected EphemeralFileChannel fetchNextOrNull() {
                    while (refs.hasNext()) {
                        EphemeralFileChannel channel = (EphemeralFileChannel)((WeakReference)refs.next()).get();
                        if (channel != null) {
                            return channel;
                        }
                        refs.remove();
                    }
                    return null;
                }

                @Override
                public void remove() {
                    refs.remove();
                }
            };
        }

        synchronized long size() {
            return this.size;
        }

        synchronized void truncate(long newSize) {
            this.size = (int)newSize;
        }

        boolean lock() {
            return this.locked == 0;
        }

        synchronized void dumpTo(OutputStream target) throws IOException {
            byte[] scratchPad = SCRATCH_PAD.get();
            this.fileAsBuffer.dump(target, scratchPad, this.size);
        }

        public String toString() {
            return "size: " + this.size + ", locked:" + this.locked;
        }
    }

    private static class EphemeralFileChannel
    extends FileChannel
    implements Positionable {
        final FileStillOpenException openedAt;
        private final EphemeralFileData data;
        private long position;

        EphemeralFileChannel(EphemeralFileData data, FileStillOpenException opened) {
            this.data = data;
            this.openedAt = opened;
            data.open(this);
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.openedAt.filename);
        }

        private void checkIfClosedOrInterrupted() throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (Thread.currentThread().isInterrupted()) {
                this.close();
                throw new ClosedByInterruptException();
            }
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.data.read(this, dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            this.checkIfClosedOrInterrupted();
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.data.write(this, src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            this.checkIfClosedOrInterrupted();
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.position;
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.checkIfClosedOrInterrupted();
            this.position = newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.data.size();
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            this.checkIfClosedOrInterrupted();
            this.data.truncate(size);
            return this;
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.checkIfClosedOrInterrupted();
            this.data.force();
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            this.checkIfClosedOrInterrupted();
            long previousPos = this.position();
            this.position(position);
            try {
                long transferred;
                int read;
                ByteBuffer intermediary = ByteBuffer.allocate((int)ByteUnit.mebiBytes((long)8L));
                for (transferred = 0L; transferred < count; transferred += (long)read) {
                    intermediary.clear();
                    intermediary.limit((int)Math.min((long)intermediary.capacity(), count - transferred));
                    read = src.read(intermediary);
                    if (read == -1) break;
                    intermediary.flip();
                }
                long l = transferred;
                return l;
            }
            finally {
                this.position(previousPos);
            }
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.data.read(new LocalPosition(position), dst);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            this.checkIfClosedOrInterrupted();
            return this.data.write(new LocalPosition(position), src);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            this.checkIfClosedOrInterrupted();
            throw new IOException("Not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            this.checkIfClosedOrInterrupted();
            Collection collection = this.data.channels;
            synchronized (collection) {
                if (!this.data.lock()) {
                    return null;
                }
                return new EphemeralFileLock(this, this.data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileLock tryLock(long position, long size, boolean shared) {
            Collection collection = this.data.channels;
            synchronized (collection) {
                if (!this.data.lock()) {
                    throw new OverlappingFileLockException();
                }
                return new EphemeralFileLock(this, this.data);
            }
        }

        @Override
        protected void implCloseChannel() {
            this.data.close(this);
        }

        @Override
        public long pos() {
            return this.position;
        }

        @Override
        public void pos(long position) {
            this.position = position;
        }
    }

    static class LocalPosition
    implements Positionable {
        private long position;

        LocalPosition(long position) {
            this.position = position;
        }

        @Override
        public long pos() {
            return this.position;
        }

        @Override
        public void pos(long position) {
            this.position = position;
        }
    }

    private static class FileStillOpenException
    extends Exception {
        private final String filename;

        FileStillOpenException(String filename) {
            super("File still open: [" + filename + "]");
            this.filename = filename;
        }
    }

    static interface Positionable {
        public long pos();

        public void pos(long var1);
    }
}

