/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.mockfs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StreamFilesRecursive;
import org.neo4j.io.fs.watcher.FileWatcher;

public class DelegatingFileSystemAbstraction
implements FileSystemAbstraction {
    private final FileSystemAbstraction delegate;

    public DelegatingFileSystemAbstraction(FileSystemAbstraction delegate) {
        this.delegate = delegate;
    }

    public FileWatcher fileWatcher() throws IOException {
        return this.delegate.fileWatcher();
    }

    public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
        return this.delegate.open(fileName, openMode);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.delegate.moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(File file, File toDirectory) throws IOException {
        this.delegate.copyToDirectory(file, toDirectory);
    }

    public boolean mkdir(File fileName) {
        return this.delegate.mkdir(fileName);
    }

    public void copyFile(File from, File to) throws IOException {
        this.delegate.copyFile(from, to);
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.delegate.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void truncate(File path, long size) throws IOException {
        this.delegate.truncate(path, size);
    }

    public long lastModifiedTime(File file) {
        return this.delegate.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(File file) throws IOException {
        this.delegate.deleteFileOrThrow(file);
    }

    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return StreamFilesRecursive.streamFilesRecursive((File)directory, (FileSystemAbstraction)this);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.delegate.renameFile(from, to, copyOptions);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.delegate.create(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.delegate.mkdirs(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.delegate.deleteFile(fileName);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return this.delegate.openAsInputStream(fileName);
    }

    public boolean fileExists(File fileName) {
        return this.delegate.fileExists(fileName);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.delegate.listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.delegate.isDirectory(file);
    }

    public long getFileSize(File fileName) {
        return this.delegate.getFileSize(fileName);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return this.delegate.openAsWriter(fileName, charset, append);
    }

    public File[] listFiles(File directory) {
        return this.delegate.listFiles(directory);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.delegate.deleteRecursively(directory);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return this.delegate.openAsOutputStream(fileName, append);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return this.delegate.openAsReader(fileName, charset);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.delegate.copyRecursively(fromDirectory, toDirectory);
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

