/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class ChannelOutputStreamTest {
    @Rule
    public FileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @Test
    public void shouldStoreAByteAtBoundary() throws Exception {
        File workFile = this.tmpDir.newFile();
        this.fs.mkdirs(this.tmpDir.getRoot());
        OutputStream out = this.fs.openAsOutputStream(workFile, false);
        byte[] b = new byte[8097];
        b[b.length - 1] = 7;
        out.write(b);
        out.flush();
        InputStream in = this.fs.openAsInputStream(workFile);
        in.skip(8096L);
        assert (in.read() == 7);
    }
}

