/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PageSwapperTest;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.LockThisFileProgram;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.test.matchers.ByteArrayMatcher;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class SingleFilePageSwapperTest
extends PageSwapperTest {
    private EphemeralFileSystemAbstraction ephemeralFileSystem;
    private DefaultFileSystemAbstraction fileSystem;
    private File file;

    @Before
    public void setUp() throws IOException {
        this.file = new File("file").getCanonicalFile();
        this.ephemeralFileSystem = new EphemeralFileSystemAbstraction();
        this.fileSystem = new DefaultFileSystemAbstraction();
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new FileSystemAbstraction[]{this.ephemeralFileSystem, this.fileSystem});
    }

    @Override
    protected PageSwapperFactory swapperFactory() {
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.open(this.getFs(), Configuration.EMPTY);
        return factory;
    }

    @Override
    protected void mkdirs(File dir) throws IOException {
        this.getFs().mkdirs(dir);
    }

    @Override
    protected File baseDirectory() throws IOException {
        File dir = this.getFile().getParentFile();
        this.mkdirs(dir);
        return dir;
    }

    @Override
    protected boolean isRootAccessible() {
        return true;
    }

    protected File getFile() {
        return this.file;
    }

    protected FileSystemAbstraction getFs() {
        return this.getEphemeralFileSystem();
    }

    protected FileSystemAbstraction getEphemeralFileSystem() {
        return this.ephemeralFileSystem;
    }

    protected FileSystemAbstraction getRealFileSystem() {
        return this.fileSystem;
    }

    protected void assumeFalse(String message, boolean test) {
        if (test) {
            throw new AssumptionViolatedException(message);
        }
    }

    private void putBytes(long page, byte[] data, int srcOffset, int tgtOffset, int length) {
        for (int i = 0; i < length; ++i) {
            UnsafeUtil.putByte((long)(page + (long)srcOffset + (long)i), (byte)data[tgtOffset + i]);
        }
    }

    @Test
    public void swappingInMustFillPageWithData() throws Exception {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(bytes));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        long target = this.createPage(4);
        swapper.read(0L, target, this.sizeOfAsInt(target));
        Assert.assertThat((Object)this.array(target), (Matcher)ByteArrayMatcher.byteArray((byte[])bytes));
    }

    @Test
    public void mustZeroFillPageBeyondEndOfFile() throws Exception {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(bytes));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        long target = this.createPage(4);
        swapper.read(1L, target, this.sizeOfAsInt(target));
        Assert.assertThat((Object)this.array(target), (Matcher)ByteArrayMatcher.byteArray((byte[])new byte[]{5, 6, 0, 0}));
    }

    @Test
    public void swappingOutMustWritePageToFile() throws Exception {
        this.getFs().create(this.getFile()).close();
        byte[] expected = new byte[]{1, 2, 3, 4};
        long page = this.createPage(expected);
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        swapper.write(0L, page);
        InputStream stream = this.getFs().openAsInputStream(this.getFile());
        byte[] actual = new byte[expected.length];
        Assert.assertThat((Object)stream.read(actual), (Matcher)Matchers.is((Object)actual.length));
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray((byte[])expected));
    }

    private long createPage(byte[] expected) {
        long page = this.createPage(expected.length);
        this.putBytes(page, expected, 0, 0, expected.length);
        return page;
    }

    @Test
    public void swappingOutMustNotOverwriteDataBeyondPage() throws Exception {
        byte[] initialData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] finalData = new byte[]{1, 2, 3, 4, 8, 7, 6, 5, 9, 10};
        StoreChannel channel = this.getFs().create(this.getFile());
        channel.writeAll(this.wrap(initialData));
        channel.close();
        byte[] change = new byte[]{8, 7, 6, 5};
        long page = this.createPage(change);
        PageSwapperFactory factory = this.createSwapperFactory();
        PageSwapper swapper = this.createSwapper(factory, this.getFile(), 4, null, false);
        swapper.write(1L, page);
        InputStream stream = this.getFs().openAsInputStream(this.getFile());
        byte[] actual = new byte[(int)this.getFs().getFileSize(this.getFile())];
        Assert.assertThat((Object)stream.read(actual), (Matcher)Matchers.is((Object)actual.length));
        Assert.assertThat((Object)actual, (Matcher)ByteArrayMatcher.byteArray((byte[])finalData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void creatingSwapperForFileMustTakeLockOnFile() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)this.fileSystem, Configuration.EMPTY);
        File file = this.testDir.file("file");
        this.fileSystem.create(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = this.fileSystem.open(file, OpenMode.READ_WRITE);
            this.expectedException.expect(OverlappingFileLockException.class);
            channel.tryLock();
        }
    }

    @Test
    public void creatingSwapperForInternallyLockedFileMustThrow() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)this.fileSystem, Configuration.EMPTY);
        File file = this.testDir.file("file");
        StoreFileChannel channel = this.fileSystem.create(file);
        try (FileLock fileLock = channel.tryLock();){
            Assert.assertThat((Object)fileLock, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            this.expectedException.expect(FileLockException.class);
            this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void creatingSwapperForExternallyLockedFileMustThrow() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)this.fileSystem, Configuration.EMPTY);
        File file = this.testDir.file("file");
        this.fileSystem.create(file).close();
        ProcessBuilder pb = new ProcessBuilder(ProcessUtil.getJavaExecutable().toString(), "-cp", ProcessUtil.getClassPath(), LockThisFileProgram.class.getCanonicalName(), file.getAbsolutePath());
        File wd = new File("target/test-classes").getAbsoluteFile();
        pb.directory(wd);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.is((Object)"locked"));
        try {
            this.expectedException.expect(FileLockException.class);
            this.createSwapper(factory, file, 4, NO_CALLBACK, true);
        }
        finally {
            process.getOutputStream().write(0);
            process.getOutputStream().flush();
            process.waitFor();
        }
    }

    @Test
    public void mustUnlockFileWhenThePageSwapperIsClosed() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)this.fileSystem, Configuration.EMPTY);
        File file = this.testDir.file("file");
        this.fileSystem.create(file).close();
        this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
        try (StoreFileChannel channel = this.fileSystem.open(file, OpenMode.READ_WRITE);
             FileLock fileLock = channel.tryLock();){
            Assert.assertThat((Object)fileLock, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fileMustRemainLockedEvenIfChannelIsClosedByStrayInterrupt() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)this.fileSystem, Configuration.EMPTY);
        File file = this.testDir.file("file");
        this.fileSystem.create(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = this.fileSystem.open(file, OpenMode.READ_WRITE);
            Thread.currentThread().interrupt();
            pageSwapper.force();
            this.expectedException.expect(OverlappingFileLockException.class);
            channel.tryLock();
        }
    }

    @Test
    public void mustCloseFilesIfTakingFileLockThrows() throws Exception {
        this.assumeFalse("No file locking on Windows", SystemUtils.IS_OS_WINDOWS);
        final AtomicInteger openFilesCounter = new AtomicInteger();
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open((FileSystemAbstraction)new DelegatingFileSystemAbstraction((FileSystemAbstraction)this.fileSystem){

            @Override
            public StoreChannel open(File fileName, OpenMode openMode) throws IOException {
                openFilesCounter.getAndIncrement();
                return new DelegatingStoreChannel(super.open(fileName, openMode)){

                    @Override
                    public void close() throws IOException {
                        openFilesCounter.getAndDecrement();
                        super.close();
                    }
                };
            }
        }, Configuration.EMPTY);
        File file = this.testDir.file("file");
        try (StoreFileChannel ch = this.fileSystem.create(file);
             FileLock ignore = ch.tryLock();){
            this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
            Assert.fail((String)"Creating a page swapper for a locked channel should have thrown");
        }
        catch (FileLockException fileLockException) {
            // empty catch block
        }
        Assert.assertThat((Object)openFilesCounter.get(), (Matcher)Matchers.is((Object)0));
    }

    private byte[] array(long page) {
        int size = this.sizeOfAsInt(page);
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = UnsafeUtil.getByte((long)(page + (long)i));
        }
        return array;
    }

    private ByteBuffer wrap(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        for (byte b : bytes) {
            buffer.put(b);
        }
        buffer.clear();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedRead() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open(this.getFs(), Configuration.EMPTY);
        File file = this.getFile();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            long page = this.createPage(data);
            swapper.write(0L, page);
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.open((FileSystemAbstraction)new AdversarialFileSystemAbstraction(adversary, this.getFs()), Configuration.EMPTY);
        swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, false);
        long page = this.createPage(bytesTotal);
        try {
            for (int i = 0; i < 10000; ++i) {
                this.clear(page);
                Assert.assertThat((Object)swapper.read(0L, page, this.sizeOfAsInt(page)), (Matcher)Matchers.is((Object)bytesTotal));
                Assert.assertThat((Object)this.array(page), (Matcher)Matchers.is((Object)data));
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedWrite() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        long zeroPage = this.createPage(bytesTotal);
        this.clear(zeroPage);
        File file = this.getFile();
        PageSwapperFactory factory = this.createSwapperFactory();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.open((FileSystemAbstraction)new AdversarialFileSystemAbstraction(adversary, this.getFs()), Configuration.EMPTY);
        PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);
        long page = this.createPage(bytesTotal);
        try {
            for (int i = 0; i < 10000; ++i) {
                adversary.setProbabilityFactor(0.0);
                swapper.write(0L, zeroPage);
                this.putBytes(page, data, 0, 0, data.length);
                adversary.setProbabilityFactor(1.0);
                Assert.assertThat((Object)swapper.write(0L, page), (Matcher)Matchers.is((Object)bytesTotal));
                this.clear(page);
                adversary.setProbabilityFactor(0.0);
                swapper.read(0L, page, this.sizeOfAsInt(page));
                Assert.assertThat((Object)this.array(page), (Matcher)Matchers.is((Object)data));
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedVectoredRead() throws Exception {
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.createSwapperFactory();
        factory.open(this.getFs(), Configuration.EMPTY);
        File file = this.getFile();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            long page = this.createPage(data);
            swapper.write(0L, page);
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.open((FileSystemAbstraction)new AdversarialFileSystemAbstraction(adversary, this.getFs()), Configuration.EMPTY);
        swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, false);
        long[] pages = new long[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            pages[i] = this.createPage(bytesPerPage);
        }
        byte[] temp = new byte[bytesPerPage];
        try {
            for (int i = 0; i < 10000; ++i) {
                for (long page : pages) {
                    this.clear(page);
                }
                Assert.assertThat((Object)swapper.read(0L, pages, bytesPerPage, 0, pages.length), (Matcher)Matchers.is((Object)bytesTotal));
                for (int j = 0; j < pageCount; ++j) {
                    System.arraycopy(data, j * bytesPerPage, temp, 0, bytesPerPage);
                    Assert.assertThat((Object)this.array(pages[j]), (Matcher)Matchers.is((Object)temp));
                }
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mustHandleMischiefInPositionedVectoredWrite() throws Exception {
        int i;
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        long zeroPage = this.createPage(bytesPerPage);
        this.clear(zeroPage);
        File file = this.getFile();
        PageSwapperFactory factory = this.createSwapperFactory();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory.open((FileSystemAbstraction)new AdversarialFileSystemAbstraction(adversary, this.getFs()), Configuration.EMPTY);
        PageSwapper swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, true);
        long[] writePages = new long[pageCount];
        long[] readPages = new long[pageCount];
        long[] zeroPages = new long[pageCount];
        for (i = 0; i < pageCount; ++i) {
            writePages[i] = this.createPage(bytesPerPage);
            this.putBytes(writePages[i], data, 0, i * bytesPerPage, bytesPerPage);
            readPages[i] = this.createPage(bytesPerPage);
            zeroPages[i] = zeroPage;
        }
        try {
            for (i = 0; i < 10000; ++i) {
                adversary.setProbabilityFactor(0.0);
                swapper.write(0L, zeroPages, 0, pageCount);
                adversary.setProbabilityFactor(1.0);
                swapper.write(0L, writePages, 0, pageCount);
                for (long readPage : readPages) {
                    this.clear(readPage);
                }
                adversary.setProbabilityFactor(0.0);
                Assert.assertThat((Object)swapper.read(0L, readPages, bytesPerPage, 0, pageCount), (Matcher)Matchers.is((Object)bytesTotal));
                for (int j = 0; j < pageCount; ++j) {
                    Assert.assertThat((Object)this.array(readPages[j]), (Matcher)Matchers.is((Object)this.array(writePages[j])));
                }
            }
        }
        finally {
            swapper.close();
        }
    }
}

