/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;

public class SwapperSetTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    SwapperSet set;

    @Before
    public void setUp() {
        this.set = new SwapperSet();
    }

    @Test
    public void mustReturnAllocationWithSwapper() {
        DummyPageSwapper a = new DummyPageSwapper("a", 42);
        DummyPageSwapper b = new DummyPageSwapper("b", 43);
        short idA = this.set.allocate((PageSwapper)a);
        short idB = this.set.allocate((PageSwapper)b);
        SwapperSet.SwapperMapping allocA = this.set.getAllocation(idA);
        SwapperSet.SwapperMapping allocB = this.set.getAllocation(idB);
        Assert.assertThat((Object)allocA.swapper, (Matcher)Matchers.is((Object)a));
        Assert.assertThat((Object)allocB.swapper, (Matcher)Matchers.is((Object)b));
    }

    @Test
    public void accessingFreedAllocationMustReturnNull() {
        short id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free((int)id);
        Assert.assertNull((Object)this.set.getAllocation(id));
    }

    @Test
    public void doubleFreeMustThrow() {
        short id = this.set.allocate((PageSwapper)new DummyPageSwapper("a", 42));
        this.set.free((int)id);
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("double free");
        this.set.free((int)id);
    }

    @Test
    public void freedIdsMustNotBeReusedBeforeVacuum() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        PrimitiveIntSet ids = Primitive.intSet((int)10000);
        for (int i = 0; i < 10000; ++i) {
            this.allocateFreeAndAssertNotReused(swapper, ids, i);
        }
    }

    private void allocateFreeAndAssertNotReused(PageSwapper swapper, PrimitiveIntSet ids, int i) {
        short id = this.set.allocate(swapper);
        this.set.free((int)id);
        if (!ids.add((int)id)) {
            Assert.fail((String)("Expected ids.add( id ) to return true for id " + id + " in iteration " + i + " but it instead returned false"));
        }
    }

    @Test
    public void freedAllocationsMustBecomeAvailableAfterVacuum() {
        PrimitiveIntSet allocated = Primitive.intSet();
        PrimitiveIntSet freed = Primitive.intSet();
        PrimitiveIntSet vacuumed = Primitive.intSet();
        PrimitiveIntSet reused = Primitive.intSet();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        this.allocateAndAddTenThousand(allocated, swapper);
        allocated.visitKeys(id -> {
            this.set.free(id);
            freed.add(id);
            return false;
        });
        this.set.vacuum(swapperIds -> vacuumed.addAll(((PrimitiveIntSet)swapperIds).iterator()));
        this.allocateAndAddTenThousand(reused, swapper);
        Assert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)freed)));
        Assert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)vacuumed)));
        Assert.assertThat((Object)allocated, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)reused)));
    }

    private void allocateAndAddTenThousand(PrimitiveIntSet allocated, PageSwapper swapper) {
        for (int i = 0; i < 10000; ++i) {
            this.allocateAndAdd(allocated, swapper);
        }
    }

    private void allocateAndAdd(PrimitiveIntSet allocated, PageSwapper swapper) {
        short id = this.set.allocate(swapper);
        allocated.add((int)id);
    }

    @Test
    public void vacuumMustNotDustOffAnyIdsWhenNoneHaveBeenFreed() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        for (int i = 0; i < 100; ++i) {
            this.set.allocate((PageSwapper)swapper);
        }
        PrimitiveIntSet vacuumedIds = Primitive.intSet();
        this.set.vacuum(swapperIds -> vacuumedIds.addAll(((PrimitiveIntSet)swapperIds).iterator()));
        if (!vacuumedIds.isEmpty()) {
            throw new AssertionError((Object)("Vacuum found id " + vacuumedIds + " when it should have found nothing"));
        }
    }

    @Test
    public void mustNotUseZeroAsSwapperId() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        Matcher isNotZero = Matchers.is((Matcher)Matchers.not((Object)0));
        for (int i = 0; i < 10000; ++i) {
            Assert.assertThat((Object)this.set.allocate((PageSwapper)swapper), (Matcher)isNotZero);
        }
    }

    @Test
    public void gettingAllocationZeroMustThrow() {
        this.exception.expect(IllegalArgumentException.class);
        this.set.getAllocation((short)0);
    }

    @Test
    public void freeOfIdZeroMustThrow() {
        this.exception.expect(IllegalArgumentException.class);
        this.set.free(0);
    }

    @Test
    public void mustKeepTrackOfAvailableSwapperIds() {
        DummyPageSwapper swapper = new DummyPageSwapper("a", 42);
        short initial = 32766;
        Assert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)initial));
        short id = this.set.allocate((PageSwapper)swapper);
        Assert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)((short)(initial - 1))));
        this.set.free((int)id);
        Assert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)((short)(initial - 1))));
        this.set.vacuum(x -> {});
        Assert.assertThat((Object)this.set.countAvailableIds(), (Matcher)Matchers.is((Object)initial));
    }
}

