/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.StubPagedFile;
import org.neo4j.io.pagecache.impl.DelegatingPageCursor;
import org.neo4j.io.pagecache.impl.PagedReadableByteChannel;
import org.neo4j.io.pagecache.impl.PagedWritableByteChannel;

@RunWith(value=Theories.class)
public class PagedByteChannelsTest {
    @DataPoint
    public static final ThrowingFunction<PagedFile, ReadableByteChannel, IOException> readable = PagedReadableByteChannel::new;
    @DataPoint
    public static final ThrowingFunction<PagedFile, WritableByteChannel, IOException> writable = PagedWritableByteChannel::new;

    @Theory
    public void mustCloseCursorOnClose(ThrowingFunction<PagedFile, ? extends Channel, IOException> channelConstructor) throws Exception {
        final AtomicInteger closeCounter = new AtomicInteger();
        StubPagedFile pf = new StubPagedFile(8192){

            @Override
            public PageCursor io(long pageId, int pf_flags) throws IOException {
                return new DelegatingPageCursor(super.io(pageId, pf_flags)){

                    public void close() {
                        super.close();
                        closeCounter.getAndIncrement();
                    }
                };
            }
        };
        ((Channel)channelConstructor.apply((Object)pf)).close();
        Assert.assertThat((Object)closeCounter.get(), (Matcher)Matchers.is((Object)1));
    }
}

