/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.SelectiveFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.fs.watcher.resource.WatchedResource;

public class SelectiveFileSystemAbstractionTest {
    @Test
    public void shouldUseCorrectFileSystemForChosenFile() throws Exception {
        File specialFile = new File("special");
        FileSystemAbstraction normal = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileSystemAbstraction special = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        try (SelectiveFileSystemAbstraction systemAbstraction = new SelectiveFileSystemAbstraction(specialFile, special, normal);){
            systemAbstraction.open(specialFile, OpenMode.READ);
            ((FileSystemAbstraction)Mockito.verify((Object)special)).open(specialFile, OpenMode.READ);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{special});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{normal});
        }
    }

    @Test
    public void shouldUseDefaultFileSystemForOtherFiles() throws Exception {
        File specialFile = new File("special");
        File otherFile = new File("other");
        FileSystemAbstraction normal = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileSystemAbstraction special = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        try (SelectiveFileSystemAbstraction fs = new SelectiveFileSystemAbstraction(specialFile, special, normal);){
            fs.create(otherFile);
            fs.open(otherFile, OpenMode.READ);
            ((FileSystemAbstraction)Mockito.verify((Object)normal)).create(otherFile);
            ((FileSystemAbstraction)Mockito.verify((Object)normal)).open(otherFile, OpenMode.READ);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{special});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{normal});
        }
    }

    @Test
    public void provideSelectiveWatcher() throws IOException {
        File specialFile = new File("special");
        File otherFile = new File("other");
        FileSystemAbstraction normal = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileSystemAbstraction special = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        FileWatcher specialWatcher = (FileWatcher)Mockito.mock(FileWatcher.class);
        FileWatcher normalWatcher = (FileWatcher)Mockito.mock(FileWatcher.class);
        WatchedResource specialResource = (WatchedResource)Mockito.mock(WatchedResource.class);
        WatchedResource normalResource = (WatchedResource)Mockito.mock(WatchedResource.class);
        Mockito.when((Object)special.fileWatcher()).thenReturn((Object)specialWatcher);
        Mockito.when((Object)normal.fileWatcher()).thenReturn((Object)normalWatcher);
        Mockito.when((Object)specialWatcher.watch(specialFile)).thenReturn((Object)specialResource);
        Mockito.when((Object)normalWatcher.watch(otherFile)).thenReturn((Object)normalResource);
        try (SelectiveFileSystemAbstraction fs = new SelectiveFileSystemAbstraction(specialFile, special, normal);){
            FileWatcher fileWatcher = fs.fileWatcher();
            Assert.assertSame((Object)specialResource, (Object)fileWatcher.watch(specialFile));
            Assert.assertSame((Object)normalResource, (Object)fileWatcher.watch(otherFile));
        }
    }
}

