/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    private final CursorPool.CursorSets cursorSets;
    MuninnWritePageCursor nextCursor;

    MuninnWritePageCursor(CursorPool.CursorSets cursorSets, long victimPage, PageCursorTracer pageCursorTracer) {
        super(victimPage, pageCursorTracer);
        this.cursorSets = cursorSets;
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.pinnedPageRef != 0L) {
            this.pinEvent.done();
            if (this.eagerFlush) {
                this.eagerlyFlushAndUnlockPage();
            } else {
                this.pagedFile.unlockWrite(this.pinnedPageRef);
            }
        }
        this.clearPageCursorState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerlyFlushAndUnlockPage() {
        long flushStamp = this.pagedFile.unlockWriteAndTryTakeFlushLock(this.pinnedPageRef);
        if (flushStamp != 0L) {
            boolean success = false;
            try {
                success = this.pagedFile.flushLockedPage(this.pinnedPageRef, this.currentPageId);
            }
            finally {
                this.pagedFile.unlockFlush(this.pinnedPageRef, flushStamp, success);
            }
        }
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId < 0L) {
            return false;
        }
        if (this.nextPageId > lastPageId) {
            if (this.noGrow) {
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.currentPageId = this.nextPageId++;
        this.pin(this.currentPageId, true);
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        return this.pagedFile.tryWriteLock(pageRef);
    }

    @Override
    protected void unlockPage(long pageRef) {
        this.pagedFile.unlockWrite(pageRef);
    }

    @Override
    protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) {
        this.reset(pageRef);
        this.assertPagedFileStillMappedAndGetIdOfLastPage();
        this.pagedFile.incrementUsage(pageRef);
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        this.pagedFile.unlockExclusiveAndTakeWriteLock(pageRef);
    }

    @Override
    protected void releaseCursor() {
        this.nextCursor = this.cursorSets.writeCursors;
        this.cursorSets.writeCursors = this;
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

