/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorExceptionWithPreciseStackTrace;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

abstract class MuninnPageCursor
extends PageCursor {
    private static final boolean usePreciseCursorErrorStackTraces = FeatureToggles.flag(MuninnPageCursor.class, (String)"usePreciseCursorErrorStackTraces", (boolean)false);
    private static final boolean boundsCheck = FeatureToggles.flag(MuninnPageCursor.class, (String)"boundsCheck", (boolean)true);
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    private final long victimPage;
    private final PageCursorTracer tracer;
    protected MuninnPagedFile pagedFile;
    protected PageSwapper swapper;
    protected int swapperId;
    protected long pinnedPageRef;
    protected PinEvent pinEvent;
    protected long pageId;
    protected int pf_flags;
    protected boolean eagerFlush;
    protected boolean noFault;
    protected boolean noGrow;
    protected long currentPageId;
    protected long nextPageId;
    protected MuninnPageCursor linkedCursor;
    private long pointer;
    private int pageSize;
    private int filePageSize;
    private int offset;
    private boolean outOfBounds;
    private boolean isLinkedCursor;
    private Object cursorException;

    MuninnPageCursor(long victimPage, PageCursorTracer tracer) {
        this.victimPage = victimPage;
        this.pointer = victimPage;
        this.tracer = tracer;
    }

    final void initialiseFile(MuninnPagedFile pagedFile) {
        this.swapper = pagedFile.swapper;
        this.swapperId = pagedFile.swapperId;
        this.filePageSize = pagedFile.filePageSize;
    }

    final void initialiseFlags(MuninnPagedFile pagedFile, long pageId, int pf_flags) {
        this.pagedFile = pagedFile;
        this.pageId = pageId;
        this.pf_flags = pf_flags;
        this.eagerFlush = this.isFlagRaised(pf_flags, 64);
        this.noFault = this.isFlagRaised(pf_flags, 16);
        this.noGrow = this.noFault | this.isFlagRaised(pf_flags, 4);
    }

    private boolean isFlagRaised(int flagSet, int flag) {
        return (flagSet & flag) == flag;
    }

    @Override
    public final void rewind() {
        this.nextPageId = this.pageId;
        this.currentPageId = -1L;
    }

    public final void reset(long pageRef) {
        this.pinnedPageRef = pageRef;
        this.offset = 0;
        this.pointer = this.pagedFile.getAddress(pageRef);
        this.pageSize = this.filePageSize;
        this.pinEvent.setCachePageId(this.pagedFile.toId(pageRef));
    }

    @Override
    public final boolean next(long pageId) throws IOException {
        if (this.currentPageId == pageId) {
            return true;
        }
        this.nextPageId = pageId;
        return this.next();
    }

    @Override
    public final void close() {
        if (this.pagedFile == null) {
            return;
        }
        this.closeLinks(this);
        if (!this.isLinkedCursor) {
            this.releaseCursor();
        }
    }

    private void closeLinks(MuninnPageCursor cursor) {
        while (cursor != null && cursor.pagedFile != null) {
            cursor.unpinCurrentPage();
            cursor.pagedFile = null;
            cursor = cursor.linkedCursor;
        }
    }

    private void closeLinkedCursorIfAny() {
        if (this.linkedCursor != null) {
            this.closeLinks(this.linkedCursor);
        }
    }

    @Override
    public PageCursor openLinkedCursor(long pageId) {
        this.closeLinkedCursorIfAny();
        MuninnPagedFile pf = this.pagedFile;
        if (pf == null) {
            throw new IllegalStateException("Cannot open linked cursor on closed page cursor");
        }
        if (this.linkedCursor != null) {
            this.linkedCursor.initialiseFlags(pf, pageId, this.pf_flags);
            this.linkedCursor.rewind();
        } else {
            this.linkedCursor = (MuninnPageCursor)pf.io(pageId, this.pf_flags);
            this.linkedCursor.isLinkedCursor = true;
        }
        return this.linkedCursor;
    }

    void clearPageCursorState() {
        this.clearPageReference();
        this.currentPageId = -1L;
        this.cursorException = null;
    }

    void clearPageReference() {
        this.pageSize = 0;
        this.pinnedPageRef = 0L;
    }

    @Override
    public final long getCurrentPageId() {
        return this.currentPageId;
    }

    @Override
    public final int getCurrentPageSize() {
        return this.currentPageId == -1L ? -1 : this.pagedFile.pageSize();
    }

    @Override
    public final File getCurrentFile() {
        return this.currentPageId == -1L ? null : this.pagedFile.file();
    }

    protected void pin(long filePageId, boolean writeLock) throws IOException {
        this.pinEvent = this.tracer.beginPin(writeLock, filePageId, this.swapper);
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        long chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId);
        int[][] tt = this.pagedFile.translationTable;
        if (tt.length <= chunkId) {
            tt = this.expandTranslationTableCapacity(chunkId);
        }
        int[] chunk = tt[chunkId];
        while (true) {
            int mappedPageId;
            if ((mappedPageId = UnsafeUtil.getIntVolatile((Object)chunk, (long)chunkOffset)) != -1) {
                long pageRef = this.pagedFile.deref(mappedPageId);
                boolean locked = this.tryLockPage(pageRef);
                if (locked & this.pagedFile.isBoundTo(pageRef, this.swapperId, filePageId)) {
                    this.pinCursorToPage(pageRef, filePageId, this.swapper);
                    this.pinEvent.hit();
                    return;
                }
                if (!locked) continue;
                this.unlockPage(pageRef);
                continue;
            }
            if (this.uncommonPin(filePageId, chunkOffset, chunk)) break;
        }
    }

    private int[][] expandTranslationTableCapacity(int chunkId) {
        return this.pagedFile.expandCapacity(chunkId);
    }

    private boolean uncommonPin(long filePageId, long chunkOffset, int[] chunk) throws IOException {
        if (this.noFault) {
            this.currentPageId = -1L;
            return true;
        }
        LatchMap.Latch latch = this.pagedFile.pageFaultLatches.takeOrAwaitLatch(filePageId);
        if (latch != null) {
            if (UnsafeUtil.getIntVolatile((Object)chunk, (long)chunkOffset) == -1) {
                long pageRef = this.pageFault(filePageId, this.swapper, chunkOffset, chunk, latch);
                this.pinCursorToPage(pageRef, filePageId, this.swapper);
                return true;
            }
            latch.release();
        }
        return false;
    }

    private long pageFault(long filePageId, PageSwapper swapper, long chunkOffset, int[] chunk, LatchMap.Latch latch) throws IOException {
        long pageRef;
        PageFaultEvent faultEvent = this.pinEvent.beginPageFault();
        try {
            pageRef = this.pagedFile.grabFreeAndExclusivelyLockedPage(faultEvent);
        }
        catch (Throwable throwable) {
            this.abortPageFault(throwable, chunk, chunkOffset, latch, faultEvent);
            throw throwable;
        }
        try {
            this.assertPagedFileStillMappedAndGetIdOfLastPage();
            this.pagedFile.initBuffer(pageRef);
            this.pagedFile.fault(pageRef, swapper, this.pagedFile.swapperId, filePageId, faultEvent);
        }
        catch (Throwable throwable) {
            this.pagedFile.unlockExclusive(pageRef);
            this.abortPageFault(throwable, chunk, chunkOffset, latch, faultEvent);
            throw throwable;
        }
        UnsafeUtil.putIntVolatile((Object)chunk, (long)chunkOffset, (int)this.pagedFile.toId(pageRef));
        this.convertPageFaultLock(pageRef);
        latch.release();
        faultEvent.done();
        return pageRef;
    }

    private void abortPageFault(Throwable throwable, int[] chunk, long chunkOffset, LatchMap.Latch latch, PageFaultEvent faultEvent) {
        UnsafeUtil.putIntVolatile((Object)chunk, (long)chunkOffset, (int)-1);
        latch.release();
        faultEvent.done(throwable);
        this.pinEvent.done();
    }

    long assertPagedFileStillMappedAndGetIdOfLastPage() {
        return this.pagedFile.getLastPageId();
    }

    protected abstract void unpinCurrentPage();

    protected abstract void convertPageFaultLock(long var1);

    protected abstract void pinCursorToPage(long var1, long var3, PageSwapper var5);

    protected abstract boolean tryLockPage(long var1);

    protected abstract void unlockPage(long var1);

    protected abstract void releaseCursor();

    private long getBoundedPointer(int offset, int size) {
        long p = this.pointer;
        long can = p + (long)offset;
        if (boundsCheck && (can + (long)size > p + (long)this.pageSize || can < p)) {
            this.outOfBounds = true;
            return this.victimPage;
        }
        return can;
    }

    private long nextBoundedPointer(int size) {
        int offset = this.offset;
        long can = this.pointer + (long)offset;
        if (boundsCheck && offset + size > this.pageSize) {
            this.outOfBounds = true;
            return this.victimPage;
        }
        return can;
    }

    @Override
    public final byte getByte() {
        long p = this.nextBoundedPointer(1);
        byte b = UnsafeUtil.getByte((long)p);
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        long p = this.getBoundedPointer(offset, 1);
        return UnsafeUtil.getByte((long)p);
    }

    @Override
    public void putByte(byte value) {
        long p = this.nextBoundedPointer(1);
        UnsafeUtil.putByte((long)p, (byte)value);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        long p = this.getBoundedPointer(offset, 1);
        UnsafeUtil.putByte((long)p, (byte)value);
    }

    @Override
    public long getLong() {
        long p = this.nextBoundedPointer(8);
        long value = this.getLongAt(p);
        this.offset += 8;
        return value;
    }

    @Override
    public long getLong(int offset) {
        long p = this.getBoundedPointer(offset, 8);
        return this.getLongAt(p);
    }

    private long getLongAt(long p) {
        long value;
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            value = UnsafeUtil.getLong((long)p);
            if (!UnsafeUtil.storeByteOrderIsNative) {
                value = Long.reverseBytes(value);
            }
        } else {
            value = this.getLongBigEndian(p);
        }
        return value;
    }

    private long getLongBigEndian(long p) {
        long a = UnsafeUtil.getByte((long)p) & 0xFF;
        long b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        long c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        long d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        long e = UnsafeUtil.getByte((long)(p + 4L)) & 0xFF;
        long f = UnsafeUtil.getByte((long)(p + 5L)) & 0xFF;
        long g = UnsafeUtil.getByte((long)(p + 6L)) & 0xFF;
        long h = UnsafeUtil.getByte((long)(p + 7L)) & 0xFF;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    @Override
    public void putLong(long value) {
        long p = this.nextBoundedPointer(8);
        this.putLongAt(p, value);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        long p = this.getBoundedPointer(offset, 8);
        this.putLongAt(p, value);
    }

    private void putLongAt(long p, long value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putLong((long)p, (long)(UnsafeUtil.storeByteOrderIsNative ? value : Long.reverseBytes(value)));
        } else {
            this.putLongBigEndian(value, p);
        }
    }

    private void putLongBigEndian(long value, long p) {
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 56)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 48)));
        UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 40)));
        UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)(value >> 32)));
        UnsafeUtil.putByte((long)(p + 4L), (byte)((byte)(value >> 24)));
        UnsafeUtil.putByte((long)(p + 5L), (byte)((byte)(value >> 16)));
        UnsafeUtil.putByte((long)(p + 6L), (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 7L), (byte)((byte)value));
    }

    @Override
    public int getInt() {
        long p = this.nextBoundedPointer(4);
        int i = this.getIntAt(p);
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        long p = this.getBoundedPointer(offset, 4);
        return this.getIntAt(p);
    }

    private int getIntAt(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt((long)p);
            return UnsafeUtil.storeByteOrderIsNative ? x : Integer.reverseBytes(x);
        }
        return this.getIntBigEndian(p);
    }

    private int getIntBigEndian(long p) {
        int a = UnsafeUtil.getByte((long)p) & 0xFF;
        int b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        int c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        int d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public void putInt(int value) {
        long p = this.nextBoundedPointer(4);
        this.putIntAt(p, value);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        long p = this.getBoundedPointer(offset, 4);
        this.putIntAt(p, value);
    }

    private void putIntAt(long p, int value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putInt((long)p, (int)(UnsafeUtil.storeByteOrderIsNative ? value : Integer.reverseBytes(value)));
        } else {
            this.putIntBigEndian(value, p);
        }
    }

    private void putIntBigEndian(int value, long p) {
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 24)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 16)));
        UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)value));
    }

    @Override
    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        long p = this.getBoundedPointer(this.offset, length);
        if (!this.outOfBounds) {
            for (int i = 0; i < length; ++i) {
                data[arrayOffset + i] = UnsafeUtil.getByte((long)(p + (long)i));
            }
        }
        this.offset += length;
    }

    @Override
    public final void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        long p = this.getBoundedPointer(this.offset, length);
        if (!this.outOfBounds) {
            for (int i = 0; i < length; ++i) {
                byte b = data[arrayOffset + i];
                UnsafeUtil.putByte((long)(p + (long)i), (byte)b);
            }
        }
        this.offset += length;
    }

    @Override
    public final short getShort() {
        long p = this.nextBoundedPointer(2);
        short s = this.getShortAt(p);
        this.offset += 2;
        return s;
    }

    @Override
    public short getShort(int offset) {
        long p = this.getBoundedPointer(offset, 2);
        return this.getShortAt(p);
    }

    private short getShortAt(long p) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort((long)p);
            return UnsafeUtil.storeByteOrderIsNative ? x : Short.reverseBytes(x);
        }
        return this.getShortBigEndian(p);
    }

    private short getShortBigEndian(long p) {
        short a = (short)(UnsafeUtil.getByte((long)p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte((long)(p + 1L)) & 0xFF);
        return (short)(a << 8 | b);
    }

    @Override
    public void putShort(short value) {
        long p = this.nextBoundedPointer(2);
        this.putShortAt(p, value);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        long p = this.getBoundedPointer(offset, 2);
        this.putShortAt(p, value);
    }

    private void putShortAt(long p, short value) {
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            UnsafeUtil.putShort((long)p, (short)(UnsafeUtil.storeByteOrderIsNative ? value : Short.reverseBytes(value)));
        } else {
            this.putShortBigEndian(value, p);
        }
    }

    private void putShortBigEndian(short value, long p) {
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)value));
    }

    @Override
    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        int sourcePageSize = this.getCurrentPageSize();
        int targetPageSize = targetCursor.getCurrentPageSize();
        if (targetCursor.getClass() != MuninnWritePageCursor.class) {
            throw new IllegalArgumentException("Target cursor must be writable");
        }
        if (sourceOffset >= 0 & targetOffset >= 0 & sourceOffset < sourcePageSize & targetOffset < targetPageSize & lengthInBytes >= 0) {
            MuninnPageCursor cursor = (MuninnPageCursor)targetCursor;
            int remainingSource = sourcePageSize - sourceOffset;
            int remainingTarget = targetPageSize - targetOffset;
            int bytes = Math.min(lengthInBytes, Math.min(remainingSource, remainingTarget));
            UnsafeUtil.copyMemory((long)(this.pointer + (long)sourceOffset), (long)(cursor.pointer + (long)targetOffset), (long)bytes);
            return bytes;
        }
        this.outOfBounds = true;
        return 0;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
        if (offset < 0 | offset > this.filePageSize) {
            this.offset = 0;
            this.outOfBounds = true;
        }
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    @Override
    public boolean checkAndClearBoundsFlag() {
        MuninnPageCursor cursor = this;
        boolean result = false;
        do {
            result |= cursor.outOfBounds;
            cursor.outOfBounds = false;
        } while ((cursor = cursor.linkedCursor) != null);
        return result;
    }

    @Override
    public void checkAndClearCursorException() throws CursorException {
        MuninnPageCursor cursor = this;
        do {
            Object error;
            if ((error = cursor.cursorException) == null) continue;
            this.clearCursorError(cursor);
            if (usePreciseCursorErrorStackTraces) {
                throw (CursorExceptionWithPreciseStackTrace)error;
            }
            throw new CursorException((String)error);
        } while ((cursor = cursor.linkedCursor) != null);
    }

    @Override
    public void clearCursorException() {
        this.clearCursorError(this);
    }

    private void clearCursorError(MuninnPageCursor cursor) {
        while (cursor != null) {
            cursor.cursorException = null;
            cursor = cursor.linkedCursor;
        }
    }

    @Override
    public void raiseOutOfBounds() {
        this.outOfBounds = true;
    }

    @Override
    public void setCursorException(String message) {
        Objects.requireNonNull(message);
        this.cursorException = usePreciseCursorErrorStackTraces ? new CursorExceptionWithPreciseStackTrace(message) : message;
    }

    @Override
    public void zapPage() {
        if (this.pageSize == 0) {
            this.outOfBounds = true;
        } else {
            UnsafeUtil.setMemory((long)this.pointer, (long)this.pageSize, (byte)0);
        }
    }

    @Override
    public boolean isWriteLocked() {
        return this.isFlagRaised(this.pf_flags, 2);
    }
}

