/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.mem.NativeMemoryAllocationRefusedError;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public final class GrabAllocator
implements MemoryAllocator {
    private static final long GRAB_SIZE = FeatureToggles.getInteger(GrabAllocator.class, (String)"GRAB_SIZE", (int)524288);
    private long memoryReserve;
    private Grab grabs;

    GrabAllocator(long expectedMaxMemory) {
        this.memoryReserve = expectedMaxMemory;
    }

    @Override
    public synchronized long usedMemory() {
        long sum = 0L;
        Grab grab = this.grabs;
        while (grab != null) {
            sum += grab.nextPointer - grab.address;
            grab = grab.next;
        }
        return sum;
    }

    @Override
    public synchronized long availableMemory() {
        Grab grab = this.grabs;
        long availableInCurrentGrab = 0L;
        if (grab != null) {
            availableInCurrentGrab = grab.limit - grab.nextPointer;
        }
        return Math.max(this.memoryReserve, 0L) + availableInCurrentGrab;
    }

    @Override
    public synchronized long allocateAligned(long bytes, long alignment) {
        if (alignment <= 0L) {
            throw new IllegalArgumentException("Invalid alignment: " + alignment + "; alignment must be positive");
        }
        if (bytes > GRAB_SIZE) {
            Grab nextGrab = this.grabs == null ? null : this.grabs.next;
            Grab allocationGrab = new Grab(nextGrab, bytes);
            if (!allocationGrab.canAllocate(bytes)) {
                allocationGrab.free();
                allocationGrab = new Grab(nextGrab, bytes + alignment);
            }
            long allocation = allocationGrab.allocate(bytes, alignment);
            this.grabs = this.grabs == null ? allocationGrab : this.grabs.setNext(allocationGrab);
            this.memoryReserve -= bytes;
            return allocation;
        }
        if (this.grabs == null || !this.grabs.canAllocate(bytes)) {
            long desiredGrabSize = Math.min(GRAB_SIZE, this.memoryReserve);
            if (desiredGrabSize < bytes) {
                desiredGrabSize = bytes;
                Grab grab = new Grab(this.grabs, desiredGrabSize);
                if (grab.canAllocate(bytes)) {
                    this.memoryReserve -= desiredGrabSize;
                    this.grabs = grab;
                    return this.grabs.allocate(bytes, alignment);
                }
                grab.free();
                desiredGrabSize = bytes + alignment;
            }
            this.memoryReserve -= desiredGrabSize;
            this.grabs = new Grab(this.grabs, desiredGrabSize);
        }
        return this.grabs.allocate(bytes, alignment);
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        Grab current = this.grabs;
        while (current != null) {
            current.free();
            current = current.next;
        }
    }

    private static long allocateNativeMemory(long size) {
        try {
            return UnsafeUtil.allocateMemory((long)size);
        }
        catch (OutOfMemoryError e) {
            NativeMemoryAllocationRefusedError error = new NativeMemoryAllocationRefusedError(size);
            try {
                error.initCause(e);
            }
            catch (Throwable ignore) {
                try {
                    error.addSuppressed(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw error;
        }
    }

    private static class Grab {
        public final Grab next;
        private final long address;
        private final long limit;
        private long nextPointer;

        Grab(Grab next, long size) {
            this.next = next;
            this.address = GrabAllocator.allocateNativeMemory(size);
            this.limit = this.address + size;
            this.nextPointer = this.address;
        }

        Grab(Grab next, long address, long limit, long nextPointer) {
            this.next = next;
            this.address = address;
            this.limit = limit;
            this.nextPointer = nextPointer;
        }

        private long nextAligned(long pointer, long alignment) {
            long mask = alignment - 1L;
            if ((pointer & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == pointer) {
                return pointer;
            }
            return pointer + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long allocate(long bytes, long alignment) {
            long allocation = this.nextAligned(this.nextPointer, alignment);
            this.nextPointer = allocation + bytes;
            return allocation;
        }

        void free() {
            UnsafeUtil.free((long)this.address);
        }

        boolean canAllocate(long bytes) {
            return this.nextPointer + bytes <= this.limit;
        }

        Grab setNext(Grab grab) {
            return new Grab(grab, this.address, this.limit, this.nextPointer);
        }

        public String toString() {
            long size = this.limit - this.address;
            long reserve = this.nextPointer > this.limit ? 0L : this.limit - this.nextPointer;
            double use = (1.0 - (double)reserve / (double)size) * 100.0;
            return String.format("Grab[size = %d bytes, reserve = %d bytes, use = %5.2f %%]", size, reserve, use);
        }
    }
}

