/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import org.neo4j.io.fs.StoreChannel;

public class OffsetChannel
implements StoreChannel {
    private final StoreChannel delegate;
    private final long offset;

    public OffsetChannel(StoreChannel delegate, long offset) {
        this.delegate = delegate;
        this.offset = offset;
    }

    private long offset(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException("Position must be >= 0.");
        }
        return Math.addExact(position, this.offset);
    }

    @Override
    public FileLock tryLock() throws IOException {
        return this.delegate.tryLock();
    }

    @Override
    public void writeAll(ByteBuffer src, long position) throws IOException {
        this.delegate.writeAll(src, this.offset(position));
    }

    @Override
    public void writeAll(ByteBuffer src) throws IOException {
        this.delegate.writeAll(src);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return this.delegate.read(dst, this.offset(position));
    }

    @Override
    public void readAll(ByteBuffer dst) throws IOException {
        this.delegate.readAll(dst);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.delegate.force(metaData);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public long position() throws IOException {
        return this.delegate.position() - this.offset;
    }

    @Override
    public StoreChannel position(long newPosition) throws IOException {
        return this.delegate.position(this.offset(newPosition));
    }

    @Override
    public long size() throws IOException {
        return this.delegate.size() - this.offset;
    }

    @Override
    public StoreChannel truncate(long size) throws IOException {
        return this.delegate.truncate(this.offset(size));
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.delegate.write(srcs);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.delegate.read(dsts);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

