/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.PrintStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class ThreadTestUtils {
    private ThreadTestUtils() {
    }

    public static Thread fork(Runnable runnable) {
        String name = "Forked-from-" + Thread.currentThread().getName();
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static <T> Future<T> forkFuture(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        ThreadTestUtils.fork(task);
        return task;
    }

    public static void awaitThreadState(Thread thread, long maxWaitMillis, Thread.State first, Thread.State ... rest) {
        Thread.State currentState;
        EnumSet<Thread.State[]> set = EnumSet.of(first, rest);
        long deadline = maxWaitMillis + System.currentTimeMillis();
        do {
            currentState = thread.getState();
            if (System.currentTimeMillis() > deadline) {
                throw new AssertionError((Object)("Timed out waiting for thread state of <" + set + ">: " + thread + " (state = " + (Object)((Object)thread.getState()) + ")"));
            }
        } while (!set.contains((Object)currentState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAllStackTraces() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
                StackTraceElement[] elements;
                System.err.println("Stack Trace for " + entry.getKey().getName());
                for (StackTraceElement element : elements = entry.getValue()) {
                    System.err.println("\tat " + element.toString());
                }
                System.err.println();
            }
        }
    }
}

