/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.randomharness.Action;
import org.neo4j.io.pagecache.randomharness.Command;
import org.neo4j.io.pagecache.randomharness.CommandPrimer;
import org.neo4j.io.pagecache.randomharness.Phase;
import org.neo4j.io.pagecache.randomharness.Plan;
import org.neo4j.io.pagecache.randomharness.PlanRunner;
import org.neo4j.io.pagecache.randomharness.RecordFormat;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.test.rule.TestDirectory;

public class RandomPageCacheTestHarness
implements Closeable {
    private double mischiefRate = 0.1;
    private double failureRate = 0.1;
    private double errorRate = 0.0;
    private int concurrencyLevel = 1;
    private int initialMappedFiles = 2;
    private int cachePageCount = 20;
    private int filePageCount = this.cachePageCount * 10;
    private int filePageSize;
    private PageCacheTracer tracer = PageCacheTracer.NULL;
    private PageCursorTracerSupplier cursorTracerSupplier = PageCursorTracerSupplier.NULL;
    private int commandCount = 1000;
    private double[] commandProbabilityFactors;
    private long randomSeed;
    private boolean fixedRandomSeed;
    private FileSystemAbstraction fs;
    private boolean useAdversarialIO;
    private Plan plan;
    private Phase preparation;
    private Phase verification;
    private RecordFormat recordFormat;

    public RandomPageCacheTestHarness() {
        Command[] commands = Command.values();
        this.commandProbabilityFactors = new double[commands.length];
        for (Command command : commands) {
            this.commandProbabilityFactors[command.ordinal()] = command.getDefaultProbabilityFactor();
        }
        this.fs = new EphemeralFileSystemAbstraction();
        this.useAdversarialIO = true;
        this.recordFormat = new StandardRecordFormat();
    }

    public void disableCommands(Command ... commands) {
        for (Command command : commands) {
            this.setCommandProbabilityFactor(command, 0.0);
        }
    }

    public void setCommandProbabilityFactor(Command command, double probabilityFactor) {
        assert (0.0 <= probabilityFactor) : "Probability factor cannot be negative";
        this.commandProbabilityFactors[command.ordinal()] = probabilityFactor;
    }

    public void setUseAdversarialIO(boolean useAdversarialIO) {
        this.useAdversarialIO = useAdversarialIO;
    }

    public void setTracer(PageCacheTracer tracer) {
        this.tracer = tracer;
    }

    public void setCursorTracerSupplier(PageCursorTracerSupplier cursorTracerSupplier) {
        this.cursorTracerSupplier = cursorTracerSupplier;
    }

    public void setMischiefRate(double rate) {
        this.mischiefRate = rate;
    }

    public void setFailureRate(double rate) {
        this.failureRate = rate;
    }

    public void setErrorRate(double rate) {
        this.errorRate = rate;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    public void setInitialMappedFiles(int initialMappedFiles) {
        this.initialMappedFiles = initialMappedFiles;
    }

    public void setCachePageCount(int count) {
        this.cachePageCount = count;
    }

    public void setFilePageCount(int count) {
        this.filePageCount = count;
    }

    public void setFilePageSize(int size) {
        this.filePageSize = size;
    }

    public void setCommandCount(int commandCount) {
        this.commandCount = commandCount;
    }

    public void setPreparation(Phase preparation) {
        this.preparation = preparation;
    }

    public void setVerification(Phase verification) {
        this.verification = verification;
    }

    public void setRecordFormat(RecordFormat recordFormat) {
        this.recordFormat = recordFormat;
    }

    public void setRandomSeed(long randomSeed) {
        this.randomSeed = randomSeed;
        this.fixedRandomSeed = true;
    }

    public void setFileSystem(FileSystemAbstraction fileSystem) {
        this.fs = fileSystem;
    }

    public void describePreviousRun(PrintStream out) {
        out.println("randomSeed = " + this.randomSeed);
        out.println("commandCount = " + this.commandCount);
        out.println("concurrencyLevel (number of worker threads) = " + this.concurrencyLevel);
        out.println("initialMappedFiles = " + this.initialMappedFiles);
        out.println("cachePageCount = " + this.cachePageCount);
        out.println("tracer = " + this.tracer);
        out.println("useAdversarialIO = " + this.useAdversarialIO);
        out.println("mischeifRate = " + this.mischiefRate);
        out.println("failureRate = " + this.failureRate);
        out.println("errorRate = " + this.errorRate);
        out.println("Command probability factors:");
        Command[] commands = Command.values();
        for (int i = 0; i < commands.length; ++i) {
            out.print("  ");
            out.print((Object)commands[i]);
            out.print(" = ");
            out.println(this.commandProbabilityFactors[i]);
        }
        if (this.plan != null) {
            this.plan.print(out);
        }
    }

    public void run(long iterationTimeout, TimeUnit unit) throws Exception {
        this.run(1, iterationTimeout, unit);
    }

    public void run(int iterations, long iterationTimeout, TimeUnit unit) throws Exception {
        try {
            for (int i = 0; i < iterations; ++i) {
                this.runIteration(iterationTimeout, unit);
            }
        }
        catch (Exception e) {
            this.describePreviousRun(System.err);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runIteration(long timeout, TimeUnit unit) throws Exception {
        long now;
        assert (this.filePageSize % this.recordFormat.getRecordSize() == 0) : "File page size must be a multiple of the record size";
        if (!this.fixedRandomSeed) {
            this.randomSeed = ThreadLocalRandom.current().nextLong();
        }
        FileSystemAbstraction fs = this.fs;
        File[] files = this.buildFileNames();
        RandomAdversary adversary = new RandomAdversary(this.mischiefRate, this.failureRate, this.errorRate);
        adversary.setProbabilityFactor(0.0);
        if (this.useAdversarialIO) {
            adversary.setSeed(this.randomSeed);
            fs = new AdversarialFileSystemAbstraction(adversary, fs);
        }
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.open(fs, Configuration.EMPTY);
        MuninnPageCache cache = new MuninnPageCache((PageSwapperFactory)swapperFactory, this.cachePageCount, this.tracer, this.cursorTracerSupplier);
        if (this.filePageSize == 0) {
            this.filePageSize = cache.pageSize();
        }
        cache.setPrintExceptionsOnClose(false);
        HashMap<File, PagedFile> fileMap = new HashMap<File, PagedFile>(files.length);
        for (int i = 0; i < Math.min(files.length, this.initialMappedFiles); ++i) {
            File file = files[i];
            fileMap.put(file, cache.map(file, this.filePageSize, new OpenOption[0]));
        }
        this.plan = this.plan(cache, files, fileMap);
        PlanRunner planRunner = new PlanRunner(this.plan);
        Future[] futures = new Future[this.concurrencyLevel];
        ExecutorService executor = Executors.newFixedThreadPool(this.concurrencyLevel);
        for (int i = 0; i < this.concurrencyLevel; ++i) {
            futures[i] = executor.submit(planRunner);
        }
        if (this.preparation != null) {
            this.preparation.run((PageCache)cache, this.fs, this.plan.getFilesTouched());
        }
        adversary.setProbabilityFactor(1.0);
        this.plan.start();
        long deadlineMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        try {
            for (Future future : futures) {
                now = System.currentTimeMillis();
                if (deadlineMillis < now) {
                    throw new TimeoutException();
                }
                future.get(deadlineMillis - now, TimeUnit.MILLISECONDS);
            }
            adversary.setProbabilityFactor(0.0);
            this.runVerificationPhase(cache);
        }
        finally {
            adversary.setProbabilityFactor(0.0);
            for (Future future : futures) {
                future.cancel(true);
            }
            executor.shutdown();
            now = System.currentTimeMillis();
            executor.awaitTermination(deadlineMillis - now, TimeUnit.MILLISECONDS);
            this.plan.close();
            cache.close();
            if (this.fs instanceof EphemeralFileSystemAbstraction) {
                this.fs.close();
                this.fs = new EphemeralFileSystemAbstraction();
            } else {
                for (File file : files) {
                    file.delete();
                }
            }
        }
    }

    private void runVerificationPhase(MuninnPageCache cache) throws Exception {
        if (this.verification != null) {
            cache.flushAndForce();
            this.verification.run((PageCache)cache, this.fs, this.plan.getFilesTouched());
        }
    }

    private File[] buildFileNames() throws IOException {
        String s = "abcdefghijklmnopqrstuvwxyz";
        File[] files = new File[s.length()];
        TestDirectory testDirectory = TestDirectory.testDirectory(RandomPageCacheTestHarness.class, this.fs);
        File base = testDirectory.prepareDirectoryForTest("random-pagecache-test-harness");
        for (int i = 0; i < s.length(); ++i) {
            files[i] = new File(base, s.substring(i, i + 1)).getCanonicalFile();
            this.fs.mkdirs(files[i].getParentFile());
            StoreChannel channel = this.fs.open(files[i], OpenMode.READ_WRITE);
            channel.truncate(0L);
            channel.close();
        }
        return files;
    }

    private Plan plan(MuninnPageCache cache, File[] files, Map<File, PagedFile> fileMap) {
        Action[] plan = new Action[this.commandCount];
        int[] commandWeights = this.computeCommandWeights();
        int commandWeightSum = this.sum(commandWeights);
        Random rng = new Random(this.randomSeed);
        CommandPrimer primer = new CommandPrimer(rng, cache, files, fileMap, this.filePageCount, this.filePageSize, this.recordFormat);
        for (int i = 0; i < plan.length; ++i) {
            Action action;
            Command command = this.pickCommand(rng.nextInt(commandWeightSum), commandWeights);
            plan[i] = action = primer.prime(command);
            if (action != null) continue;
            --i;
        }
        return new Plan(plan, fileMap, primer.getMappedFiles(), primer.getFilesTouched());
    }

    private int[] computeCommandWeights() {
        Command[] commands = Command.values();
        int[] weights = new int[commands.length];
        int base = 100000000;
        for (int i = 0; i < commands.length; ++i) {
            weights[i] = (int)((double)base * this.commandProbabilityFactors[i]);
        }
        return weights;
    }

    private int sum(int[] xs) {
        int sum = 0;
        for (int x : xs) {
            sum += x;
        }
        return sum;
    }

    private Command pickCommand(int randomPick, int[] commandWeights) {
        for (int i = 0; i < commandWeights.length; ++i) {
            if ((randomPick -= commandWeights[i]) >= 0) continue;
            return Command.values()[i];
        }
        throw new AssertionError((Object)("Tried to pick randomPick = " + randomPick + " from weights = " + Arrays.toString(commandWeights)));
    }
}

