/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;

public class ByteArrayPageCursor
extends PageCursor {
    private final ByteBuffer buffer;
    private CursorException cursorException;

    public static PageCursor wrap(byte[] array, int offset, int length) {
        return new ByteArrayPageCursor(array, offset, length);
    }

    public static PageCursor wrap(byte[] array) {
        return ByteArrayPageCursor.wrap(array, 0, array.length);
    }

    public static PageCursor wrap(int length) {
        return ByteArrayPageCursor.wrap(new byte[length]);
    }

    public ByteArrayPageCursor(byte[] array) {
        this(array, 0, array.length);
    }

    public ByteArrayPageCursor(byte[] array, int offset, int length) {
        this.buffer = ByteBuffer.wrap(array, offset, length);
    }

    public byte getByte() {
        return this.buffer.get();
    }

    public byte getByte(int offset) {
        return this.buffer.get(offset);
    }

    public void putByte(byte value) {
        this.buffer.put(value);
    }

    public void putByte(int offset, byte value) {
        this.buffer.put(offset, value);
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public long getLong(int offset) {
        return this.buffer.getLong(offset);
    }

    public void putLong(long value) {
        this.buffer.putLong(value);
    }

    public void putLong(int offset, long value) {
        this.buffer.putLong(offset, value);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int offset) {
        return this.buffer.getInt(offset);
    }

    public void putInt(int value) {
        this.buffer.putInt(value);
    }

    public void putInt(int offset, int value) {
        this.buffer.putInt(offset, value);
    }

    public void getBytes(byte[] data) {
        this.buffer.get(data);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.buffer.get(data, arrayOffset, length);
    }

    public void putBytes(byte[] data) {
        this.buffer.put(data);
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        this.buffer.put(data, arrayOffset, length);
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public short getShort(int offset) {
        return this.buffer.getShort(offset);
    }

    public void putShort(short value) {
        this.buffer.putShort(value);
    }

    public void putShort(int offset, short value) {
        this.buffer.putShort(offset, value);
    }

    public void setOffset(int offset) {
        this.buffer.position(offset);
    }

    public int getOffset() {
        return this.buffer.position();
    }

    public long getCurrentPageId() {
        throw new UnsupportedOperationException();
    }

    public int getCurrentPageSize() {
        return this.buffer.capacity();
    }

    public File getCurrentFile() {
        throw new UnsupportedOperationException();
    }

    public void rewind() {
        this.setOffset(0);
    }

    public boolean next() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean next(long pageId) throws IOException {
        return pageId == 0L;
    }

    public void close() {
    }

    public boolean shouldRetry() throws IOException {
        return false;
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        throw new UnsupportedOperationException();
    }

    public boolean checkAndClearBoundsFlag() {
        return false;
    }

    public void checkAndClearCursorException() throws CursorException {
        if (this.cursorException != null) {
            try {
                throw this.cursorException;
            }
            catch (Throwable throwable) {
                this.cursorException = null;
                throw throwable;
            }
        }
    }

    public void raiseOutOfBounds() {
        throw new UnsupportedOperationException();
    }

    public void setCursorException(String message) {
        this.cursorException = (CursorException)Exceptions.chain((Throwable)this.cursorException, (Throwable)new CursorException(message));
    }

    public void clearCursorException() {
    }

    public PageCursor openLinkedCursor(long pageId) {
        throw new UnsupportedOperationException();
    }

    public void zapPage() {
        Arrays.fill(this.buffer.array(), (byte)0);
    }

    public boolean isWriteLocked() {
        return true;
    }
}

