/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.CloseTrackingFileSystem;
import org.neo4j.io.fs.DelegateFileSystemAbstraction;

public class DelegateFileSystemAbstractionTest {
    @Test
    public void closeAllResourcesOnClose() throws Exception {
        TrackableFileSystem fileSystem = new TrackableFileSystem();
        CloseTrackingFileSystem closeTrackingFileSystem = new CloseTrackingFileSystem();
        try (DelegateFileSystemAbstraction fileSystemAbstraction = new DelegateFileSystemAbstraction((FileSystem)fileSystem);){
            fileSystemAbstraction.getOrCreateThirdPartyFileSystem(CloseTrackingFileSystem.class, closeTrackingFileSystemClass -> closeTrackingFileSystem);
        }
        Assert.assertFalse((boolean)fileSystem.isOpen());
        Assert.assertTrue((boolean)closeTrackingFileSystem.isClosed());
    }

    @Test
    public void delegatedFileSystemWatcher() throws IOException {
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        try (DelegateFileSystemAbstraction abstraction = new DelegateFileSystemAbstraction(fileSystem);){
            Assert.assertNotNull((Object)abstraction.fileWatcher());
        }
        ((FileSystem)Mockito.verify((Object)fileSystem)).newWatchService();
    }

    private static class TrackableFileSystem
    extends FileSystem {
        private boolean closed;

        private TrackableFileSystem() {
        }

        @Override
        public FileSystemProvider provider() {
            return null;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public boolean isOpen() {
            return !this.closed;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public String getSeparator() {
            return null;
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return null;
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return null;
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return null;
        }

        @Override
        public Path getPath(String first, String ... more) {
            return null;
        }

        @Override
        public PathMatcher getPathMatcher(String syntaxAndPattern) {
            return null;
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return null;
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return null;
        }
    }
}

