/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultPageCursorTracerTest {
    private PageSwapper swapper;
    private PageCursorTracer pageCursorTracer;
    private DefaultPageCacheTracer cacheTracer;

    @Before
    public void setUp() {
        this.cacheTracer = new DefaultPageCacheTracer();
        this.pageCursorTracer = this.createTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L));
    }

    @Test
    public void countPinsAndUnpins() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        pinEvent.done();
        pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
    }

    @Test
    public void noHitForPinEventWithPageFault() {
        this.pinFaultAndHit();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)0L, (long)this.pageCursorTracer.hits());
    }

    @Test
    public void hitForPinEventWithoutPageFault() {
        this.pinAndHit();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.hits());
    }

    @Test
    public void accumulateHitsReporting() {
        this.pinAndHit();
        this.pinAndHit();
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.hits());
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.accumulatedHits());
        this.pageCursorTracer.reportEvents();
        this.pinAndHit();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.hits());
        Assert.assertEquals((long)3L, (long)this.pageCursorTracer.accumulatedHits());
    }

    @Test
    public void accumulatedFaultsReporting() {
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.accumulatedFaults());
        this.pageCursorTracer.reportEvents();
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)4L, (long)this.pageCursorTracer.accumulatedFaults());
        Assert.assertEquals((long)0L, (long)this.pageCursorTracer.accumulatedHits());
    }

    @Test
    public void countHitsOnlyForPinEventsWithoutPageFaults() {
        this.pinAndHit();
        this.pinAndHit();
        this.pinAndHit();
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinAndHit();
        this.pinAndHit();
        Assert.assertEquals((long)7L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)5L, (long)this.pageCursorTracer.hits());
    }

    @Test
    public void countPageFaultsAndBytesRead() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(42L);
        pageFaultEvent.done();
        pinEvent.done();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)84L, (long)this.pageCursorTracer.bytesRead());
    }

    @Test
    public void countPageEvictions() throws Exception {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent faultEvent = pinEvent.beginPageFault();
        EvictionEvent evictionEvent = faultEvent.beginEviction();
        evictionEvent.setFilePageId(0L);
        evictionEvent.setCachePageId(0L);
        evictionEvent.threwException(new IOException("exception"));
        evictionEvent.close();
        faultEvent.done();
        pinEvent.done();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.evictionExceptions());
    }

    @Test
    public void countFlushesAndBytesWritten() throws Exception {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent faultEvent = pinEvent.beginPageFault();
        EvictionEvent evictionEvent = faultEvent.beginEviction();
        FlushEventOpportunity flushEventOpportunity = evictionEvent.flushEventOpportunity();
        FlushEvent flushEvent = flushEventOpportunity.beginFlush(0L, 0L, this.swapper);
        flushEvent.addBytesWritten(27L);
        flushEvent.done();
        FlushEvent flushEvent1 = flushEventOpportunity.beginFlush(0L, 1L, this.swapper);
        flushEvent1.addBytesWritten(13L);
        flushEvent1.done();
        evictionEvent.close();
        faultEvent.done();
        pinEvent.done();
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assert.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assert.assertEquals((long)2L, (long)this.pageCursorTracer.flushes());
        Assert.assertEquals((long)40L, (long)this.pageCursorTracer.bytesWritten());
    }

    @Test
    public void reportCountersToPageCursorTracer() {
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assert.assertEquals((long)1L, (long)this.cacheTracer.pins());
        Assert.assertEquals((long)1L, (long)this.cacheTracer.unpins());
        Assert.assertEquals((long)1L, (long)this.cacheTracer.faults());
        Assert.assertEquals((long)1L, (long)this.cacheTracer.evictions());
        Assert.assertEquals((long)1L, (long)this.cacheTracer.evictionExceptions());
        Assert.assertEquals((long)1L, (long)this.cacheTracer.flushes());
        Assert.assertEquals((long)10L, (long)this.cacheTracer.bytesWritten());
        Assert.assertEquals((long)150L, (long)this.cacheTracer.bytesRead());
        this.generateEventSet();
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assert.assertEquals((long)3L, (long)this.cacheTracer.pins());
        Assert.assertEquals((long)3L, (long)this.cacheTracer.unpins());
        Assert.assertEquals((long)3L, (long)this.cacheTracer.faults());
        Assert.assertEquals((long)3L, (long)this.cacheTracer.evictions());
        Assert.assertEquals((long)3L, (long)this.cacheTracer.evictionExceptions());
        Assert.assertEquals((long)3L, (long)this.cacheTracer.flushes());
        Assert.assertEquals((long)30L, (long)this.cacheTracer.bytesWritten());
        Assert.assertEquals((long)450L, (long)this.cacheTracer.bytesRead());
    }

    @Test
    public void shouldCalculateHitRatio() throws Exception {
        Assert.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinFaultAndHit();
        Assert.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinAndHit();
        Assert.assertEquals((double)0.5, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinFaultAndHit();
        this.pinAndHit();
        this.pinAndHit();
        Assert.assertEquals((double)0.42857142857142855, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pageCursorTracer.reportEvents();
        Assert.assertEquals((double)0.42857142857142855, (double)this.cacheTracer.hitRatio(), (double)1.0E-4);
    }

    private void generateEventSet() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(false, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pageFaultEvent.addBytesRead(150L);
        EvictionEvent evictionEvent = pageFaultEvent.beginEviction();
        FlushEventOpportunity flushEventOpportunity = evictionEvent.flushEventOpportunity();
        FlushEvent flushEvent = flushEventOpportunity.beginFlush(0L, 0L, this.swapper);
        flushEvent.addBytesWritten(10L);
        flushEvent.done();
        evictionEvent.threwException(new IOException("eviction exception"));
        evictionEvent.close();
        pageFaultEvent.done();
        pinEvent.done();
    }

    private PageCursorTracer createTracer() {
        DefaultPageCursorTracer pageCursorTracer = new DefaultPageCursorTracer();
        pageCursorTracer.init((PageCacheTracer)this.cacheTracer);
        return pageCursorTracer;
    }

    private void pinAndHit() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        pinEvent.hit();
        pinEvent.done();
    }

    private void pinFaultAndHit() {
        PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
        PageFaultEvent pageFaultEvent = pinEvent.beginPageFault();
        pinEvent.hit();
        pageFaultEvent.done();
        pinEvent.done();
    }
}

