/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;

public class MuninnPageCacheFixture
extends PageCacheTestSupport.Fixture<MuninnPageCache> {
    CountDownLatch backgroundFlushLatch;

    @Override
    public MuninnPageCache createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier) {
        long memory = MuninnPageCache.memoryRequiredForPages((long)maxPages);
        MemoryAllocator allocator = MemoryAllocator.createAllocator((String)String.valueOf(memory));
        return new MuninnPageCache(swapperFactory, allocator, tracer, cursorTracerSupplier);
    }

    @Override
    public void tearDownPageCache(MuninnPageCache pageCache) throws IOException {
        if (this.backgroundFlushLatch != null) {
            this.backgroundFlushLatch.countDown();
            this.backgroundFlushLatch = null;
        }
        pageCache.close();
    }
}

