/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;

public class StubPageCursor
extends PageCursor {
    private final long pageId;
    private final int pageSize;
    protected ByteBuffer page;
    private int currentOffset;
    private boolean observedOverflow;
    private String cursorErrorMessage;
    private boolean closed;
    private boolean needsRetry;
    protected StubPageCursor linkedCursor;
    private boolean writeLocked;

    public StubPageCursor(long initialPageId, int pageSize) {
        this(initialPageId, ByteBuffer.allocateDirect(pageSize));
    }

    public StubPageCursor(long initialPageId, ByteBuffer buffer) {
        this.pageId = initialPageId;
        this.pageSize = buffer.capacity();
        this.page = buffer;
        this.writeLocked = true;
    }

    public long getCurrentPageId() {
        return this.pageId;
    }

    public int getCurrentPageSize() {
        return this.pageSize;
    }

    public File getCurrentFile() {
        return new File("");
    }

    public void rewind() {
        throw new UnsupportedOperationException();
    }

    public boolean next() throws IOException {
        return true;
    }

    public boolean next(long pageId) throws IOException {
        return true;
    }

    public void close() {
        this.closed = true;
        if (this.linkedCursor != null) {
            this.linkedCursor.close();
            this.linkedCursor = null;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean shouldRetry() throws IOException {
        if (this.needsRetry) {
            this.checkAndClearBoundsFlag();
        }
        return this.needsRetry || this.linkedCursor != null && this.linkedCursor.shouldRetry();
    }

    public void setNeedsRetry(boolean needsRetry) {
        this.needsRetry = needsRetry;
    }

    public int copyTo(int sourceOffset, PageCursor targetCursor, int targetOffset, int lengthInBytes) {
        return 0;
    }

    public boolean checkAndClearBoundsFlag() {
        boolean overflow = this.observedOverflow;
        this.observedOverflow = false;
        return overflow || this.linkedCursor != null && this.linkedCursor.checkAndClearBoundsFlag();
    }

    public void checkAndClearCursorException() throws CursorException {
        String message = this.cursorErrorMessage;
        if (message != null) {
            throw new CursorException(message);
        }
    }

    public void raiseOutOfBounds() {
        this.observedOverflow = true;
    }

    public void setCursorException(String message) {
        this.cursorErrorMessage = message;
    }

    public void clearCursorException() {
        this.cursorErrorMessage = null;
    }

    public PageCursor openLinkedCursor(long pageId) {
        this.linkedCursor = new StubPageCursor(pageId, this.pageSize);
        return this.linkedCursor;
    }

    public byte getByte() {
        byte value = this.getByte(this.currentOffset);
        ++this.currentOffset;
        return value;
    }

    public byte getByte(int offset) {
        try {
            return this.page.get(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    private byte handleOverflow() {
        this.observedOverflow = true;
        return (byte)ThreadLocalRandom.current().nextInt();
    }

    public void putByte(byte value) {
        this.putByte(this.currentOffset, value);
        ++this.currentOffset;
    }

    public void putByte(int offset, byte value) {
        try {
            this.page.put(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public long getLong() {
        long value = this.getLong(this.currentOffset);
        this.currentOffset += 8;
        return value;
    }

    public long getLong(int offset) {
        try {
            return this.page.getLong(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putLong(long value) {
        this.putLong(this.currentOffset, value);
        this.currentOffset += 8;
    }

    public void putLong(int offset, long value) {
        try {
            this.page.putLong(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public int getInt() {
        int value = this.getInt(this.currentOffset);
        this.currentOffset += 4;
        return value;
    }

    public int getInt(int offset) {
        try {
            return this.page.getInt(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putInt(int value) {
        this.putInt(this.currentOffset, value);
        this.currentOffset += 4;
    }

    public void putInt(int offset, int value) {
        try {
            this.page.putInt(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    public void getBytes(byte[] data, int arrayOffset, int length) {
        try {
            assert (arrayOffset == 0) : "please implement support for arrayOffset";
            this.page.position(this.currentOffset);
            this.page.get(data, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    public void putBytes(byte[] data, int arrayOffset, int length) {
        try {
            assert (arrayOffset == 0) : "please implement support for arrayOffset";
            this.page.position(this.currentOffset);
            this.page.put(data, arrayOffset, length);
            this.currentOffset += length;
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public short getShort() {
        short value = this.getShort(this.currentOffset);
        this.currentOffset += 2;
        return value;
    }

    public short getShort(int offset) {
        try {
            return this.page.getShort(offset);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            return this.handleOverflow();
        }
    }

    public void putShort(short value) {
        this.putShort(this.currentOffset, value);
        this.currentOffset += 2;
    }

    public void putShort(int offset, short value) {
        try {
            this.page.putShort(offset, value);
        }
        catch (IndexOutOfBoundsException | BufferOverflowException | BufferUnderflowException e) {
            this.handleOverflow();
        }
    }

    public int getOffset() {
        return this.currentOffset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.currentOffset = offset;
    }

    public void zapPage() {
        for (int i = 0; i < this.pageSize; ++i) {
            this.putByte(i, (byte)0);
        }
    }

    public String toString() {
        return "PageCursor{currentOffset=" + this.currentOffset + ", page=" + this.page + '}';
    }

    public boolean isWriteLocked() {
        return this.writeLocked;
    }

    public void setWriteLocked(boolean writeLocked) {
        this.writeLocked = writeLocked;
    }
}

