/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ObjectUtils;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.pagecache.AdversarialPageCache;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.checking.AccessCheckingPageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.test.rule.ExternalResource;

public class PageCacheRule
extends ExternalResource {
    protected PageCache pageCache;
    final PageCacheConfig baseConfig;

    public static PageCacheConfig config() {
        return new PageCacheConfig();
    }

    public PageCacheRule() {
        this(PageCacheRule.config());
    }

    public PageCacheRule(PageCacheConfig config) {
        this.baseConfig = config;
    }

    public PageCache getPageCache(FileSystemAbstraction fs) {
        return this.getPageCache(fs, PageCacheRule.config());
    }

    public PageCache getPageCache(FileSystemAbstraction fs, PageCacheConfig overriddenConfig) {
        this.closeExistingPageCache();
        Integer pageSize = PageCacheRule.selectConfig(this.baseConfig.pageSize, overriddenConfig.pageSize, null);
        PageCacheTracer cacheTracer = PageCacheRule.selectConfig(this.baseConfig.tracer, overriddenConfig.tracer, PageCacheTracer.NULL);
        PageCursorTracerSupplier cursorTracerSupplier = (PageCursorTracerSupplier)PageCacheRule.selectConfig(this.baseConfig.pageCursorTracerSupplier, overriddenConfig.pageCursorTracerSupplier, DefaultPageCursorTracerSupplier.INSTANCE);
        SingleFilePageSwapperFactory factory = new SingleFilePageSwapperFactory();
        factory.open(fs, Configuration.EMPTY);
        MemoryAllocator mman = MemoryAllocator.createAllocator((String)"8 MiB");
        this.pageCache = pageSize != null ? new MuninnPageCache((PageSwapperFactory)factory, mman, pageSize.intValue(), cacheTracer, cursorTracerSupplier) : new MuninnPageCache((PageSwapperFactory)factory, mman, cacheTracer, cursorTracerSupplier);
        this.pageCachePostConstruct(overriddenConfig);
        return this.pageCache;
    }

    protected static <T> T selectConfig(T base, T overridden, T defaultValue) {
        return (T)ObjectUtils.firstNonNull((Object[])new Object[]{base, overridden, defaultValue});
    }

    protected void pageCachePostConstruct(PageCacheConfig overriddenConfig) {
        if (PageCacheRule.selectConfig(this.baseConfig.inconsistentReads, overriddenConfig.inconsistentReads, true).booleanValue()) {
            AtomicBoolean controller = PageCacheRule.selectConfig(this.baseConfig.nextReadIsInconsistent, overriddenConfig.nextReadIsInconsistent, null);
            Adversary adversary = controller != null ? new AtomicBooleanInconsistentReadAdversary(controller) : new RandomInconsistentReadAdversary();
            this.pageCache = new AdversarialPageCache(this.pageCache, adversary);
        }
        if (PageCacheRule.selectConfig(this.baseConfig.accessChecks, overriddenConfig.accessChecks, false).booleanValue()) {
            this.pageCache = new AccessCheckingPageCache(this.pageCache);
        }
    }

    protected void closeExistingPageCache() {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError("Failed to stop existing PageCache prior to creating a new one", e);
            }
        }
    }

    protected void after(boolean success) {
        if (this.pageCache != null) {
            try {
                this.pageCache.close();
            }
            catch (Exception e) {
                throw new AssertionError("Failed to stop PageCache after test", e);
            }
            this.pageCache = null;
        }
    }

    private static class RandomInconsistentReadAdversary
    implements Adversary {
        private RandomInconsistentReadAdversary() {
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return ThreadLocalRandom.current().nextBoolean();
        }
    }

    private static class AtomicBooleanInconsistentReadAdversary
    implements Adversary {
        final AtomicBoolean nextReadIsInconsistent;

        AtomicBooleanInconsistentReadAdversary(AtomicBoolean nextReadIsInconsistent) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
        }

        @Override
        @SafeVarargs
        public final void injectFailure(Class<? extends Throwable> ... failureTypes) {
        }

        @Override
        @SafeVarargs
        public final boolean injectFailureOrMischief(Class<? extends Throwable> ... failureTypes) {
            return this.nextReadIsInconsistent.getAndSet(false);
        }
    }

    public static final class PageCacheConfig {
        protected Boolean inconsistentReads;
        protected Integer pageSize;
        protected AtomicBoolean nextReadIsInconsistent;
        protected PageCacheTracer tracer;
        protected PageCursorTracerSupplier pageCursorTracerSupplier;
        private boolean accessChecks;

        private PageCacheConfig() {
        }

        public PageCacheConfig withInconsistentReads(boolean inconsistentReads) {
            this.inconsistentReads = inconsistentReads;
            return this;
        }

        public PageCacheConfig withInconsistentReads(AtomicBoolean nextReadIsInconsistent) {
            this.nextReadIsInconsistent = nextReadIsInconsistent;
            this.inconsistentReads = true;
            return this;
        }

        public PageCacheConfig withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PageCacheConfig withTracer(PageCacheTracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public PageCacheConfig withCursorTracerSupplier(PageCursorTracerSupplier tracerSupplier) {
            this.pageCursorTracerSupplier = tracerSupplier;
            return this;
        }

        public PageCacheConfig withAccessChecks(boolean accessChecks) {
            this.accessChecks = accessChecks;
            return this;
        }
    }
}

