/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;

public class LargePageListIT {
    @Test
    public void veryLargePageListsMustBeFullyAccessible() throws Exception {
        int pageSize = (int)ByteUnit.kibiBytes((long)8L);
        long pageCacheSize = ByteUnit.gibiBytes((long)513L) + (long)pageSize;
        int pages = Math.toIntExact(pageCacheSize / (long)pageSize);
        MemoryAllocator mman = MemoryAllocator.createAllocator((String)"2 GiB");
        SwapperSet swappers = new SwapperSet();
        long victimPage = VictimPageReference.getVictimPage((int)pageSize);
        PageList pageList = new PageList(pages, pageSize, mman, swappers, victimPage, 8L);
        Assert.assertThat((Object)pageList.getPageCount(), (Matcher)Matchers.is((Object)pages));
        IntStream.range(0, pages / 32).parallel().forEach(id -> this.verifyPageMetaDataIsAccessible(pageList, id * 32));
        IntStream.range(pages - 2000, pages).parallel().forEach(id -> this.verifyPageMetaDataIsAccessible(pageList, id));
    }

    private void verifyPageMetaDataIsAccessible(PageList pageList, int id) {
        long ref = pageList.deref(id);
        pageList.incrementUsage(ref);
        pageList.incrementUsage(ref);
        Assert.assertFalse((boolean)pageList.decrementUsage(ref));
        Assert.assertTrue((boolean)pageList.decrementUsage(ref));
        Assert.assertEquals((long)id, (long)pageList.toId(ref));
    }
}

