/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.test.matchers.ByteArrayMatcher;
import org.neo4j.test.rule.RepeatRule;

public abstract class PageCacheTestSupport<T extends PageCache> {
    protected static final long SHORT_TIMEOUT_MILLIS = 10000L;
    protected static final long SEMI_LONG_TIMEOUT_MILLIS = 120000L;
    protected static final long LONG_TIMEOUT_MILLIS = 360000L;
    protected static ExecutorService executor;
    public RepeatRule repeatRule = new RepeatRule();
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.repeatRule).around((TestRule)this.expectedException);
    protected int recordSize = 9;
    protected int maxPages = 20;
    protected int pageCachePageSize;
    protected int recordsPerFilePage;
    protected int recordCount;
    protected int filePageSize;
    protected ByteBuffer bufA;
    protected FileSystemAbstraction fs;
    protected T pageCache;
    private Fixture<T> fixture;

    @BeforeClass
    public static void startExecutor() {
        executor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void stopExecutor() {
        executor.shutdown();
    }

    protected abstract Fixture<T> createFixture();

    @Before
    public void setUp() throws IOException {
        this.fixture = this.createFixture();
        Thread.interrupted();
        this.fs = this.createFileSystemAbstraction();
        this.ensureExists(this.file("a"));
    }

    @After
    public void tearDown() throws Exception {
        Thread.interrupted();
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.fs.close();
    }

    protected final T createPageCache(PageSwapperFactory swapperFactory, int maxPages, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier) {
        T pageCache = this.fixture.createPageCache(swapperFactory, maxPages, tracer, cursorTracerSupplier);
        this.pageCachePageSize = pageCache.pageSize();
        this.recordsPerFilePage = this.pageCachePageSize / this.recordSize;
        this.recordCount = 5 * maxPages * this.recordsPerFilePage;
        this.filePageSize = this.recordsPerFilePage * this.recordSize;
        this.bufA = ByteBuffer.allocate(this.recordSize);
        return pageCache;
    }

    protected T createPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier) {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.open(fs, Configuration.EMPTY);
        return this.createPageCache((PageSwapperFactory)swapperFactory, maxPages, tracer, cursorTracerSupplier);
    }

    protected final T getPageCache(FileSystemAbstraction fs, int maxPages, PageCacheTracer tracer, PageCursorTracerSupplier cursorTracerSupplier) throws IOException {
        if (this.pageCache != null) {
            this.tearDownPageCache(this.pageCache);
        }
        this.pageCache = this.createPageCache(fs, maxPages, tracer, cursorTracerSupplier);
        return this.pageCache;
    }

    protected void configureStandardPageCache() throws IOException {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
    }

    protected final void tearDownPageCache(T pageCache) throws IOException {
        this.fixture.tearDownPageCache(pageCache);
    }

    protected final FileSystemAbstraction createFileSystemAbstraction() {
        return this.fixture.getFileSystemAbstraction();
    }

    protected final File file(String pathname) throws IOException {
        return this.fixture.file(pathname);
    }

    protected void ensureExists(File file) throws IOException {
        this.fs.mkdirs(file.getParentFile());
        this.fs.create(file).close();
    }

    protected File existingFile(String name) throws IOException {
        File file = this.file(name);
        this.ensureExists(file);
        return file;
    }

    protected void ensureDirectoryExists(File dir) throws IOException {
        this.fs.mkdir(dir);
    }

    protected File existingDirectory(String name) throws IOException {
        File dir = this.file(name);
        this.ensureDirectoryExists(dir);
        return dir;
    }

    protected void verifyRecordsMatchExpected(PageCursor cursor) throws IOException {
        ByteBuffer expectedPageContents = ByteBuffer.allocate(this.filePageSize);
        ByteBuffer actualPageContents = ByteBuffer.allocate(this.filePageSize);
        byte[] record = new byte[this.recordSize];
        long pageId = cursor.getCurrentPageId();
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = pageId * (long)this.recordsPerFilePage + (long)i;
            expectedPageContents.position(this.recordSize * i);
            PageCacheTestSupport.generateRecordForId(recordId, expectedPageContents.slice());
            do {
                cursor.setOffset(this.recordSize * i);
                cursor.getBytes(record);
            } while (cursor.shouldRetry());
            actualPageContents.position(this.recordSize * i);
            actualPageContents.put(record);
        }
        this.assertRecord(pageId, actualPageContents, expectedPageContents);
    }

    protected void assertRecord(long pageId, ByteBuffer actualPageContents, ByteBuffer expectedPageContents) {
        byte[] actualBytes = actualPageContents.array();
        byte[] expectedBytes = expectedPageContents.array();
        int estimatedPageId = this.estimateId(actualBytes);
        Assert.assertThat((String)("Page id: " + pageId + " (based on record data, it should have been " + estimatedPageId + ", a difference of " + Math.abs(pageId - (long)estimatedPageId) + ")"), (Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray((byte[])expectedBytes));
    }

    protected int estimateId(byte[] record) {
        return ByteBuffer.wrap(record).getInt() - 1;
    }

    protected void writeRecords(PageCursor cursor) {
        cursor.setOffset(0);
        for (int i = 0; i < this.recordsPerFilePage; ++i) {
            long recordId = cursor.getCurrentPageId() * (long)this.recordsPerFilePage + (long)i;
            PageCacheTestSupport.generateRecordForId(recordId, this.bufA);
            cursor.putBytes(this.bufA.array());
        }
    }

    protected void generateFileWithRecords(File file, int recordCount, int recordSize) throws IOException {
        try (StoreChannel channel = this.fs.open(file, OpenMode.READ_WRITE);){
            this.generateFileWithRecords((WritableByteChannel)channel, recordCount, recordSize);
        }
    }

    protected void generateFileWithRecords(WritableByteChannel channel, int recordCount, int recordSize) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            int rem = buf.remaining();
            while ((rem -= channel.write(buf)) > 0) {
            }
        }
    }

    protected static void generateRecordForId(long id, ByteBuffer buf) {
        buf.position(0);
        int x = (int)(id + 1L);
        buf.putInt(x);
        while (buf.position() < buf.limit()) {
            buf.put((byte)(++x & 0xFF));
        }
        buf.position(0);
    }

    protected void verifyRecordsInFile(File file, int recordCount) throws IOException {
        try (StoreChannel channel = this.fs.open(file, OpenMode.READ);){
            this.verifyRecordsInFile((ReadableByteChannel)channel, recordCount);
        }
    }

    protected void verifyRecordsInFile(ReadableByteChannel channel, int recordCount) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(this.recordSize);
        ByteBuffer observation = ByteBuffer.allocate(this.recordSize);
        for (int i = 0; i < recordCount; ++i) {
            PageCacheTestSupport.generateRecordForId(i, buf);
            observation.position(0);
            channel.read(observation);
            this.assertRecord(i, observation, buf);
        }
    }

    protected Runnable $close(PagedFile file) {
        return () -> {
            try {
                file.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static abstract class Fixture<T extends PageCache> {
        private Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier = EphemeralFileSystemAbstraction::new;
        private Function<String, File> fileConstructor = File::new;

        public abstract T createPageCache(PageSwapperFactory var1, int var2, PageCacheTracer var3, PageCursorTracerSupplier var4);

        public abstract void tearDownPageCache(T var1) throws IOException;

        public final FileSystemAbstraction getFileSystemAbstraction() {
            return this.fileSystemAbstractionSupplier.get();
        }

        public final Fixture<T> withFileSystemAbstraction(Supplier<FileSystemAbstraction> fileSystemAbstractionSupplier) {
            this.fileSystemAbstractionSupplier = fileSystemAbstractionSupplier;
            return this;
        }

        public final File file(String pathname) throws IOException {
            return this.fileConstructor.apply(pathname).getCanonicalFile();
        }

        public final Fixture<T> withFileConstructor(Function<String, File> fileConstructor) {
            this.fileConstructor = fileConstructor;
            return this;
        }
    }
}

