/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class MemoryAllocatorTest {
    protected static final String ONE_PAGE = "8192";
    protected static final String EIGHT_PAGES = "65536";

    protected MemoryAllocator createAllocator(String expectedMaxMemory) {
        return MemoryAllocator.createAllocator((String)expectedMaxMemory);
    }

    @Test
    public void allocatedPointerMustNotBeNull() throws Exception {
        MemoryAllocator mman = this.createAllocator(EIGHT_PAGES);
        long address = mman.allocateAligned(8192L, 8L);
        Assert.assertThat((Object)address, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    public void allocatedPointerMustBePageAligned() throws Exception {
        MemoryAllocator mman = this.createAllocator(EIGHT_PAGES);
        long address = mman.allocateAligned(8192L, (long)UnsafeUtil.pageSize());
        Assert.assertThat((Object)(address % (long)UnsafeUtil.pageSize()), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void mustBeAbleToAllocatePastMemoryLimit() throws Exception {
        MemoryAllocator mman = this.createAllocator(ONE_PAGE);
        for (int i = 0; i < 4100; ++i) {
            Assert.assertThat((Object)(mman.allocateAligned(1L, 2L) % 2L), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void alignmentCannotBeZero() throws Exception {
        this.createAllocator(ONE_PAGE).allocateAligned(8L, 0L);
    }

    @Test
    public void mustBeAbleToAllocateSlabsLargerThanGrabSize() throws Exception {
        MemoryAllocator mman = this.createAllocator("2 MiB");
        long page1 = mman.allocateAligned((long)UnsafeUtil.pageSize(), 1L);
        long largeBlock = mman.allocateAligned(0x100000L, 1L);
        long page2 = mman.allocateAligned((long)UnsafeUtil.pageSize(), 1L);
        Assert.assertThat((Object)page1, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertThat((Object)largeBlock, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertThat((Object)page2, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    public void allocatingMustIncreaseMemoryUsedAndDecreaseAvailableMemory() throws Exception {
        MemoryAllocator mman = this.createAllocator(ONE_PAGE);
        Assert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Object)8192L));
        mman.allocateAligned(32L, 1L);
        Assert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(32L))));
        Assert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8160L))));
        mman.allocateAligned(32L, 1L);
        Assert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(64L))));
        Assert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8128L))));
        mman.allocateAligned(1L, 1L);
        mman.allocateAligned(32L, 16L);
        Assert.assertThat((Object)mman.usedMemory(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(97L))));
        Assert.assertThat((Object)mman.availableMemory(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(8095L))));
    }
}

