/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstractionTest;

public class DefaultFileSystemAbstractionTest
extends FileSystemAbstractionTest {
    @Override
    protected FileSystemAbstraction buildFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    @Test
    public void shouldFailGracefullyWhenPathCannotBeCreated() throws Exception {
        this.path = new File(this.testDirectory.directory(), String.valueOf(UUID.randomUUID())){

            @Override
            public boolean mkdirs() {
                return false;
            }
        };
        try {
            this.fsa.mkdirs(this.path);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)this.fsa.fileExists(this.path));
            String expectedMessage = String.format("Unable to create directory path [%s] for Neo4j store.", this.path);
            Assert.assertThat((Object)e.getMessage(), (Matcher)Is.is((Object)expectedMessage));
        }
    }
}

