/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.ByteUnit;

public class ByteUnitTest {
    @Test
    public void convertZero() throws Exception {
        Assert.assertThat((Object)ByteUnit.Byte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.Byte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toKibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toMebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toGibiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toTebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toPebiBytes(0L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toExbiBytes(0L), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void convertOneToEIC() throws Exception {
        Assert.assertThat((Object)ByteUnit.KibiByte.toBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.KibiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toBytes(1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.MebiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toBytes(1L), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.GibiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toBytes(1L), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.TebiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toBytes(1L), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.PebiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toBytes(1L), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toKibiBytes(1L), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toMebiBytes(1L), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toGibiBytes(1L), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toTebiBytes(1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toPebiBytes(1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.ExbiByte.toExbiBytes(1L), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void unitsAsBytes() throws Exception {
        Assert.assertThat((Object)ByteUnit.bytes((long)1L), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.kibiBytes((long)1L), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.mebiBytes((long)1L), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.gibiBytes((long)1L), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.tebiBytes((long)1L), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.pebiBytes((long)1L), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.exbiBytes((long)1L), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1"), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 KiB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1KiB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Ki B"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 KB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1KB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    KB "), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 kB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1kB"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    kB "), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 kb"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1kb"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    kb "), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 k"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1k"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    k"), (Matcher)Matchers.is((Object)1024L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 MiB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1MiB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Mi B"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 MB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1MB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    MB "), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 mB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1mB"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    mB "), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 mb"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1mb"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    mb "), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 m"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1m"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    m"), (Matcher)Matchers.is((Object)0x100000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 GiB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1GiB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Gi B"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 GB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1GB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    GB "), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 gB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1gB"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    gB "), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 gb"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1gb"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    gb "), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 g"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1g"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    g"), (Matcher)Matchers.is((Object)0x40000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 TiB"), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1TiB"), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Ti B"), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 TB"), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1TB"), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    TB "), (Matcher)Matchers.is((Object)0x10000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 PiB"), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1PiB"), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Pi B"), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 PB"), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1PB"), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    PB "), (Matcher)Matchers.is((Object)0x4000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 EiB"), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1EiB"), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    Ei B"), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1 EB"), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)"1EB"), (Matcher)Matchers.is((Object)0x1000000000000000L));
        Assert.assertThat((Object)ByteUnit.parse((String)" 1    EB "), (Matcher)Matchers.is((Object)0x1000000000000000L));
    }

    @Test
    public void bytesToString() {
        Assert.assertEquals((Object)"1B", (Object)ByteUnit.bytesToString((long)1L));
        Assert.assertEquals((Object)"10B", (Object)ByteUnit.bytesToString((long)10L));
        Assert.assertEquals((Object)"1000B", (Object)ByteUnit.bytesToString((long)1000L));
        Assert.assertEquals((Object)"1.001KiB", (Object)ByteUnit.bytesToString((long)1025L));
        Assert.assertEquals((Object)"10.01KiB", (Object)ByteUnit.bytesToString((long)10250L));
        Assert.assertEquals((Object)"100.1KiB", (Object)ByteUnit.bytesToString((long)102500L));
        Assert.assertEquals((Object)"1001KiB", (Object)ByteUnit.bytesToString((long)1025000L));
        Assert.assertEquals((Object)"9.775MiB", (Object)ByteUnit.bytesToString((long)10250000L));
        Assert.assertEquals((Object)"97.75MiB", (Object)ByteUnit.bytesToString((long)102500000L));
        Assert.assertEquals((Object)"977.5MiB", (Object)ByteUnit.bytesToString((long)1025000000L));
        Assert.assertEquals((Object)"9.546GiB", (Object)ByteUnit.bytesToString((long)10250000000L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowWhenParsingInvalidUnit() throws Exception {
        ByteUnit.parse((String)"1 XB");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowWhenParsingUnitInterjectedWithNumber() throws Exception {
        ByteUnit.parse((String)"1K2i3B");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowWhenParsingNonNumbericTest() throws Exception {
        ByteUnit.parse((String)"abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowWhenParsingOnlyUnit() throws Exception {
        ByteUnit.parse((String)"MiB");
    }

    @Test(expected=IllegalArgumentException.class)
    public void mustThrowWhenParsingUnitBeforeValue() throws Exception {
        ByteUnit.parse((String)"MiB 1");
    }
}

