/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.WrappingFileHandle;

public class StreamFilesRecursive {
    private StreamFilesRecursive() {
    }

    public static Stream<FileHandle> streamFilesRecursive(File directory, FileSystemAbstraction fs) throws IOException {
        try {
            File canonicalizedDirectory = directory.getCanonicalFile();
            List snapshot = StreamFilesRecursive.streamFilesRecursiveInner(canonicalizedDirectory, fs).collect(Collectors.toList());
            return snapshot.stream().map(f -> new WrappingFileHandle((File)f, canonicalizedDirectory, fs));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static Stream<File> streamFilesRecursiveInner(File directory, FileSystemAbstraction fs) {
        File[] files = fs.listFiles(directory);
        if (files == null) {
            if (!fs.fileExists(directory)) {
                throw new UncheckedIOException(new NoSuchFileException(directory.getPath()));
            }
            return Stream.of(directory);
        }
        return Stream.of(files).flatMap(f -> fs.isDirectory((File)f) ? StreamFilesRecursive.streamFilesRecursiveInner(f, fs) : Stream.of(f));
    }
}

