/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.fs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.rules.ExternalResource;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public abstract class FileSystemRule<FS extends FileSystemAbstraction>
extends ExternalResource
implements FileSystemAbstraction,
Supplier<FileSystemAbstraction> {
    protected volatile FS fs;

    protected FileSystemRule(FS fs) {
        this.fs = fs;
    }

    protected void after() {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        super.after();
    }

    @Override
    public FS get() {
        return this.fs;
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public FileWatcher fileWatcher() throws IOException {
        return this.fs.fileWatcher();
    }

    public StoreChannel open(File fileName, String mode) throws IOException {
        return this.fs.open(fileName, mode);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return this.fs.openAsOutputStream(fileName, append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return this.fs.openAsInputStream(fileName);
    }

    public Reader openAsReader(File fileName, Charset charset) throws IOException {
        return this.fs.openAsReader(fileName, charset);
    }

    public Writer openAsWriter(File fileName, Charset charset, boolean append) throws IOException {
        return this.fs.openAsWriter(fileName, charset, append);
    }

    public StoreChannel create(File fileName) throws IOException {
        return this.fs.create(fileName);
    }

    public boolean fileExists(File fileName) {
        return this.fs.fileExists(fileName);
    }

    public boolean mkdir(File fileName) {
        return this.fs.mkdir(fileName);
    }

    public void mkdirs(File fileName) throws IOException {
        this.fs.mkdirs(fileName);
    }

    public long getFileSize(File fileName) {
        return this.fs.getFileSize(fileName);
    }

    public boolean deleteFile(File fileName) {
        return this.fs.deleteFile(fileName);
    }

    public void deleteRecursively(File directory) throws IOException {
        this.fs.deleteRecursively(directory);
    }

    public void renameFile(File from, File to, CopyOption ... copyOptions) throws IOException {
        this.fs.renameFile(from, to, copyOptions);
    }

    public File[] listFiles(File directory) {
        return this.fs.listFiles(directory);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        return this.fs.listFiles(directory, filter);
    }

    public boolean isDirectory(File file) {
        return this.fs.isDirectory(file);
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        this.fs.moveToDirectory(file, toDirectory);
    }

    public void copyFile(File from, File to) throws IOException {
        this.fs.copyFile(from, to);
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.fs.copyRecursively(fromDirectory, toDirectory);
    }

    public <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        return (K)this.fs.getOrCreateThirdPartyFileSystem(clazz, creator);
    }

    public void truncate(File path, long size) throws IOException {
        this.fs.truncate(path, size);
    }

    public long lastModifiedTime(File file) throws IOException {
        return this.fs.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(File file) throws IOException {
        this.fs.deleteFileOrThrow(file);
    }

    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return this.fs.streamFilesRecursive(directory);
    }

    public int hashCode() {
        return this.fs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fs.equals(obj);
    }

    public String toString() {
        return this.fs.toString();
    }
}

