/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.DaemonThreadFactory;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.StubPageFaultEvent;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

@RunWith(value=Parameterized.class)
public class PageListTest {
    private static final long TIMEOUT = 5000L;
    private static final int ALIGNMENT = 8;
    private static final int[] pageIds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final DummyPageSwapper DUMMY_SWAPPER = new DummyPageSwapper("", UnsafeUtil.pageSize());
    private static ExecutorService executor;
    private static MemoryManager mman;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final int pageId;
    private final int prevPageId;
    private final int nextPageId;
    private long pageRef;
    private long prevPageRef;
    private long nextPageRef;
    private final int pageSize;
    private SwapperSet swappers;
    private PageList pageList;

    /*
     * Exception decompiling
     */
    @Parameterized.Parameters(name="pageRef = {0}")
    public static Iterable<Object[]> parameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @BeforeClass
    public static void setUpStatics() {
        executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
        mman = new MemoryManager(ByteUnit.mebiBytes((long)1L), 8L);
    }

    @AfterClass
    public static void tearDownStatics() {
        mman = null;
        executor.shutdown();
        executor = null;
    }

    public PageListTest(int pageId) {
        this.pageId = pageId;
        this.prevPageId = pageId == 0 ? pageIds.length - 1 : (pageId - 1) % pageIds.length;
        this.nextPageId = (pageId + 1) % pageIds.length;
        this.pageSize = UnsafeUtil.pageSize();
    }

    @Before
    public void setUp() {
        this.swappers = new SwapperSet();
        this.pageList = new PageList(pageIds.length, this.pageSize, mman, this.swappers, VictimPageReference.getVictimPage((int)this.pageSize));
        this.pageRef = this.pageList.deref(this.pageId);
        this.prevPageRef = this.pageList.deref(this.prevPageId);
        this.nextPageRef = this.pageList.deref(this.nextPageId);
    }

    @Test
    public void mustExposePageCount() throws Exception {
        long victimPage = VictimPageReference.getVictimPage((int)this.pageSize);
        int pageCount = 3;
        Assert.assertThat((Object)new PageList(pageCount, this.pageSize, mman, this.swappers, victimPage).getPageCount(), (Matcher)Matchers.is((Object)pageCount));
        pageCount = 42;
        Assert.assertThat((Object)new PageList(pageCount, this.pageSize, mman, this.swappers, victimPage).getPageCount(), (Matcher)Matchers.is((Object)pageCount));
    }

    @Test
    public void mustBeAbleToReversePageRedToPageId() throws Exception {
        Assert.assertThat((Object)this.pageList.toId(this.pageRef), (Matcher)Matchers.is((Object)this.pageId));
    }

    @Test
    public void pagesAreInitiallyExclusivelyLocked() throws Exception {
        Assert.assertTrue((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test
    public void uncontendedOptimisticLockMustValidate() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long stamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, stamp));
    }

    @Test
    public void mustNotValidateRandomStamp() throws Exception {
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, 4242L));
    }

    @Test
    public void writeLockMustInvalidateOptimisticReadLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void takingWriteLockMustInvalidateOptimisticReadLock() throws Exception {
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustNotValidateUnderWriteLock() throws Exception {
        this.pageList.tryWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void writeLockReleaseMustInvalidateOptimisticReadLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void uncontendedWriteLockMustBeAvailable() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test
    public void uncontendedOptimisticReadLockMustValidateAfterWriteLockRelease() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test(timeout=5000L)
    public void writeLocksMustNotBlockOtherWriteLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test(timeout=5000L)
    public void writeLocksMustNotBlockOtherWriteLocksInOtherThreads() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int threads = 10;
        CountDownLatch end = new CountDownLatch(threads);
        Runnable runnable = () -> {
            Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
            end.countDown();
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(runnable));
        }
        end.await();
        for (Future future : futures) {
            future.get();
        }
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockWriteLockMustThrow() throws Exception {
        this.pageList.unlockWrite(this.pageRef);
    }

    @Test(expected=IllegalMonitorStateException.class, timeout=5000L)
    public void writeLockCountOverflowMustThrow() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        while (true) {
            Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        }
    }

    @Test
    public void exclusiveLockMustInvalidateOptimisticLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void takingExclusiveLockMustInvalidateOptimisticLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustNotValidateUnderExclusiveLock() throws Exception {
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void exclusiveLockReleaseMustInvalidateOptimisticReadLock() throws Exception {
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void uncontendedOptimisticReadLockMustValidateAfterExclusiveLockRelease() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void canTakeUncontendedExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void writeLocksMustFailExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void concurrentWriteLocksMustFailExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void exclusiveLockMustBeAvailableAfterWriteLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void cannotTakeExclusiveLockIfAlreadyTaken() throws Exception {
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void exclusiveLockMustBeAvailableAfterExclusiveLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test(timeout=5000L)
    public void exclusiveLockMustFailWriteLocks() throws Exception {
        Assert.assertFalse((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockExclusiveLockMustThrow() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockWriteAfterTakingExclusiveLockMustThrow() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
    }

    @Test(timeout=5000L)
    public void writeLockMustBeAvailableAfterExclusiveLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
    }

    @Test
    public void unlockExclusiveMustReturnStampForOptimisticReadLock() throws Exception {
        long r = this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustInvalidateOptimisticReadLocks() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustPreventExclusiveLocks() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test(timeout=5000L)
    public void unlockExclusiveAndTakeWriteLockMustAllowConcurrentWriteLocks() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test(timeout=5000L)
    public void unlockExclusiveAndTakeWriteLockMustBeAtomic() throws Exception {
        int threads = Runtime.getRuntime().availableProcessors() - 1;
        CountDownLatch start = new CountDownLatch(threads);
        AtomicBoolean stop = new AtomicBoolean();
        this.pageList.tryExclusiveLock(this.pageRef);
        Runnable runnable = () -> {
            while (!stop.get()) {
                if (this.pageList.tryExclusiveLock(this.pageRef)) {
                    this.pageList.unlockExclusive(this.pageRef);
                    throw new RuntimeException("I should not have gotten that lock");
                }
                start.countDown();
            }
        };
        ArrayList futures = new ArrayList();
        for (int i = 0; i < threads; ++i) {
            futures.add(executor.submit(runnable));
        }
        start.await();
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        stop.set(true);
        for (Future future : futures) {
            future.get();
        }
    }

    @Test
    public void stampFromUnlockExclusiveMustNotBeValidIfThereAreWriteLocks() throws Exception {
        long r = this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void uncontendedFlushLockMustBeAvailable() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void flushLockMustNotInvalidateOptimisticReadLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void flushLockMustNotFailWriteLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test
    public void flushLockMustFailExclusiveLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void cannotTakeFlushLockIfAlreadyTaken() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
        Assert.assertFalse((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void writeLockMustNotFailFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void exclusiveLockMustFailFlushLock() throws Exception {
        Assert.assertFalse((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void unlockExclusiveAndTakeWriteLockMustNotFailFlushLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void flushUnlockMustNotInvalidateOptimisticReadLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustValidateUnderFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void flushLockReleaseMustNotInvalidateOptimisticReadLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unmatchedUnlockFlushMustThrow() throws Exception {
        this.pageList.unlockFlush(this.pageRef, this.pageList.tryOptimisticReadLock(this.pageRef), true);
    }

    @Test
    public void uncontendedOptimisticReadLockMustBeAvailableAfterFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void uncontendedWriteLockMustBeAvailableAfterFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
    }

    @Test
    public void uncontendedExclusiveLockMustBeAvailableAfterFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterWriteLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterExclusiveLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryExclusiveLock(this.pageRef);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void uncontendedFlushLockMustBeAvailableAfterFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((this.pageList.tryFlushLock(this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @Test
    public void stampFromUnlockExclusiveMustBeValidUnderFlushLock() throws Exception {
        long r = this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentWriteLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        long r = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, r));
    }

    @Test
    public void writeLockMustNotGetInterferenceFromAdjacentExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
    }

    @Test
    public void flushLockMustNotGetInterferenceFromAdjacentExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        long s = 0L;
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        s = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((s != 0L ? 1 : 0) != 0);
        this.pageList.unlockFlush(this.pageRef, s, true);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
    }

    @Test
    public void flushLockMustNotGetInterferenceFromAdjacentFlushLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        long ps = 0L;
        long ns = 0L;
        long s = 0L;
        ps = this.pageList.tryFlushLock(this.prevPageRef);
        Assert.assertTrue((ps != 0L ? 1 : 0) != 0);
        ns = this.pageList.tryFlushLock(this.nextPageRef);
        Assert.assertTrue((ns != 0L ? 1 : 0) != 0);
        s = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((s != 0L ? 1 : 0) != 0);
        this.pageList.unlockFlush(this.pageRef, s, true);
        this.pageList.unlockFlush(this.prevPageRef, ps, true);
        this.pageList.unlockFlush(this.nextPageRef, ns, true);
    }

    @Test
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void exclusiveLockMustNotGetInterferenceFromAdjacentWriteLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
    }

    @Test
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.nextPageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.prevPageRef);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.nextPageRef);
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test
    public void exclusiveLockMustNotGetInterferenceFromAdjacentFlushLocks() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        long ps = 0L;
        long ns = 0L;
        ps = this.pageList.tryFlushLock(this.prevPageRef);
        Assert.assertTrue((ps != 0L ? 1 : 0) != 0);
        ns = this.pageList.tryFlushLock(this.nextPageRef);
        Assert.assertTrue((ns != 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockFlush(this.prevPageRef, ps, true);
        this.pageList.unlockFlush(this.nextPageRef, ns, true);
    }

    @Test
    public void takingWriteLockMustRaiseModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
    }

    @Test
    public void turningExclusiveLockIntoWriteLockMustRaiseModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
    }

    @Test
    public void releasingFlushLockMustLowerModifiedFlagIfSuccessful() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void loweredModifiedFlagMustRemainLoweredAfterReleasingFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotLowerModifiedFlagIfUnsuccessful() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, false);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockWasWithinFlushFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedTakingFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedReleasingFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long s = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void releasingFlushLockMustNotInterfereWithAdjacentModifiedFlags() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.nextPageRef));
        this.pageList.unlockWrite(this.prevPageRef);
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockWrite(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.nextPageRef));
        long s = this.pageList.tryFlushLock(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, s, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.prevPageRef));
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.nextPageRef));
    }

    @Test
    public void writeLockMustNotInterfereWithAdjacentModifiedFlags() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.isModified(this.nextPageRef));
    }

    @Test(expected=IllegalStateException.class)
    public void disallowUnlockedPageToExplicitlyLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
    }

    @Test(expected=IllegalStateException.class)
    public void disallowReadLockedPageToExplicitlyLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryOptimisticReadLock(this.pageRef);
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
    }

    @Test(expected=IllegalStateException.class)
    public void disallowFlushLockedPageToExplicitlyLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
    }

    @Test(expected=IllegalStateException.class)
    public void disallowWriteLockedPageToExplicitlyLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
    }

    @Test
    public void allowExclusiveLockedPageToExplicitlyLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustTakeFlushLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)flushStamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Object)0L));
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLocked() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
    }

    @Test(expected=IllegalMonitorStateException.class)
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLockedButExclusiveLocked() throws Exception {
        this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustFailIfFlushLockIsAlreadyTaken() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertThat((Object)stamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        long secondStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)secondStamp, (Matcher)Matchers.is((Object)0L));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockEvenIfFlushLockFails() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long flushStamp = this.pageList.tryFlushLock(this.pageRef);
        Assert.assertThat((Object)flushStamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertThat((Object)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef), (Matcher)Matchers.is((Object)0L));
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockWhenFlushLockSucceeds() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertThat((Object)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @Test
    public void unlockWriteAndTrueTakeFlushLockMustRaiseModifiedFlag() throws Exception {
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertThat((Object)this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustLowerModifiedFlagIfSuccessful() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustNotLowerModifiedFlagIfFailed() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockWithOverlappingWriterAndThenUnlockFlushMustNotLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)stamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithOverlappingWriterMustNotLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)stamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithContainedWriterMustNotLowerModifiedFlag() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)stamp, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryWriteLock(this.pageRef));
        this.pageList.unlockWrite(this.pageRef);
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingExclusiveLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingExclusiveLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingFlushLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Object)0L));
        this.pageList.unlockFlush(this.pageRef, stamp, true);
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingFlushLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long stamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Object)0L));
        this.pageList.unlockFlush(this.pageRef, stamp, false);
        Assert.assertThat((Object)this.pageList.tryFlushLock(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustNotInvalidateReadersOverlappingWithFlushLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @Test
    public void unlockWriteAndTryTakeFlushLockMustInvalidateReadersOverlappingWithWriteLock() throws Exception {
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        long readStamp = this.pageList.tryOptimisticReadLock(this.pageRef);
        long flushStamp = this.pageList.unlockWriteAndTryTakeFlushLock(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
        this.pageList.unlockFlush(this.pageRef, flushStamp, true);
        Assert.assertFalse((boolean)this.pageList.validateReadLock(this.pageRef, readStamp));
    }

    @Test
    public void mustExposeCachePageSize() throws Exception {
        PageList list = new PageList(0, 42, mman, this.swappers, VictimPageReference.getVictimPage((int)42));
        Assert.assertThat((Object)list.getCachePageSize(), (Matcher)Matchers.is((Object)42));
    }

    @Test
    public void addressesMustBeZeroBeforeInitialisation() throws Exception {
        Assert.assertThat((Object)this.pageList.getAddress(this.pageRef), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void initialisingBufferMustConsumeMemoryFromMemoryManager() throws Exception {
        long initialUsedMemory = mman.sumUsedMemory();
        this.pageList.initBuffer(this.pageRef);
        long resultingUsedMemory = mman.sumUsedMemory();
        int allocatedMemory = (int)(resultingUsedMemory - initialUsedMemory);
        Assert.assertThat((Object)allocatedMemory, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(this.pageSize)));
        Assert.assertThat((Object)allocatedMemory, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(this.pageSize + 8)));
    }

    @Test
    public void addressMustNotBeZeroAfterInitialisation() throws Exception {
        this.pageList.initBuffer(this.pageRef);
        Assert.assertThat((Object)this.pageList.getAddress(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void pageListMustBeCopyableViaConstructor() throws Exception {
        Assert.assertThat((Object)this.pageList.getAddress(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        PageList pl = new PageList(this.pageList);
        Assert.assertThat((Object)pl.getAddress(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        this.pageList.initBuffer(this.pageRef);
        Assert.assertThat((Object)this.pageList.getAddress(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0L))));
        Assert.assertThat((Object)pl.getAddress(this.pageRef), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0L))));
    }

    @Test
    public void usageCounterMustBeZeroByDefault() throws Exception {
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @Test
    public void usageCounterMustGoUpToFour() throws Exception {
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @Test
    public void usageCounterMustTruncateAtFour() throws Exception {
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @Test
    public void incrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters() throws Exception {
        this.pageList.incrementUsage(this.pageRef);
        this.pageList.incrementUsage(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.prevPageRef));
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.nextPageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
    }

    @Test
    public void decrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters() throws Exception {
        for (int id : pageIds) {
            long ref = this.pageList.deref(id);
            this.pageList.incrementUsage(ref);
            this.pageList.incrementUsage(ref);
        }
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.decrementUsage(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.prevPageRef));
        Assert.assertFalse((boolean)this.pageList.decrementUsage(this.nextPageRef));
    }

    @Test
    public void filePageIdIsUnboundByDefault() throws Exception {
        Assert.assertThat((Object)this.pageList.getFilePageId(this.pageRef), (Matcher)Matchers.is((Object)-1L));
    }

    @Test
    public void faultMustThrowWithoutExclusiveLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.initBuffer(this.pageRef);
        this.exception.expect(IllegalStateException.class);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, 0, 0L, PageFaultEvent.NULL);
    }

    @Test
    public void faultMustThrowIfSwapperIsNull() throws Exception {
        this.pageList.initBuffer(this.pageRef);
        this.exception.expect(IllegalArgumentException.class);
        this.pageList.fault(this.pageRef, null, 0, 0L, PageFaultEvent.NULL);
    }

    @Test
    public void faultMustThrowIfFilePageIdIsUnbound() throws Exception {
        this.pageList.initBuffer(this.pageRef);
        this.exception.expect(IllegalStateException.class);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, 0, -1L, PageFaultEvent.NULL);
    }

    @Test
    public void faultMustReadIntoPage() throws Exception {
        final byte pageByteContents = -9;
        int swapperId = 1;
        final long filePageId = 2L;
        DummyPageSwapper swapper = new DummyPageSwapper("some file", this.pageSize){

            @Override
            public long read(long fpId, long bufferAddress, int bufferSize) throws IOException {
                if (fpId == filePageId) {
                    UnsafeUtil.setMemory((long)bufferAddress, (long)bufferSize, (byte)pageByteContents);
                    return bufferSize;
                }
                throw new IOException("Did not expect this file page id = " + fpId);
            }
        };
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, PageFaultEvent.NULL);
        long address = this.pageList.getAddress(this.pageRef);
        Assert.assertThat((Object)address, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0L)));
        for (int i = 0; i < this.pageSize; ++i) {
            byte actualByteContents = UnsafeUtil.getByte((long)(address + (long)i));
            if (actualByteContents == pageByteContents) continue;
            Assert.fail((String)String.format("Page contents where different at address %x + %s, expected %x but was %x", address, i, pageByteContents, actualByteContents));
        }
    }

    @Test
    public void pageMustBeLoadedAndBoundAfterFault() throws Exception {
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
        Assert.assertThat((Object)this.pageList.getFilePageId(this.pageRef), (Matcher)Matchers.is((Object)filePageId));
        Assert.assertThat((Object)this.pageList.getSwapperId(this.pageRef), (Matcher)Matchers.is((Object)swapperId));
        Assert.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
    }

    @Test
    public void pageMustBeLoadedAndNotBoundIfFaultThrows() throws Exception {
        DummyPageSwapper swapper = new DummyPageSwapper("file", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
                throw new IOException("boo");
            }
        };
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        try {
            this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, PageFaultEvent.NULL);
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        }
        Assert.assertThat((Object)this.pageList.getFilePageId(this.pageRef), (Matcher)Matchers.is((Object)filePageId));
        Assert.assertThat((Object)this.pageList.getSwapperId(this.pageRef), (Matcher)Matchers.is((Object)0));
        Assert.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, filePageId));
    }

    @Test
    public void faultMustThrowIfPageIsAlreadyBound() throws Exception {
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
        this.exception.expect(IllegalStateException.class);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
    }

    @Test
    public void faultMustThrowIfPageIsLoadedButNotBound() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = 1;
        long filePageId = 42L;
        this.doFailedFault(swapperId, filePageId);
        this.exception.expect(IllegalStateException.class);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
    }

    private void doFailedFault(int swapperId, long filePageId) {
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
                throw new IOException("boom");
            }
        };
        try {
            this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, PageFaultEvent.NULL);
            Assert.fail((String)"fault should have thrown");
        }
        catch (IOException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"boom"));
        }
    }

    @Test
    public void faultMustPopulatePageFaultEvent() throws Exception {
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
                return 333L;
            }
        };
        StubPageFaultEvent event = new StubPageFaultEvent();
        this.pageList.fault(this.pageRef, (PageSwapper)swapper, swapperId, filePageId, (PageFaultEvent)event);
        Assert.assertThat((Object)event.bytesRead, (Matcher)Matchers.is((Object)333L));
        Assert.assertThat((Object)event.cachePageId, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0)));
    }

    @Test
    public void unboundPageMustNotBeLoaded() throws Exception {
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
    }

    @Test
    public void unboundPageMustNotBeBoundToAnything() throws Exception {
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 0, 0L));
    }

    @Test
    public void boundPagesAreNotBoundToOtherPagesWithSameSwapper() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        long filePageId = 42L;
        this.doFault(2, filePageId);
        Assert.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, 2, filePageId));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 2, filePageId + 1L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 2, filePageId - 1L));
    }

    private void doFault(int swapperId, long filePageId) throws IOException {
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        this.pageList.initBuffer(this.pageRef);
        this.pageList.fault(this.pageRef, (PageSwapper)DUMMY_SWAPPER, swapperId, filePageId, PageFaultEvent.NULL);
    }

    @Test
    public void boundPagesAreNotBoundToOtherPagesWithSameFilePageId() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = 2;
        this.doFault(swapperId, 42L);
        Assert.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId + 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, swapperId - 1, 42L));
    }

    @Test
    public void faultMustNotInterfereWithAdjacentPages() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.doFault(1, 42L);
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.prevPageRef));
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.nextPageRef));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 0, 0L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 0, 0L));
    }

    @Test
    public void failedFaultMustNotInterfereWithAdjacentPages() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.doFailedFault(1, 42L);
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.prevPageRef));
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.nextPageRef));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.prevPageRef, 0, 0L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.nextPageRef, 0, 0L));
    }

    @Test
    public void exclusiveLockMustStillBeHeldAfterFault() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.doFault(1, 42L);
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test
    public void tryEvictMustFailIfPageIsAlreadyExclusivelyLocked() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        Assert.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @Test
    public void tryEvictThatFailsOnExclusiveLockMustNotUndoSaidLock() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        Assert.assertTrue((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
    }

    @Test
    public void tryEvictMustFailIfPageIsNotLoaded() throws Exception {
        Assert.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @Test
    public void tryEvictMustWhenPageIsNotLoadedMustNotLeavePageLocked() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        Assert.assertFalse((boolean)this.pageList.isExclusivelyLocked(this.pageRef));
    }

    @Test
    public void tryEvictMustLeavePageExclusivelyLockedOnSuccess() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        this.pageList.unlockExclusive(this.pageRef);
    }

    @Test
    public void pageMustNotBeLoadedAfterSuccessfulEviction() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
    }

    @Test
    public void pageMustNotBeBoundAfterSuccessfulEviction() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, 1, 42L));
        Assert.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        Assert.assertThat((Object)this.pageList.getSwapperId(this.pageRef), (Matcher)Matchers.is((Object)1));
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        Assert.assertFalse((boolean)this.pageList.isBoundTo(this.pageRef, 1, 42L));
        Assert.assertFalse((boolean)this.pageList.isLoaded(this.pageRef));
        Assert.assertThat((Object)this.pageList.getSwapperId(this.pageRef), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void pageMustNotBeModifiedAfterSuccessfulEviction() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void tryEvictMustFlushPageIfModified() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicLong writtenFilePageId = new AtomicLong(-1L);
        final AtomicLong writtenBufferAddress = new AtomicLong(-1L);
        DummyPageSwapper swapper = new DummyPageSwapper("file", this.pageSize){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                Assert.assertTrue((boolean)writtenFilePageId.compareAndSet(-1L, filePageId));
                Assert.assertTrue((boolean)writtenBufferAddress.compareAndSet(-1L, bufferAddress));
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertThat((Object)writtenFilePageId.get(), (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)writtenBufferAddress.get(), (Matcher)Matchers.is((Object)this.pageList.getAddress(this.pageRef)));
    }

    @Test
    public void tryEvictMustNotFlushPageIfNotModified() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicInteger writes = new AtomicInteger();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                writes.getAndIncrement();
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertThat((Object)writes.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void tryEvictMustNotifySwapperOnSuccess() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
                Assert.assertThat((Object)filePageId, (Matcher)Matchers.is((Object)42L));
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertTrue((boolean)evictionNotified.get());
    }

    @Test
    public void tryEvictMustNotifySwapperOnSuccessEvenWhenFlushing() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
                Assert.assertThat((Object)filePageId, (Matcher)Matchers.is((Object)42L));
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertTrue((boolean)evictionNotified.get());
        Assert.assertFalse((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void tryEvictMustLeavePageUnlockedAndLoadedAndBoundAndModifiedIfFlushThrows() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            Assert.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.pageList.tryExclusiveLock(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isLoaded(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.isBoundTo(this.pageRef, swapperId, 42L));
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
    }

    @Test
    public void tryEvictMustNotNotifySwapperOfEvictionIfFlushThrows() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }

            @Override
            public void evicted(long filePageId) {
                evictionNotified.set(true);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            Assert.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)evictionNotified.get());
    }

    @Test
    public void tryEvictMustReportToEvictionEvent() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, () -> recorder));
        Assert.assertThat((Object)recorder.evictionClosed, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)recorder.filePageId, (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)recorder.swapper, (Matcher)Matchers.sameInstance((Object)swapper));
        Assert.assertThat((Object)recorder.evictionException, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)recorder.cachePageId, (Matcher)Matchers.is((Object)this.pageRef));
        Assert.assertThat((Object)recorder.bytesWritten, (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)recorder.flushDone, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)recorder.flushException, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)recorder.pagesFlushed, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void tryEvictThatFlushesMustReportToEvictionAndFlushEvents() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        int filePageSize = 313;
        DummyPageSwapper swapper = new DummyPageSwapper("a", filePageSize);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, () -> recorder));
        Assert.assertThat((Object)recorder.evictionClosed, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)recorder.filePageId, (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)recorder.swapper, (Matcher)Matchers.sameInstance((Object)swapper));
        Assert.assertThat((Object)recorder.evictionException, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)recorder.cachePageId, (Matcher)Matchers.is((Object)this.pageRef));
        Assert.assertThat((Object)recorder.bytesWritten, (Matcher)Matchers.is((Object)filePageSize));
        Assert.assertThat((Object)recorder.flushDone, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)recorder.flushException, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)recorder.pagesFlushed, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void tryEvictThatFailsMustReportExceptionsToEvictionAndFlushEvents() throws Exception {
        this.pageList.unlockExclusive(this.pageRef);
        final IOException ioException = new IOException();
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw ioException;
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        EvictionAndFlushRecorder recorder = new EvictionAndFlushRecorder();
        try {
            this.pageList.tryEvict(this.pageRef, () -> recorder);
            Assert.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertThat((Object)recorder.evictionClosed, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)recorder.filePageId, (Matcher)Matchers.is((Object)42L));
        Assert.assertThat((Object)recorder.swapper, (Matcher)Matchers.sameInstance((Object)swapper));
        Assert.assertThat((Object)recorder.evictionException, (Matcher)Matchers.sameInstance((Object)ioException));
        Assert.assertThat((Object)recorder.cachePageId, (Matcher)Matchers.is((Object)this.pageRef));
        Assert.assertThat((Object)recorder.bytesWritten, (Matcher)Matchers.is((Object)0L));
        Assert.assertThat((Object)recorder.flushDone, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)recorder.flushException, (Matcher)Matchers.sameInstance((Object)ioException));
        Assert.assertThat((Object)recorder.pagesFlushed, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void tryEvictThatSucceedsMustNotInterfereWithAdjacentPages() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusive(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    @Test
    public void tryEvictThatFlushesAndSucceedsMustNotInterfereWithAdjacentPages() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        Assert.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    @Test
    public void tryEvictThatFailsMustNotInterfereWithAdjacentPages() throws Exception {
        this.pageList.unlockExclusive(this.prevPageRef);
        this.pageList.unlockExclusive(this.pageRef);
        this.pageList.unlockExclusive(this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = this.pageList.tryOptimisticReadLock(this.prevPageRef);
        long nextStamp = this.pageList.tryOptimisticReadLock(this.nextPageRef);
        this.doFault(swapperId, 42L);
        this.pageList.unlockExclusiveAndTakeWriteLock(this.pageRef);
        this.pageList.unlockWrite(this.pageRef);
        Assert.assertTrue((boolean)this.pageList.isModified(this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            Assert.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.prevPageRef, prevStamp));
        Assert.assertTrue((boolean)this.pageList.validateReadLock(this.nextPageRef, nextStamp));
    }

    private static /* synthetic */ Iterator lambda$parameters$1(IntFunction toArray) {
        return Arrays.stream(pageIds).mapToObj(toArray).iterator();
    }

    private static class EvictionAndFlushRecorder
    implements EvictionEvent,
    FlushEventOpportunity,
    FlushEvent {
        private long filePageId;
        private PageSwapper swapper;
        private IOException evictionException;
        private long cachePageId;
        private boolean evictionClosed;
        private long bytesWritten;
        private boolean flushDone;
        private IOException flushException;
        private int pagesFlushed;

        private EvictionAndFlushRecorder() {
        }

        public void close() {
            this.evictionClosed = true;
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return this;
        }

        public void threwException(IOException exception) {
            this.evictionException = exception;
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public FlushEvent beginFlush(long filePageId, long cachePageId, PageSwapper swapper) {
            return this;
        }

        public void addBytesWritten(long bytes) {
            this.bytesWritten += bytes;
        }

        public void done() {
            this.flushDone = true;
        }

        public void done(IOException exception) {
            this.flushDone = true;
            this.flushException = exception;
        }

        public void addPagesFlushed(int pageCount) {
            this.pagesFlushed += pageCount;
        }
    }
}

