/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.test.ThreadTestUtils;

public class LatchMapTest {
    LatchMap latches = new LatchMap();

    @Test
    public void takeOrAwaitLatchMustReturnLatchIfAvailable() throws Exception {
        LatchMap.Latch latch = this.latches.takeOrAwaitLatch(0L);
        Assert.assertThat((Object)latch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        latch.release();
    }

    @Test
    public void takeOrAwaitLatchMustAwaitExistingLatchAndReturnNull() throws Exception {
        Thread th;
        AtomicReference threadRef = new AtomicReference();
        LatchMap.Latch latch = this.latches.takeOrAwaitLatch(42L);
        Assert.assertThat((Object)latch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<BinaryLatch> future = executor.submit(() -> {
            threadRef.set(Thread.currentThread());
            return this.latches.takeOrAwaitLatch(42L);
        });
        while ((th = (Thread)threadRef.get()) == null) {
        }
        ThreadTestUtils.awaitThreadState(th, 10000L, Thread.State.WAITING, new Thread.State[0]);
        latch.release();
        Assert.assertThat((Object)future.get(1L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void takeOrAwaitLatchMustNotLetUnrelatedLatchesConflictTooMuch() throws Exception {
        LatchMap.Latch latch = this.latches.takeOrAwaitLatch(42L);
        Assert.assertThat((Object)latch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<BinaryLatch> future = executor.submit(() -> this.latches.takeOrAwaitLatch(33L));
        Assert.assertThat((Object)future.get(1L, TimeUnit.SECONDS), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        latch.release();
    }

    @Test
    public void latchMustBeAvailableAfterRelease() throws Exception {
        this.latches.takeOrAwaitLatch(42L).release();
        this.latches.takeOrAwaitLatch(42L).release();
    }
}

