/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.adversaries;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.adversaries.RandomAdversary;
import sun.misc.Signal;

public final class AdversarySignals {
    private static final AdversarySignals instance = new AdversarySignals();
    private boolean installed = false;
    private List<Runnable> installedHandlers = new ArrayList<Runnable>();

    private AdversarySignals() {
    }

    public static AdversarySignals getInstance() {
        return instance;
    }

    public synchronized void installAsSIGUSR2() {
        if (!this.installed) {
            Signal.handle(new Signal("USR2"), sig -> this.handleSignal());
            this.installed = true;
        }
    }

    private synchronized void handleSignal() {
        for (Runnable handler : this.installedHandlers) {
            handler.run();
        }
    }

    public synchronized void setFactorWhenSignalled(RandomAdversary adversary, double factor) {
        this.installedHandlers.add(() -> adversary.setProbabilityFactor(factor));
    }

    public synchronized void setAndResetFactorWhenSignalled(RandomAdversary adversary, double factor) {
        this.installedHandlers.add(() -> adversary.setAndResetProbabilityFactor(factor));
    }
}

