/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule.fs;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;

public class EphemeralFileSystemRule
extends ExternalResource
implements Supplier<FileSystemAbstraction> {
    private EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();

    protected void after() {
        try {
            this.fs.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final EphemeralFileSystemAbstraction get() {
        return this.fs;
    }

    public EphemeralFileSystemAbstraction snapshot(Runnable action) throws Exception {
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot();
        try {
            action.run();
        }
        finally {
            this.fs.close();
            this.fs = snapshot;
        }
        return this.fs;
    }

    public void clear() throws Exception {
        this.fs.close();
        this.fs = new EphemeralFileSystemAbstraction();
    }

    public int hashCode() {
        return this.fs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fs.equals(obj);
    }

    public void crash() {
        this.fs.crash();
    }

    public String toString() {
        return this.fs.toString();
    }

    public EphemeralFileSystemAbstraction snapshot() {
        return this.fs.snapshot();
    }

    public void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to) throws IOException {
        this.fs.copyRecursivelyFromOtherFs(from, fromFs, to);
    }

    public long checksum() {
        return this.fs.checksum();
    }
}

