/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.hamcrest.Matcher;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;

public class RecordingPageCacheTracer
implements PageCacheTracer {
    private final Set<Class<? extends Event>> eventTypesToTrace = new HashSet<Class<? extends Event>>();
    private final BlockingQueue<Event> record = new LinkedBlockingQueue<Event>();
    private CountDownLatch trapLatch;
    private Matcher<? extends Event> trap;

    public RecordingPageCacheTracer() {
        this(Evict.class, Fault.class);
    }

    @SafeVarargs
    public RecordingPageCacheTracer(Class<? extends Event> ... eventTypesToTrace) {
        Collections.addAll(this.eventTypesToTrace, eventTypesToTrace);
    }

    private void pageFaulted(long filePageId, PageSwapper swapper) {
        this.record(new Fault(swapper, filePageId));
    }

    private void evicted(long filePageId, PageSwapper swapper) {
        this.record(new Evict(swapper, filePageId));
    }

    private void pinned(long filePageId, PageSwapper swapper) {
        this.record(new Pin(swapper, filePageId));
    }

    private void record(Event event) {
        if (this.eventTypesToTrace.contains(event.getClass())) {
            this.record.add(event);
            this.trip(event);
        }
    }

    public void mappedFile(File file) {
    }

    public void unmappedFile(File file) {
    }

    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return new EvictionRunEvent(){

            public EvictionEvent beginEviction() {
                return new RecordingEvictionEvent();
            }

            public void close() {
            }
        };
    }

    public PinEvent beginPin(boolean writeLock, final long filePageId, final PageSwapper swapper) {
        return new PinEvent(){

            public void setCachePageId(int cachePageId) {
            }

            public PageFaultEvent beginPageFault() {
                return new PageFaultEvent(){

                    public void addBytesRead(long bytes) {
                    }

                    public void done() {
                        RecordingPageCacheTracer.this.pageFaulted(filePageId, swapper);
                    }

                    public void done(Throwable throwable) {
                    }

                    public EvictionEvent beginEviction() {
                        return new RecordingEvictionEvent();
                    }

                    public void setCachePageId(int cachePageId) {
                    }
                };
            }

            public void done() {
                RecordingPageCacheTracer.this.pinned(filePageId, swapper);
            }
        };
    }

    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return MajorFlushEvent.NULL;
    }

    public MajorFlushEvent beginCacheFlush() {
        return MajorFlushEvent.NULL;
    }

    public long faults() {
        return 0L;
    }

    public long evictions() {
        return 0L;
    }

    public long pins() {
        return 0L;
    }

    public long unpins() {
        return 0L;
    }

    public long flushes() {
        return 0L;
    }

    public long bytesRead() {
        return 0L;
    }

    public long bytesWritten() {
        return 0L;
    }

    public long filesMapped() {
        return 0L;
    }

    public long filesUnmapped() {
        return 0L;
    }

    public long evictionExceptions() {
        return 0L;
    }

    public <T extends Event> T observe(Class<T> type) throws InterruptedException {
        return (T)((Event)type.cast(this.record.take()));
    }

    public <T extends Event> T tryObserve(Class<T> type) {
        return (T)((Event)type.cast(this.record.poll()));
    }

    public synchronized CountDownLatch trap(Matcher<? extends Event> trap) {
        assert (trap != null);
        this.trapLatch = new CountDownLatch(1);
        this.trap = trap;
        return this.trapLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trip(Event event) {
        CountDownLatch theTrapLatch;
        Matcher<? extends Event> theTrap;
        RecordingPageCacheTracer recordingPageCacheTracer = this;
        synchronized (recordingPageCacheTracer) {
            theTrap = this.trap;
            theTrapLatch = this.trapLatch;
        }
        if (theTrap != null && theTrap.matches((Object)event)) {
            try {
                theTrapLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Unexpected interrupt in RecordingMonitor", e);
            }
        }
    }

    private class RecordingEvictionEvent
    implements EvictionEvent {
        private long filePageId;
        private PageSwapper swapper;

        private RecordingEvictionEvent() {
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public FlushEventOpportunity flushEventOpportunity() {
            return FlushEventOpportunity.NULL;
        }

        public void threwException(IOException exception) {
        }

        public void setCachePageId(int cachePageId) {
        }

        public void close() {
            RecordingPageCacheTracer.this.evicted(this.filePageId, this.swapper);
        }
    }

    public static class Pin
    extends Event {
        private Pin(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    public static class Evict
    extends Event {
        private Evict(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    public static class Fault
    extends Event {
        private Fault(PageSwapper io, long pageId) {
            super(io, pageId);
        }
    }

    public static abstract class Event {
        public final PageSwapper io;
        public final long pageId;

        public Event(PageSwapper io, long pageId) {
            this.io = io;
            this.pageId = pageId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Event event = (Event)o;
            return this.pageId == event.pageId && !(this.io == null ? event.io != null : !this.io.equals(event.io));
        }

        public int hashCode() {
            int result = this.io != null ? this.io.hashCode() : 0;
            result = 31 * result + (int)(this.pageId ^ this.pageId >>> 32);
            return result;
        }

        public String toString() {
            return String.format("%s{io=%s, pageId=%s}", this.getClass().getSimpleName(), this.io, this.pageId);
        }
    }
}

