/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.io.fs.FileVisitors;

@RunWith(value=MockitoJUnitRunner.class)
public class ThrowExceptionsFileVisitorTest {
    @Mock
    public FileVisitor<Path> wrapped;

    @Test
    public void shouldThrowExceptionFromVisitFileFailed() throws IOException {
        IOException exception = new IOException();
        Mockito.stub((Object)((Object)this.wrapped.visitFileFailed((Path)Matchers.any(), (IOException)Matchers.any()))).toThrow((Throwable)exception);
        try {
            FileVisitors.throwExceptions(this.wrapped).visitFileFailed(null, exception);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.is((Object)exception));
        }
    }

    @Test
    public void shouldThrowExceptionFromPostVisitDirectory() throws IOException {
        IOException exception = new IOException();
        Mockito.stub((Object)((Object)this.wrapped.postVisitDirectory((Path)Matchers.any(), (IOException)Matchers.any()))).toThrow((Throwable)exception);
        try {
            FileVisitors.throwExceptions(this.wrapped).postVisitDirectory(null, exception);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)org.hamcrest.Matchers.is((Object)exception));
        }
    }
}

