/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.CloseTrackingFileSystem;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.test.rule.TestDirectory;

public abstract class FileSystemAbstractionTest {
    @Rule
    public TestDirectory dir = TestDirectory.testDirectory(this.getClass());
    protected FileSystemAbstraction fsa;
    protected File path;

    @Before
    public void before() throws Exception {
        this.fsa = this.buildFileSystemAbstraction();
        this.path = new File(this.dir.directory(), UUID.randomUUID().toString());
    }

    @After
    public void tearDown() throws Exception {
        this.fsa.close();
    }

    protected abstract FileSystemAbstraction buildFileSystemAbstraction();

    @Test
    public void shouldCreatePath() throws Exception {
        this.fsa.mkdirs(this.path);
        Assert.assertTrue((boolean)this.fsa.fileExists(this.path));
    }

    @Test
    public void shouldCreateDeepPath() throws Exception {
        this.path = new File(this.path, UUID.randomUUID() + "/" + UUID.randomUUID());
        this.fsa.mkdirs(this.path);
        Assert.assertTrue((boolean)this.fsa.fileExists(this.path));
    }

    @Test
    public void shouldCreatePathThatAlreadyExists() throws Exception {
        Assert.assertTrue((boolean)this.fsa.mkdir(this.path));
        this.fsa.mkdirs(this.path);
        Assert.assertTrue((boolean)this.fsa.fileExists(this.path));
    }

    @Test
    public void shouldCreatePathThatPointsToFile() throws Exception {
        Assert.assertTrue((boolean)this.fsa.mkdir(this.path));
        this.path = new File(this.path, "some_file");
        try (StoreChannel channel = this.fsa.create(this.path);){
            Assert.assertThat((Object)channel, (Matcher)Is.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
            this.fsa.mkdirs(this.path);
            Assert.assertTrue((boolean)this.fsa.fileExists(this.path));
        }
    }

    @Test
    public void moveToDirectoryMustMoveFile() throws Exception {
        File source = new File(this.path, "source");
        File target = new File(this.path, "target");
        File file = new File(source, "file");
        File fileAfterMove = new File(target, "file");
        this.fsa.mkdirs(source);
        this.fsa.mkdirs(target);
        this.fsa.create(file).close();
        Assert.assertTrue((boolean)this.fsa.fileExists(file));
        Assert.assertFalse((boolean)this.fsa.fileExists(fileAfterMove));
        this.fsa.moveToDirectory(file, target);
        Assert.assertFalse((boolean)this.fsa.fileExists(file));
        Assert.assertTrue((boolean)this.fsa.fileExists(fileAfterMove));
    }

    @Test
    public void moveToDirectoryMustRecursivelyMoveAllFilesInGivenDirectory() throws Exception {
        File source = new File(this.path, "source");
        File target = new File(this.path, "target");
        File file = new File(source, "file");
        File sourceAfterMove = new File(target, "source");
        File fileAfterMove = new File(sourceAfterMove, "file");
        this.fsa.mkdirs(source);
        this.fsa.mkdirs(target);
        this.fsa.create(file).close();
        Assert.assertTrue((boolean)this.fsa.fileExists(source));
        Assert.assertTrue((boolean)this.fsa.fileExists(file));
        Assert.assertFalse((boolean)this.fsa.fileExists(sourceAfterMove));
        Assert.assertFalse((boolean)this.fsa.fileExists(fileAfterMove));
        this.fsa.moveToDirectory(source, target);
        Assert.assertFalse((boolean)this.fsa.fileExists(source));
        Assert.assertFalse((boolean)this.fsa.fileExists(file));
        Assert.assertTrue((boolean)this.fsa.fileExists(sourceAfterMove));
        Assert.assertTrue((boolean)this.fsa.fileExists(fileAfterMove));
    }

    @Test
    public void deleteRecursivelyMustDeleteAllFilesInDirectory() throws Exception {
        this.fsa.mkdirs(this.path);
        File a = new File(this.path, "a");
        this.fsa.create(a).close();
        File b = new File(this.path, "b");
        this.fsa.create(b).close();
        File c = new File(this.path, "c");
        this.fsa.create(c).close();
        File d = new File(this.path, "d");
        this.fsa.create(d).close();
        this.fsa.deleteRecursively(this.path);
        Assert.assertFalse((boolean)this.fsa.fileExists(a));
        Assert.assertFalse((boolean)this.fsa.fileExists(b));
        Assert.assertFalse((boolean)this.fsa.fileExists(c));
        Assert.assertFalse((boolean)this.fsa.fileExists(d));
    }

    @Test
    public void deleteRecursivelyMustDeleteGivenDirectory() throws Exception {
        this.fsa.mkdirs(this.path);
        this.fsa.deleteRecursively(this.path);
        Assert.assertFalse((boolean)this.fsa.fileExists(this.path));
    }

    @Test
    public void deleteRecursivelyMustDeleteGivenFile() throws Exception {
        this.fsa.mkdirs(this.path);
        File file = new File(this.path, "file");
        this.fsa.create(file).close();
        this.fsa.deleteRecursively(file);
        Assert.assertFalse((boolean)this.fsa.fileExists(file));
    }

    @Test
    public void fileWatcherCreation() throws IOException {
        try (FileWatcher fileWatcher = this.fsa.fileWatcher();){
            Assert.assertNotNull((Object)fileWatcher.watch(this.dir.directory("testDirectory")));
        }
    }

    @Test
    public void closeThirdPartyFileSystemsOnClose() throws IOException {
        CloseTrackingFileSystem closeTrackingFileSystem = new CloseTrackingFileSystem();
        CloseTrackingFileSystem fileSystem = (CloseTrackingFileSystem)this.fsa.getOrCreateThirdPartyFileSystem(CloseTrackingFileSystem.class, thirdPartyFileSystemClass -> closeTrackingFileSystem);
        Assert.assertSame((Object)closeTrackingFileSystem, (Object)fileSystem);
        Assert.assertFalse((boolean)closeTrackingFileSystem.isClosed());
        this.fsa.close();
        Assert.assertTrue((boolean)closeTrackingFileSystem.isClosed());
    }
}

