/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProviderFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@ExtendWith(value={TestDirectoryExtension.class})
class BatchInsertersIT {
    @Inject
    private TestDirectory testDirectory;

    BatchInsertersIT() {
    }

    @Test
    void shouldStartBatchInserterWithRealIndexProvider() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((File)this.testDirectory.databaseDir(), BatchInsertersIT.getConfig(), BatchInsertersIT.getKernelExtensions());
        inserter.shutdown();
    }

    private static Map<String, String> getConfig() {
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_schema_provider.name(), GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName()});
    }

    private static Iterable<KernelExtensionFactory<?>> getKernelExtensions() {
        return Iterables.asIterable((Object[])new KernelExtensionFactory[]{new GenericNativeIndexProviderFactory()});
    }
}

