/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storeupgrade;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.Unzip;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Enclosed.class)
public class StoreUpgradeIT {
    private static final List<Store[]> STORES23 = Arrays.asList({new Store("0.A.6-empty.zip", 0L, 1L, StoreUpgradeIT.selectivities(new double[0]), StoreUpgradeIT.indexCounts(new long[0][]))}, {new Store("0.A.6-data.zip", 174L, 30L, StoreUpgradeIT.selectivities(1.0, 1.0, 1.0), StoreUpgradeIT.indexCounts(StoreUpgradeIT.counts(0L, 38L, 38L, 38L), StoreUpgradeIT.counts(0L, 1L, 1L, 1L), StoreUpgradeIT.counts(0L, 133L, 133L, 133L)))});
    private static final List<Store[]> STORES300 = Arrays.asList({new Store("E.H.0-empty.zip", 0L, 1L, StoreUpgradeIT.selectivities(new double[0]), StoreUpgradeIT.indexCounts(new long[0][]), "high_limit")}, {new Store("E.H.0-data.zip", 174L, 30L, StoreUpgradeIT.selectivities(1.0, 1.0, 1.0), StoreUpgradeIT.indexCounts(StoreUpgradeIT.counts(0L, 38L, 38L, 38L), StoreUpgradeIT.counts(0L, 1L, 1L, 1L), StoreUpgradeIT.counts(0L, 133L, 133L, 133L)), "high_limit")});

    private static void checkInstance(Store store, GraphDatabaseAPI db) throws KernelException {
        StoreUpgradeIT.checkProvidedParameters(store, db);
        StoreUpgradeIT.checkGlobalNodeCount(store, db);
        StoreUpgradeIT.checkLabelCounts(db);
        StoreUpgradeIT.checkIndexCounts(store, db);
    }

    private static void checkIndexCounts(Store store, GraphDatabaseAPI db) throws KernelException {
        InwardKernel kernel = (InwardKernel)db.getDependencyResolver().resolveDependency(InwardKernel.class);
        try (KernelTransaction tx = (KernelTransaction)kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());
             Statement ignore = tx.acquireStatement();){
            SchemaRead schemaRead = tx.schemaRead();
            Iterator indexes = IndexReference.sortByType(StoreUpgradeIT.getAllIndexes(schemaRead));
            Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
            int i = 0;
            while (indexes.hasNext()) {
                IndexReference reference = (IndexReference)indexes.next();
                StoreUpgradeIT.awaitOnline(schemaRead, reference);
                StoreUpgradeIT.assertDoubleLongEquals(store.indexCounts[i][0], store.indexCounts[i][1], schemaRead.indexUpdatesAndSize(reference, register));
                StoreUpgradeIT.assertDoubleLongEquals(store.indexCounts[i][2], store.indexCounts[i][3], schemaRead.indexSample(reference, register));
                double selectivity = schemaRead.indexUniqueValuesSelectivity(reference);
                Assert.assertEquals((double)store.indexSelectivity[i], (double)selectivity, (double)1.0E-7);
                ++i;
            }
        }
    }

    private static Iterator<IndexReference> getAllIndexes(SchemaRead schemaRead) {
        return schemaRead.indexesGetAll();
    }

    private static void checkLabelCounts(GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            HashMap<Label, Long> counts = new HashMap<Label, Long>();
            for (Node node : db.getAllNodes()) {
                for (Label label : node.getLabels()) {
                    Long count = (Long)counts.get(label);
                    if (count != null) {
                        counts.put(label, count + 1L);
                        continue;
                    }
                    counts.put(label, 1L);
                }
            }
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            KernelTransaction kernelTransaction = bridge.getKernelTransactionBoundToThisThread(true);
            for (Map.Entry entry : counts.entrySet()) {
                Assert.assertEquals((long)((Long)entry.getValue()), (long)kernelTransaction.dataRead().countsForNode(kernelTransaction.tokenRead().nodeLabel(((Label)entry.getKey()).name())));
            }
        }
    }

    private static void checkGlobalNodeCount(Store store, GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            KernelTransaction kernelTransaction = bridge.getKernelTransactionBoundToThisThread(true);
            Assert.assertThat((Object)kernelTransaction.dataRead().countsForNode(-1), (Matcher)Matchers.is((Object)store.expectedNodeCount));
        }
    }

    private static void checkProvidedParameters(Store store, GraphDatabaseAPI db) {
        try (Transaction ignored = db.beginTx();){
            long nodeCount = Iterables.count((Iterable)db.getAllNodes());
            Assert.assertThat((Object)nodeCount, (Matcher)Matchers.is((Object)store.expectedNodeCount));
            long indexCount = Iterables.count((Iterable)db.schema().getIndexes());
            Assert.assertThat((Object)indexCount, (Matcher)Matchers.is((Object)store.indexes()));
            TransactionIdStore txIdStore = (TransactionIdStore)db.getDependencyResolver().resolveDependency(TransactionIdStore.class);
            long lastCommittedTxId = txIdStore.getLastCommittedTransactionId();
            try (Statement statement = ((ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true).acquireStatement();){
                long countsTxId = ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getCounts().txId();
                Assert.assertEquals((long)lastCommittedTxId, (long)countsTxId);
                Assert.assertThat((Object)lastCommittedTxId, (Matcher)Matchers.is((Object)store.lastTxId));
            }
        }
    }

    private static void assertDoubleLongEquals(long expectedFirst, long expectedSecond, Register.DoubleLongRegister register) {
        long first = register.readFirst();
        long second = register.readSecond();
        String msg = String.format("Expected (%d,%d), got (%d,%d)", expectedFirst, expectedSecond, first, second);
        Assert.assertEquals((String)msg, (long)expectedFirst, (long)first);
        Assert.assertEquals((String)msg, (long)expectedSecond, (long)second);
    }

    private static double[] selectivities(double ... selectivity) {
        return selectivity;
    }

    private static long[][] indexCounts(long[] ... counts) {
        return counts;
    }

    private static long[] counts(long upgrade, long size, long unique, long sampleSize) {
        return new long[]{upgrade, size, unique, sampleSize};
    }

    private static IndexReference awaitOnline(SchemaRead schemRead, IndexReference index) throws KernelException {
        long start = System.currentTimeMillis();
        long end = start + 20000L;
        while (System.currentTimeMillis() < end) {
            switch (schemRead.indexGetState(index)) {
                case ONLINE: {
                    return index;
                }
                case FAILED: {
                    throw new IllegalStateException("Index failed instead of becoming ONLINE");
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new IllegalStateException("Index did not become ONLINE within reasonable time");
    }

    private static class Store {
        private final String resourceName;
        final long expectedNodeCount;
        final long lastTxId;
        private final double[] indexSelectivity;
        final long[][] indexCounts;
        private final String formatFamily;

        private Store(String resourceName, long expectedNodeCount, long lastTxId, double[] indexSelectivity, long[][] indexCounts) {
            this(resourceName, expectedNodeCount, lastTxId, indexSelectivity, indexCounts, "standard");
        }

        private Store(String resourceName, long expectedNodeCount, long lastTxId, double[] indexSelectivity, long[][] indexCounts, String formatFamily) {
            this.resourceName = resourceName;
            this.expectedNodeCount = expectedNodeCount;
            this.lastTxId = lastTxId;
            this.indexSelectivity = indexSelectivity;
            this.indexCounts = indexCounts;
            this.formatFamily = formatFamily;
        }

        File prepareDirectory(File databaseDirectory) throws IOException {
            if (!databaseDirectory.exists() && !databaseDirectory.mkdirs()) {
                throw new IOException("Could not create directory " + databaseDirectory);
            }
            Unzip.unzip(this.getClass(), (String)this.resourceName, (File)databaseDirectory);
            new File(databaseDirectory, "debug.log").delete();
            return databaseDirectory;
        }

        public String toString() {
            return "Store: " + this.resourceName;
        }

        long indexes() {
            return this.indexCounts.length;
        }

        String getFormatFamily() {
            return this.formatFamily;
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgrade22Test {
        @Parameterized.Parameter(value=0)
        public Store store;
        @Rule
        public final TestDirectory testDir = TestDirectory.testDirectory();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Store[]> stores() {
            return Iterables.asCollection((Iterable)Iterables.concat((Iterable[])new Iterable[]{STORES23, STORES300}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void shouldBeAbleToUpgradeAStoreWithoutIdFilesAsBackups() throws Throwable {
            File[] idFiles;
            File databaseDirectory = this.store.prepareDirectory(this.testDir.databaseDir());
            for (File idFile : idFiles = databaseDirectory.listFiles((dir1, name) -> name.endsWith(".id"))) {
                Assert.assertTrue((boolean)idFile.delete());
            }
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(this.testDir.databaseDir());
            builder.setConfig(GraphDatabaseSettings.allow_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.record_format, this.store.getFormatFamily());
            builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((DatabaseLayout)DatabaseLayout.of((File)databaseDirectory));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgradeFailingTest {
        @Rule
        public final TestDirectory testDir = TestDirectory.testDirectory();
        @Parameterized.Parameter(value=0)
        public String ignored;
        @Parameterized.Parameter(value=1)
        public String dbFileName;

        @Parameterized.Parameters(name="{0}")
        public static Collection<String[]> parameters() {
            return Arrays.asList({"on a not cleanly shutdown database", "0.A.3-to-be-recovered.zip"}, {"on a 1.9 store", "0.A.0-db.zip"}, {"on a 2.0 store", "0.A.1-db.zip"}, {"on a 2.1 store", "0.A.3-data.zip"}, {"on a 2.2 store", "0.A.5-data.zip"});
        }

        @Test
        public void migrationShouldFail() throws Throwable {
            File databaseDirectory = Unzip.unzip(this.getClass(), (String)this.dbFileName, (File)this.testDir.databaseDir());
            new File(databaseDirectory, "debug.log").delete();
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(this.testDir.databaseDir());
            builder.setConfig(GraphDatabaseSettings.allow_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            try {
                builder.newGraphDatabase();
                Assert.fail((String)"It should have failed.");
            }
            catch (RuntimeException ex) {
                Assert.assertTrue((boolean)(ex.getCause() instanceof LifecycleException));
                Throwable realException = ex.getCause().getCause();
                Assert.assertTrue((String)"Unexpected exception", (boolean)Exceptions.contains((Throwable)realException, (Class[])new Class[]{StoreUpgrader.UnexpectedUpgradingStoreVersionException.class}));
            }
        }
    }

    @RunWith(value=Parameterized.class)
    public static class StoreUpgradeTest {
        @Parameterized.Parameter(value=0)
        public Store store;
        @Rule
        public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
        @Rule
        public TestDirectory testDir = TestDirectory.testDirectory();

        @Parameterized.Parameters(name="{0}")
        public static Collection<Store[]> stores() {
            return Iterables.asCollection((Iterable)Iterables.concat((Iterable[])new Iterable[]{STORES23, STORES300}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void embeddedDatabaseShouldStartOnOlderStoreWhenUpgradeIsEnabled() throws Throwable {
            File databaseDirectory = this.store.prepareDirectory(this.testDir.databaseDir());
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(this.testDir.databaseDir());
            builder.setConfig(GraphDatabaseSettings.allow_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            builder.setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath());
            builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((DatabaseLayout)DatabaseLayout.of((File)databaseDirectory));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void serverDatabaseShouldStartOnOlderStoreWhenUpgradeIsEnabled() throws Throwable {
            File rootDir = this.testDir.directory();
            File databaseDirectory = (File)Config.defaults((Setting)GraphDatabaseSettings.data_directory, (String)rootDir.toString()).get(GraphDatabaseSettings.database_path);
            this.store.prepareDirectory(databaseDirectory);
            File configFile = new File(rootDir, "neo4j.conf");
            Properties props = new Properties();
            props.putAll((Map<?, ?>)ServerTestUtils.getDefaultRelativeProperties());
            props.setProperty(GraphDatabaseSettings.data_directory.name(), rootDir.getAbsolutePath());
            props.setProperty(GraphDatabaseSettings.logs_directory.name(), rootDir.getAbsolutePath());
            props.setProperty(GraphDatabaseSettings.allow_upgrade.name(), "true");
            props.setProperty(GraphDatabaseSettings.pagecache_memory.name(), "8m");
            props.setProperty(new HttpConnector((String)"http").type.name(), "HTTP");
            props.setProperty(new HttpConnector((String)"http").enabled.name(), "true");
            props.setProperty(new HttpConnector((String)"http").listen_address.name(), "localhost:0");
            props.setProperty(new HttpConnector((String)"https").enabled.name(), "false");
            props.setProperty(OnlineBackupSettings.online_backup_enabled.name(), "false");
            props.setProperty(new BoltConnector((String)"bolt").enabled.name(), "false");
            try (FileWriter writer = new FileWriter(configFile);){
                props.store(writer, "");
            }
            CommunityBootstrapper bootstrapper = new CommunityBootstrapper();
            try {
                bootstrapper.start(rootDir.getAbsoluteFile(), Optional.of(configFile), Collections.emptyMap());
                Assert.assertTrue((boolean)bootstrapper.isRunning());
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)bootstrapper.getServer().getDatabase().getGraph());
            }
            finally {
                bootstrapper.stop();
            }
            StoreAssertions.assertConsistentStore((DatabaseLayout)DatabaseLayout.of((File)databaseDirectory));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        public void migratingOlderDataAndThanStartAClusterUsingTheNewerDataShouldWork() throws Throwable {
            File storeDir = this.testDir.storeDir("initialData");
            File databaseDirectory = this.store.prepareDirectory(this.testDir.databaseDir(storeDir));
            TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
            GraphDatabaseBuilder builder = factory.newEmbeddedDatabaseBuilder(databaseDirectory);
            builder.setConfig(GraphDatabaseSettings.allow_upgrade, "true");
            builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
            builder.setConfig(GraphDatabaseSettings.logs_directory, this.testDir.directory("logs").getAbsolutePath());
            builder.setConfig(OnlineBackupSettings.online_backup_enabled, "false");
            GraphDatabaseService db = builder.newGraphDatabase();
            try {
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)db);
            }
            finally {
                db.shutdown();
            }
            StoreAssertions.assertConsistentStore((DatabaseLayout)DatabaseLayout.of((File)databaseDirectory));
            File haDir = this.testDir.storeDir("ha-stuff");
            ClusterManager clusterManager = new ClusterManager.Builder(haDir).withSeedDir(databaseDirectory).withCluster(ClusterManager.clusterOfSize((int)2)).build();
            try {
                clusterManager.start();
                ClusterManager.ManagedCluster cluster = clusterManager.getCluster();
                cluster.await(ClusterManager.allSeesAllAsAvailable());
                HighlyAvailableGraphDatabase master = cluster.getMaster();
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)master);
                HighlyAvailableGraphDatabase slave = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
                StoreUpgradeIT.checkInstance(this.store, (GraphDatabaseAPI)slave);
                clusterManager.safeShutdown();
                StoreAssertions.assertConsistentStore((DatabaseLayout)master.databaseLayout());
                StoreAssertions.assertConsistentStore((DatabaseLayout)slave.databaseLayout());
            }
            finally {
                clusterManager.safeShutdown();
            }
        }
    }
}

