/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.operator.OperatorCreationException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogProvider;
import org.neo4j.ssl.HostnameVerificationHelper;
import org.neo4j.ssl.SecureClient;
import org.neo4j.ssl.SecureServer;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.test.rule.TestDirectory;

public class SslPolicyLoaderIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private static final LogProvider LOG_PROVIDER = FormattedLogProvider.withDefaultLogLevel((Level)Level.DEBUG).toOutputStream((OutputStream)System.out);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void certificatesWithInvalidCommonNameAreRejected() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException {
        Config serverConfig = HostnameVerificationHelper.aConfig("invalid-not-localhost", this.testDirectory);
        Config clientConfig = HostnameVerificationHelper.aConfig("localhost", this.testDirectory);
        HostnameVerificationHelper.trust(serverConfig, clientConfig);
        HostnameVerificationHelper.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy("fakePolicy");
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy("fakePolicy");
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        int port = secureServer.port();
        SecureClient secureClient = new SecureClient(clientPolicy);
        try {
            secureClient.connect(port);
            secureClient.sslHandshakeFuture().get(1L, TimeUnit.MINUTES);
        }
        catch (ExecutionException e) {
            String expectedMessage = "No subject alternative DNS name matching localhost found.";
            Assert.assertThat(this.causes(e).map(Throwable::getMessage).collect(Collectors.toList()), (Matcher)IsCollectionContaining.hasItem((Object)expectedMessage));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        finally {
            secureServer.stop();
        }
    }

    @Test
    public void normalBehaviourIfServerCertificateMatchesClientExpectation() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException, TimeoutException, ExecutionException {
        Config serverConfig = HostnameVerificationHelper.aConfig("localhost", this.testDirectory);
        Config clientConfig = HostnameVerificationHelper.aConfig("invalid-localhost", this.testDirectory);
        HostnameVerificationHelper.trust(serverConfig, clientConfig);
        HostnameVerificationHelper.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy("fakePolicy");
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy("fakePolicy");
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        SecureClient secureClient = new SecureClient(clientPolicy);
        this.clientCanCommunicateWithServer(secureClient, secureServer);
    }

    @Test
    public void legacyPolicyDoesNotHaveHostnameVerification() throws GeneralSecurityException, IOException, OperatorCreationException, InterruptedException, TimeoutException, ExecutionException {
        Config serverConfig = HostnameVerificationHelper.aConfig("invalid-localhost", this.testDirectory);
        Config clientConfig = HostnameVerificationHelper.aConfig("invalid-localhost", this.testDirectory);
        HostnameVerificationHelper.trust(serverConfig, clientConfig);
        HostnameVerificationHelper.trust(clientConfig, serverConfig);
        SslPolicy serverPolicy = SslPolicyLoader.create((Config)serverConfig, (LogProvider)LOG_PROVIDER).getPolicy("legacy");
        SslPolicy clientPolicy = SslPolicyLoader.create((Config)clientConfig, (LogProvider)LOG_PROVIDER).getPolicy("legacy");
        SecureServer secureServer = new SecureServer(serverPolicy);
        secureServer.start();
        SecureClient secureClient = new SecureClient(clientPolicy);
        this.clientCanCommunicateWithServer(secureClient, secureServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientCanCommunicateWithServer(SecureClient secureClient, SecureServer secureServer) throws InterruptedException, TimeoutException, ExecutionException {
        int port = secureServer.port();
        try {
            secureClient.connect(port);
            ByteBuf request = ByteBufAllocator.DEFAULT.buffer().writeBytes(new byte[]{1, 2, 3, 4});
            secureClient.channel().writeAndFlush((Object)request);
            ByteBuf expected = ByteBufAllocator.DEFAULT.buffer().writeBytes(SecureServer.RESPONSE);
            Assert.assertTrue((boolean)secureClient.sslHandshakeFuture().get(1L, TimeUnit.MINUTES).isActive());
            secureClient.assertResponse(expected);
        }
        finally {
            secureServer.stop();
        }
    }

    private Stream<Throwable> causes(Throwable throwable) {
        Stream<Throwable> thisStream = Stream.of(throwable).filter(Objects::nonNull);
        if (throwable != null && throwable.getCause() != null) {
            return Stream.concat(thisStream, this.causes(throwable.getCause()));
        }
        return thisStream;
    }
}

