/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ssl;

import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.util.HashMap;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ssl.SslPolicyConfig;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.configuration.ssl.SslSystemSettings;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.ssl.SslPolicy;
import org.neo4j.ssl.SslResource;

public class SslContextFactory {
    public static SslPolicy makeSslPolicy(SslResource sslResource, SslParameters params) {
        return SslContextFactory.makeSslPolicy(sslResource, SslProvider.JDK, params.protocols, params.ciphers);
    }

    public static SslPolicy makeSslPolicy(SslResource sslResource, SslProvider sslProvider) {
        return SslContextFactory.makeSslPolicy(sslResource, sslProvider, null, null);
    }

    public static SslPolicy makeSslPolicy(SslResource sslResource) {
        return SslContextFactory.makeSslPolicy(sslResource, SslProvider.JDK, null, null);
    }

    public static SslPolicy makeSslPolicy(SslResource sslResource, SslProvider sslProvider, String protocols, String ciphers) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(SslSystemSettings.netty_ssl_provider.name(), sslProvider.name());
        SslPolicyConfig policyConfig = new SslPolicyConfig("default");
        File baseDirectory = sslResource.privateKey().getParentFile();
        new File(baseDirectory, "trusted").mkdirs();
        new File(baseDirectory, "revoked").mkdirs();
        config.put(policyConfig.base_directory.name(), baseDirectory.getPath());
        config.put(policyConfig.private_key.name(), sslResource.privateKey().getPath());
        config.put(policyConfig.public_certificate.name(), sslResource.publicCertificate().getPath());
        config.put(policyConfig.trusted_dir.name(), sslResource.trustedDirectory().getPath());
        config.put(policyConfig.revoked_dir.name(), sslResource.revokedDirectory().getPath());
        config.put(policyConfig.verify_hostname.name(), "false");
        if (protocols != null) {
            config.put(policyConfig.tls_versions.name(), protocols);
        }
        if (ciphers != null) {
            config.put(policyConfig.ciphers.name(), ciphers);
        }
        SslPolicyLoader sslPolicyFactory = SslPolicyLoader.create((Config)Config.fromSettings(config).build(), (LogProvider)NullLogProvider.getInstance());
        return sslPolicyFactory.getPolicy("default");
    }

    public static class SslParameters
    implements Ciphers {
        private String protocols;
        private String ciphers;

        private SslParameters(String protocols, String ciphers) {
            this.protocols = protocols;
            this.ciphers = ciphers;
        }

        public static Ciphers protocols(String ... protocols) {
            return new SslParameters(SslParameters.joinOrNull(protocols), null);
        }

        @Override
        public SslParameters ciphers(String ... ciphers) {
            this.ciphers = SslParameters.joinOrNull(ciphers);
            return this;
        }

        private static String joinOrNull(String[] parts) {
            return parts.length > 0 ? String.join((CharSequence)",", parts) : null;
        }

        public String toString() {
            return "SslParameters{protocols='" + this.protocols + '\'' + ", ciphers='" + this.ciphers + '\'' + '}';
        }
    }

    public static interface Ciphers {
        public SslParameters ciphers(String ... var1);
    }
}

